/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.StarterApplication;
import io.github.kloping.MySpringTool.annotations.http.Callback;
import io.github.kloping.MySpringTool.annotations.http.CookieFrom;
import io.github.kloping.MySpringTool.annotations.http.CookieValue;
import io.github.kloping.MySpringTool.annotations.http.DefaultValue;
import io.github.kloping.MySpringTool.annotations.http.FileParm;
import io.github.kloping.MySpringTool.annotations.http.GetPath;
import io.github.kloping.MySpringTool.annotations.http.Headers;
import io.github.kloping.MySpringTool.annotations.http.HttpClient;
import io.github.kloping.MySpringTool.annotations.http.IgnoreHttpErrors;
import io.github.kloping.MySpringTool.annotations.http.ParamBody;
import io.github.kloping.MySpringTool.annotations.http.ParamName;
import io.github.kloping.MySpringTool.annotations.http.PathValue;
import io.github.kloping.MySpringTool.annotations.http.PostPath;
import io.github.kloping.MySpringTool.annotations.http.RequestBody;
import io.github.kloping.MySpringTool.annotations.http.RequestData;
import io.github.kloping.MySpringTool.annotations.http.RequestPath;
import io.github.kloping.MySpringTool.entity.KeyVals;
import io.github.kloping.MySpringTool.entity.Params;
import io.github.kloping.MySpringTool.h1.impl.AutomaticWiringParamsImpl;
import io.github.kloping.MySpringTool.h1.impl.component.HttpStatusReceiver;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ClassManager;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.MySpringTool.interfaces.component.HttpClientManager;
import io.github.kloping.object.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.nodes.Document;

public class HttpClientManagerImpl
implements HttpClientManager {
    public static final String SPLIT = "/";
    private Setting setting;
    private Map<Method, Invoker> methodInks = new ConcurrentHashMap<Method, Invoker>();
    private Logger logger;
    private List<HttpStatusReceiver> receivers = new LinkedList<HttpStatusReceiver>();
    public static String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36 Edg/95.0.1020.53";
    private static final AutomaticWiringParamsImpl AWP = new AutomaticWiringParamsImpl();
    private static final String AND = "&";
    private static final String DO = "?";

    public HttpClientManagerImpl(Setting setting, ClassManager classManager) {
        this.setting = setting;
        classManager.registeredAnnotation(HttpClient.class, this);
        setting.getSTARTED_RUNNABLE().add(() -> {
            this.logger = setting.getContextManager().getContextEntity(Logger.class);
        });
    }

    @Override
    public void addHttpStatusReceiver(HttpStatusReceiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public void manager(Method method, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        method.setAccessible(true);
        String host = method.getDeclaringClass().getDeclaredAnnotation(HttpClient.class).value();
        Connection.Method mt = null;
        String path = null;
        if (method.isAnnotationPresent(GetPath.class)) {
            path = method.getAnnotation(GetPath.class).value();
            mt = Connection.Method.GET;
        } else if (method.isAnnotationPresent(PostPath.class)) {
            path = method.getAnnotation(PostPath.class).value();
            mt = Connection.Method.POST;
        } else if (method.isAnnotationPresent(RequestPath.class)) {
            RequestPath rp = method.getAnnotation(RequestPath.class);
            path = rp.value();
            mt = rp.method();
        }
        path = this.ali(host, path);
        this.loadMethod(method, path, mt);
    }

    private String ali(String host, String path) {
        if (!host.endsWith(SPLIT)) {
            host = host + SPLIT;
        }
        if (path.startsWith(SPLIT)) {
            path = path.substring(1, path.length());
        }
        if (path.endsWith(SPLIT)) {
            path = path.substring(0, path.length() - 1);
        }
        return host + path;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object o = null;
        if (this.methodInks.containsKey(method)) {
            o = this.methodInks.get(method).run(args);
        }
        return o;
    }

    @Override
    public void manager(Class cla, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        if (!cla.isInterface()) {
            return;
        }
        contextManager.append(cla, Proxy.newProxyInstance(cla.getClassLoader(), new Class[]{cla}, (InvocationHandler)this), UUID.randomUUID().toString());
        for (Method declaredMethod : cla.getDeclaredMethods()) {
            this.manager(declaredMethod, contextManager);
        }
    }

    private void loadMethod(Method method, String url, Connection.Method type2) {
        Method[] methods = null;
        if (method.isAnnotationPresent(Callback.class)) {
            Callback callback = method.getDeclaredAnnotation(Callback.class);
            String[] ss = callback.value();
            methods = this.loadMethods(ss);
        }
        Method[] finalMethods = methods;
        this.methodInks.put(method, new Invoker(url, method, type2, methods));
    }

    private void loadConf(Connection connection, Method method, Object[] objects) {
        if (method.isAnnotationPresent(IgnoreHttpErrors.class)) {
            connection.ignoreHttpErrors(true);
        }
    }

    private void loadBody(Connection connection, Method method, Object[] objects) {
        Parameter[] parameters = method.getParameters();
        block4: for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> cla = parameter.getType();
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            RequestBody rb = parameter.getAnnotation(RequestBody.class);
            switch (rb.type()) {
                case toString: {
                    connection.requestBody(objects[i].toString());
                    continue block4;
                }
                case json: {
                    connection.requestBody(JSON.toJSONString((Object)objects[i]));
                    continue block4;
                }
            }
        }
    }

    private void loadData(Connection connection, Method method, Object[] objects) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (objects[i] == null) continue;
            Parameter parameter = parameters[i];
            Class<?> cla = parameter.getType();
            if (parameter.isAnnotationPresent(RequestData.class)) {
                if (cla == Map.Entry.class) {
                    Map.Entry entry = (Map.Entry)objects[i];
                    connection.data(entry.getKey().toString(), entry.getValue().toString());
                    continue;
                }
                if (cla == String.class) {
                    connection.data(objects[i].toString());
                    continue;
                }
                if (!(objects[i] instanceof KeyVals)) continue;
                KeyVals data = (KeyVals)objects[i];
                for (HttpConnection.KeyVal value : data.values()) {
                    connection.data(value.key(), value.value(), value.inputStream(), value.contentType());
                }
                continue;
            }
            if (!parameter.isAnnotationPresent(FileParm.class)) continue;
            if (cla == byte[].class) {
                byte[] bytes = (byte[])objects[i];
                FileParm fileParm = parameter.getDeclaredAnnotation(FileParm.class);
                if (!fileParm.type().isEmpty()) {
                    connection.data(fileParm.value(), fileParm.name(), (InputStream)new ByteArrayInputStream(bytes), fileParm.type());
                    continue;
                }
                connection.data(fileParm.value(), fileParm.name(), (InputStream)new ByteArrayInputStream(bytes));
                continue;
            }
            if (cla != HttpConnection.KeyVal.class) continue;
            HttpConnection.KeyVal keyVal = (HttpConnection.KeyVal)objects[i];
            connection.data(keyVal.key(), keyVal.value(), keyVal.inputStream(), keyVal.contentType());
        }
    }

    private void loadCookie(Connection connection, Method method, String trueUrl, Object[] objects) throws Exception {
        CookieStore cookieStore = connection.cookieStore();
        if (method.isAnnotationPresent(CookieFrom.class)) {
            CookieFrom cf = method.getAnnotation(CookieFrom.class);
            cookieStore = this.getCookieStore(cf.value(), Connection.Method.valueOf((String)cf.method()), trueUrl, method, objects);
            connection.cookieStore(cookieStore);
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            ParameterizedType type2;
            Class t1;
            Parameter parameter = parameters[i];
            Class<?> cla = parameter.getType();
            if (parameter.isAnnotationPresent(CookieValue.class)) {
                Map.Entry entry = (Map.Entry)objects[i];
                connection.cookie((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (cla == CookieStore.class) {
                CookieStore store = (CookieStore)objects[i];
                HttpClientManagerImpl.addCookieStore(store, cookieStore);
                continue;
            }
            if (!ObjectUtils.isSuperOrInterface(cla, Collection.class) || (t1 = (Class)(type2 = (ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0]) != CookieStore.class) continue;
            Collection cookieStores = (Collection)objects[i];
            for (CookieStore store : cookieStores) {
                HttpClientManagerImpl.addCookieStore(store, cookieStore);
            }
        }
    }

    private Method[] loadMethods(String[] ss) {
        int i = 0;
        Method[] methods = new Method[ss.length];
        for (String s : ss) {
            int i0 = s.lastIndexOf(".");
            String methodName = s.substring(i0 + 1, s.length());
            String className = s.substring(0, i0);
            try {
                Class<?> cla = StarterApplication.SCAN_LOADER.loadClass(className);
                Method method = null;
                for (Method declaredMethod : cla.getDeclaredMethods()) {
                    if (!declaredMethod.getName().equals(methodName)) continue;
                    method = declaredMethod;
                }
                if (method == null) {
                    methods[i] = null;
                    continue;
                }
                method.setAccessible(true);
                methods[i] = method;
            }
            catch (Exception e) {
                this.logger.Log(e.getMessage() + PartUtils.getExceptionLine(e), -1);
            }
            ++i;
        }
        return methods;
    }

    private static void addCookieStore(CookieStore from, CookieStore to) throws IllegalAccessException, NoSuchFieldException {
        Field field = from.getClass().getDeclaredField("uriIndex");
        field.setAccessible(true);
        Map uriIndex = (Map)field.get(from);
        List<HttpCookie> httpCookies = from.getCookies();
        uriIndex.forEach((k, v) -> {
            for (HttpCookie httpCookie : v) {
                to.add((URI)k, httpCookie);
            }
        });
    }

    private Connection getConnection(String trueUrl, Map<String, String> headers) throws Exception {
        if (trueUrl.startsWith(SPLIT)) {
            trueUrl = trueUrl.substring(1);
        }
        Connection connection = null;
        connection = Jsoup.connect((String)trueUrl).ignoreHttpErrors(true).ignoreContentType(true).userAgent(userAgent);
        if (headers != null) {
            connection = connection.headers(headers);
        }
        return connection;
    }

    private String loadPostBody(Method method, Object[] objects) throws Exception {
        Parameter[] parameters = method.getParameters();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(RequestBody.class)) continue;
            RequestBody rb = parameters[i].getAnnotation(RequestBody.class);
            switch (rb.type()) {
                case toString: {
                    sb.append(objects[i]);
                    continue block4;
                }
                case json: {
                    sb.append(JSON.toJSONString((Object)objects[i]));
                    continue block4;
                }
            }
        }
        return sb.toString();
    }

    private <T> T toType(Class<T> cls, Document doc, Method[] methods) {
        String finalText;
        String text = finalText = doc.body().text();
        if (methods != null) {
            for (Method method : methods) {
                if (method == null) continue;
                try {
                    Object[] os = AWP.wiring(method, doc, text);
                    Object out = method.invoke(null, os);
                    if (out.getClass() == String.class) {
                        text = out.toString();
                        continue;
                    }
                    if (out.getClass() != cls) continue;
                    return (T)out;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage() + PartUtils.getExceptionLine(e));
                }
            }
        }
        try {
            if (cls == String.class) {
                return (T)(text == null ? finalText : text);
            }
            if (cls.isArray()) {
                return (T)JSON.parseArray((String)(text == null ? finalText : text)).toJavaObject(cls);
            }
            return (T)JSON.parseObject((String)(text == null ? finalText : text)).toJavaObject(cls);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() == null ? "" : e.getMessage() + "The data returned by the request could not be converted to the specified type( " + cls.getName() + ")\n" + PartUtils.getExceptionLine(e));
            return null;
        }
    }

    private CookieStore getCookieStore(String[] urls, Connection.Method method, String url, Method m0, Object ... objects) throws IOException, URISyntaxException {
        CookieStore store = null;
        for (String u1 : urls) {
            try {
                Connection connection = null;
                CookieStore sc1 = null;
                if ("this".equals(u1.trim().toLowerCase())) {
                    u1 = url.trim();
                }
                connection = this.getConnection(u1, this.getHeaders(m0, objects));
                if (method == Connection.Method.GET) {
                    connection.get();
                } else if (method == Connection.Method.POST) {
                    connection.post();
                }
                sc1 = connection.cookieStore();
                if (store == null) {
                    store = sc1;
                    continue;
                }
                List<HttpCookie> httpCookies = sc1.getCookies();
                for (int i1 = 0; i1 < httpCookies.size(); ++i1) {
                    store.add(store.getURIs().get(i1), httpCookies.get(i1));
                }
            }
            catch (Exception e) {
                this.logger.Log("get Cookie Failed From: " + u1, 2);
            }
        }
        return store;
    }

    private String getGetUrl(String url, Method method, Object ... objects) {
        Parameter[] parameters = method.getParameters();
        StringBuilder sb_end = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        sb_end.append(url);
        for (int i = 0; i < parameters.length; ++i) {
            Annotation pn;
            if (objects[i] instanceof Params) {
                Params params = (Params)objects[i];
                params.getParams().forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append(AND));
                continue;
            }
            if (parameters[i].isAnnotationPresent(ParamName.class)) {
                pn = parameters[i].getAnnotation(ParamName.class);
                String k2 = pn.value();
                Object v2 = objects[i];
                if (v2 == null) {
                    if (parameters[i].isAnnotationPresent(DefaultValue.class)) {
                        DefaultValue value = parameters[i].getDeclaredAnnotation(DefaultValue.class);
                        v2 = value.value();
                    }
                } else {
                    v2 = v2.toString();
                }
                sb.append(k2).append("=").append(v2).append(AND);
                continue;
            }
            if (parameters[i].isAnnotationPresent(ParamBody.class)) {
                pn = parameters[i].getAnnotation(ParamBody.class);
                JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)objects[i]));
                jo.forEach((k, v) -> sb.append((String)k).append("=").append(v).append(AND));
                continue;
            }
            if (!parameters[i].isAnnotationPresent(PathValue.class)) continue;
            pn = parameters[i].getAnnotation(PathValue.class);
            if (pn.value() == null || pn.value().isEmpty()) {
                if (!sb_end.toString().endsWith(SPLIT)) {
                    sb_end.append(SPLIT);
                }
                sb_end.append(objects[i].toString());
                continue;
            }
            String name = pn.value();
            name = "{" + name + "}";
            replaceMap.put(name, objects[i]);
        }
        if (sb.toString().endsWith(DO)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith(AND)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb_end.append(DO);
        sb_end.append(sb.toString());
        String url0 = sb_end.toString();
        if (url0.startsWith(SPLIT)) {
            url0 = url0.substring(1);
        }
        if (url0.endsWith(DO)) {
            url0 = url0.substring(0, url0.length() - 1);
        }
        for (String s : replaceMap.keySet()) {
            url0 = url0.replace(s, replaceMap.get(s).toString());
        }
        return url0;
    }

    private Map<String, String> getHeaders(Method method, Object ... objects) {
        Headers headers;
        String s;
        Class<?> cn0 = method.getDeclaringClass();
        Parameter[] parameters = method.getParameters();
        Map<String, String> map = new HashMap<String, String>();
        int i = 0;
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Headers.class)) {
                try {
                    Map map2;
                    if (Map.class.isAssignableFrom(parameter.getType()) && (map2 = (Map)objects[i]).keySet().iterator().next() instanceof String && map2.values().iterator().next() instanceof String) {
                        map = map2;
                    }
                }
                catch (Exception e) {
                    this.logger.Log("The Parameter Type not is Map<String,String>", 2);
                }
            }
            ++i;
        }
        if (cn0.isAnnotationPresent(Headers.class) && (s = (headers = method.getDeclaringClass().getDeclaredAnnotation(Headers.class)).value()) != null && !s.isEmpty()) {
            try {
                AccessibleObject field = HttpClientManagerImpl.parse(s);
                Object o = this.getValue(field, cn0);
                if (o instanceof Map) {
                    Map m = (Map)o;
                    map.putAll(m);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.error("parse error at " + cn0 + " Annotation @Headers");
            }
        }
        return map;
    }

    private Object getValue(AccessibleObject ao, Class c) throws Throwable {
        if (ao == null) {
            return null;
        }
        ao.setAccessible(true);
        ContextManager contextManager = this.setting.getContextManager();
        if (ao instanceof Method) {
            Method method = (Method)ao;
            Object o = method.invoke(contextManager.getContextEntity(method.getDeclaringClass()), new Object[0]);
            return o;
        }
        if (ao instanceof Field) {
            Field field = (Field)ao;
            Object o = field.get(contextManager.getContextEntity(field.getDeclaringClass()));
            return o;
        }
        return null;
    }

    private static final AccessibleObject parse(String str) throws ClassNotFoundException {
        AccessibleObject accessibleObject = null;
        int i0 = str.lastIndexOf(".");
        String clan = str.substring(0, i0);
        String fn = str.substring(i0 + 1);
        Class<?> cl0 = Class.forName(clan);
        try {
            accessibleObject = cl0.getDeclaredField(fn);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (accessibleObject == null) {
            try {
                accessibleObject = cl0.getDeclaredMethod(fn, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return accessibleObject;
    }

    private class Invoker {
        private String url;
        private Method method;
        private Connection.Method type;
        private Method[] methods;

        public Invoker(String url, Method method, Connection.Method type2, Method[] methods) {
            this.url = url;
            this.method = method;
            this.type = type2;
            this.methods = methods;
        }

        private Object run(Object ... objects) {
            Class<?> rtype = this.method.getReturnType();
            Class<?> dType = this.method.getDeclaringClass();
            try {
                String finalUrl = HttpClientManagerImpl.this.getGetUrl(this.url, this.method, objects);
                Connection connection = null;
                connection = HttpClientManagerImpl.this.getConnection(finalUrl, HttpClientManagerImpl.this.getHeaders(this.method, objects));
                connection.method(this.type);
                HttpClientManagerImpl.this.loadConf(connection, this.method, objects);
                HttpClientManagerImpl.this.loadBody(connection, this.method, objects);
                HttpClientManagerImpl.this.loadData(connection, this.method, objects);
                HttpClientManagerImpl.this.loadCookie(connection, this.method, finalUrl, objects);
                Connection.Response response = connection.execute();
                Document doc = response.parse();
                int status = response.statusCode();
                if (status < 200 || status >= 400) {
                    HttpClientManagerImpl.this.logger.error(new HttpStatusException("HTTP error fetching URL", status, connection.request().url().toString()).getMessage());
                }
                Object o = null;
                o = rtype == Void.TYPE ? null : (rtype == Document.class ? response.parse() : (rtype == byte[].class ? (Object)response.bodyAsBytes() : (rtype == CookieStore.class ? connection.cookieStore() : HttpClientManagerImpl.this.toType(rtype, doc, this.methods))));
                Document finalO = o;
                for (HttpStatusReceiver receiver : HttpClientManagerImpl.this.receivers) {
                    receiver.receive(finalUrl, status, dType, this.method, this.type, rtype, finalO, doc);
                }
                return o;
            }
            catch (Exception e) {
                HttpClientManagerImpl.this.logger.error(e.getLocalizedMessage() + "\n" + PartUtils.getExceptionLine(e));
                for (HttpStatusReceiver receiver : HttpClientManagerImpl.this.receivers) {
                    receiver.receive(this.url, null, dType, this.method, this.type, rtype, null, null);
                }
                return null;
            }
        }
    }
}

