/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool;

import io.github.kloping.MySpringTool.Starter;
import io.github.kloping.MySpringTool.exceptions.NoRunException;
import io.github.kloping.map.MapUtils;
import io.github.kloping.object.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class PartUtils {
    public static final SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final Map<Class<?>, List<Class>> father2son = new ConcurrentHashMap();

    public static Set<Class<?>> getClassName(String packageName, boolean isRecursion) {
        String packagePath;
        Set<String> classNames = null;
        ClassLoader loader = Starter.class.getClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String protocol = url.getProtocol().trim();
            if ("file".equals(protocol)) {
                classNames = PartUtils.getClassNameFromDir(url.getPath(), packageName, isRecursion);
            } else if ("jar".equals(protocol)) {
                JarFile jarFile = null;
                try {
                    jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (Exception e) {
                    Starter.Log("\u5b58\u5728\u4e00\u4e2a\u5f02\u5e38(Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
                }
                if (jarFile != null) {
                    classNames = PartUtils.getClassNameFromJar(jarFile.entries(), packageName, isRecursion);
                }
            }
        } else {
            classNames = PartUtils.getClassNameFromJars(((URLClassLoader)loader).getURLs(), packageName, isRecursion);
        }
        System.out.println(classNames);
        CopyOnWriteArraySet classes = new CopyOnWriteArraySet();
        for (String name : classNames) {
            try {
                Class<?> cla = loader.loadClass(name);
                classes.add(cla);
            }
            catch (ClassNotFoundException e) {
                Starter.Log("\u5b58\u5728\u4e00\u4e2a\u5f02\u5e38(Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
            }
        }
        return classes;
    }

    public static Set<String> getClassNameFromDir(String filePath, String packageName, boolean isRecursion) {
        File[] files;
        HashSet<String> className = new HashSet<String>();
        File file = new File(filePath);
        for (File childFile : files = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!isRecursion) continue;
                className.addAll(PartUtils.getClassNameFromDir(childFile.getPath(), packageName + "." + childFile.getName(), isRecursion));
                continue;
            }
            String fileName = childFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            className.add(packageName + "." + fileName.replace(".class", ""));
        }
        return className;
    }

    public static Set<String> getClassNameFromJar(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        return PartUtils.getResource0(jarEntries, packageName, isRecursion);
    }

    public static Set<String> getResource0(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entryName;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(entryName = jarEntry.getName().replaceAll("/", ".")).endsWith(".class") || entryName.contains("$") || !entryName.startsWith(packageName)) continue;
            entryName = entryName.replace(".class", "");
            if (isRecursion) {
                classNames.add(entryName);
                continue;
            }
            if (entryName.replace(packageName + ".", "").contains(".")) continue;
            classNames.add(entryName);
        }
        return classNames;
    }

    public static Set<String> getClassNameFromJars(URL[] urls, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            if (classPath.endsWith("classes/")) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            }
            catch (IOException e) {
                Starter.Log("\u5b58\u5728\u4e00\u4e2a\u5f02\u5e38(Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
            }
            if (jarFile == null) continue;
            classNames.addAll(PartUtils.getClassNameFromJar(jarFile.entries(), packageName, isRecursion));
        }
        return classNames;
    }

    public static String getExceptionLine(Throwable e) {
        try {
            Method method = Throwable.class.getDeclaredMethod("getOurStackTrace", new Class[0]);
            method.setAccessible(true);
            Object[] objects = (Object[])method.invoke((Object)e, new Object[0]);
            StringBuilder sb = new StringBuilder("\r\n");
            for (Object o : objects) {
                sb.append(" at ").append(o.toString()).append("\r\n\t");
            }
            return sb.toString();
        }
        catch (Exception e1) {
            return "??";
        }
    }

    public static void getTargetException(InvocationTargetException e) {
        InvocationTargetException ite = e;
        if (ite.getTargetException().getClass() == NoRunException.class) {
            NoRunException exception = (NoRunException)ite.getTargetException();
            Starter.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + exception.getMessage(), 2);
        } else {
            Starter.Log("\u5b58\u5728\u6620\u5c04\u4e00\u4e2a\u5f02\u5e38(Has a Invoke Exception)=>" + ite.getTargetException() + " at " + PartUtils.getExceptionLine(ite.getTargetException()), -1);
        }
    }

    public static Class<?>[] ObjectsToClasses(Object ... objs) {
        Class[] classes = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            classes[i] = objs[i].getClass();
        }
        return classes;
    }

    public static long getTimeFromNowTo(int hour, int mini, int mil) {
        Date date = null;
        try {
            String p1 = String.format("%s-%s-%s-%s-%s-%s", PartUtils.getYear(), PartUtils.getMon(), PartUtils.getDay(), hour, mini, mil);
            date = myFmt.parse(p1);
        }
        catch (Exception p1) {
            // empty catch block
        }
        long millis = date.getTime();
        long now = System.currentTimeMillis();
        return millis - now;
    }

    public static int getYear() {
        String s = myFmt.format(new Date());
        return Integer.parseInt(s.substring(0, 4));
    }

    public static int getMon() {
        String s = myFmt.format(new Date());
        return Integer.parseInt(s.substring(5, 7));
    }

    public static int getDay() {
        String s = myFmt.format(new Date());
        return Integer.parseInt(s.substring(8, 10));
    }

    public static <K, V> Map.Entry<K, V> getEntry(final K k, final V v) {
        Map.Entry entry = new Map.Entry<K, V>(){
            final K _k;
            V _v;
            {
                this._k = k;
                this._v = v;
            }

            @Override
            public K getKey() {
                return this._k;
            }

            @Override
            public V getValue() {
                return this._v;
            }

            @Override
            public V setValue(V v2) {
                Object v1 = this._v;
                this._v = v2;
                return v1;
            }
        };
        return entry;
    }

    public static boolean superOrImpl(Class<?> father, Class<?> son) {
        try {
            if (father2son.get(father).contains(son)) {
                Starter.Log("\u4ece\u5386\u53f2\u5339\u914d\u77e5\u9053 " + father + " \u5339\u914d\u4e0e=>" + son, 0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean k = ObjectUtils.isSuper(son, father);
        if (!k) {
            k = ObjectUtils.isInterface(son, father);
        }
        if (k) {
            PartUtils.appendFather2Son(father, son);
        }
        return k;
    }

    public static void appendFather2Son(Class<?> father, Class<?> son) {
        MapUtils.append(father2son, father, son, CopyOnWriteArrayList.class);
    }

    public static boolean isInterfaces(Class<?>[] classes1, Class<?> cla) {
        if (classes1 == null || classes1.length == 0) {
            return false;
        }
        for (Class<?> c : classes1) {
            if (c == cla) {
                return true;
            }
            if (!PartUtils.isInterfaces(c.getInterfaces(), cla)) continue;
            return true;
        }
        return false;
    }

    public static String filter(String path, Class cla) {
        if (path.equals(".") || path.equals("/") || path.equals("./") || path.trim().isEmpty()) {
            path = cla.getName().substring(0, cla.getName().indexOf("."));
        }
        return path;
    }

    public static void check(String scanPath) {
        try {
            if (Starter.class.getClassLoader().getResources(scanPath) == null) {
                throw new RuntimeException("\u6b32\u626b\u63cf\u7684\u5305\u540d\u4e0d\u5b58\u5728");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                throw new RuntimeException("\u6b32\u626b\u63cf\u7684\u5305\u540d\u4e0d\u5b58\u5728");
            }
            catch (Throwable throwable) {
                System.exit(0);
                throw throwable;
            }
        }
    }

    public static Class<?>[] getAllInterfaceOrSupers(Class<?> cla) {
        CopyOnWriteArraySet set = new CopyOnWriteArraySet();
        Class<?> cNow = cla;
        Class<?> c = null;
        while ((c = cNow.getSuperclass()) != null && c != Object.class) {
            set.add(c);
            cNow = c;
            PartUtils.addAllInterfaces(set, c);
        }
        PartUtils.addAllInterfaces(set, cla);
        return set.toArray(new Class[0]);
    }

    private static void addAllInterfaces(Set<Class<?>> set, Class<?> cla) {
        Class[] cs;
        for (Class c1 : cs = PartUtils.getInterfaces(cla)) {
            if (c1 == Serializable.class || c1 == Comparable.class) continue;
            set.add(c1);
            PartUtils.addAllInterfaces(set, c1);
        }
    }

    private static Class[] getInterfaces(Class cla) {
        return cla.getInterfaces();
    }
}

