/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.StarterApplication;
import io.github.kloping.MySpringTool.annotations.Controller;
import io.github.kloping.MySpringTool.annotations.CronSchedule;
import io.github.kloping.MySpringTool.annotations.Schedule;
import io.github.kloping.MySpringTool.annotations.TimeEve;
import io.github.kloping.MySpringTool.interfaces.AutomaticWiringParams;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ClassManager;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.MySpringTool.interfaces.component.TimeMethodManager;
import io.github.kloping.date.CronUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TimeMethodManagerImpl
implements TimeMethodManager {
    private AutomaticWiringParams automaticWiringParams;
    private ContextManager contextManager;
    private ExecutorService threads = Executors.newFixedThreadPool(5);
    private Timer timer = new Timer();
    private Map<Class<?>, List<Map.Entry<String, Method>>> timeMethods = new ConcurrentHashMap();

    public TimeMethodManagerImpl(ClassManager classManager, AutomaticWiringParams wiringParams) {
        this.automaticWiringParams = wiringParams;
        classManager.registeredAnnotation(Controller.class, this);
        StarterApplication.STARTED_RUNNABLE.add(() -> this.startTimer());
    }

    private void startTimer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        Map.Entry en = TimeMethodManagerImpl.this.getNextTimeMethodDelay();
                        if (en == null) {
                            Logger logger = TimeMethodManagerImpl.this.contextManager.getContextEntity(Logger.class);
                            if (logger != null) {
                                logger.Log("\u8ba1\u65f6\u4efb\u52a1\u7ed3\u675f...", 2);
                            }
                            return;
                        }
                        long t1 = (Long)en.getKey();
                        if (t1 > 0L) {
                            Thread.sleep(t1);
                            Method method = (Method)en.getValue();
                            TimeMethodManagerImpl.this.threads.execute(() -> {
                                try {
                                    Class<?> cla = method.getDeclaringClass();
                                    Object o = TimeMethodManagerImpl.this.contextManager.getContextEntity(cla);
                                    Object[] objects = TimeMethodManagerImpl.this.automaticWiringParams.wiring(method, TimeMethodManagerImpl.this.contextManager);
                                    method.invoke(o, objects);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            this.run();
                        }
                    }
                    catch (Exception e) {
                        Logger logger = TimeMethodManagerImpl.this.contextManager.getContextEntity(Logger.class);
                        if (logger == null) break block5;
                        logger.Log("\u8ba1\u65f6\u4efb\u52a1\u5f02\u5e38(timeEve Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
                    }
                }
            }
        }).start();
    }

    private Map.Entry<Long, Method> getNextTimeMethodDelay() {
        Map.Entry<Long, Method> entry = null;
        for (Class<?> cla : this.timeMethods.keySet()) {
            for (Map.Entry<String, Method> e : this.timeMethods.get(cla)) {
                int n3;
                int n2;
                if (!e.getValue().isAnnotationPresent(Schedule.class)) continue;
                String[] sss = e.getKey().split(":");
                int n1 = Integer.parseInt(sss[0]);
                long t = PartUtils.getTimeFromNowTo(n1, n2 = Integer.parseInt(sss[1]), n3 = Integer.parseInt(sss[2]));
                long l = t = t > 0L ? t : t + 86400000L;
                if (entry == null) {
                    entry = PartUtils.getEntry(t, e.getValue());
                    continue;
                }
                if (t > (Long)entry.getKey()) continue;
                entry = PartUtils.getEntry(t, e.getValue());
            }
        }
        return entry;
    }

    @Override
    public void manager(final Method method, final ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        this.contextManager = contextManager;
        if (method.isAnnotationPresent(TimeEve.class)) {
            method.setAccessible(true);
            TimeEve timeEve = method.getDeclaredAnnotation(TimeEve.class);
            long t = timeEve.value();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Class<?> cla = method.getDeclaringClass();
                            Object o = contextManager.getContextEntity(cla);
                            Object[] objects = TimeMethodManagerImpl.this.automaticWiringParams.wiring(method, contextManager);
                            method.invoke(o, objects);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Logger logger = contextManager.getContextEntity(Logger.class);
                            if (logger == null) break block2;
                            logger.Log("\u8ba1\u65f6\u4efb\u52a1\u5f02\u5e38(timeEve Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
                        }
                    }
                }
            }, t, t);
            Logger logger = contextManager.getContextEntity(Logger.class);
            if (logger != null) {
                logger.Log("new timeEve  " + method.getName() + " from " + method.getDeclaringClass().getSimpleName(), 0);
            }
        } else if (method.isAnnotationPresent(Schedule.class)) {
            String[] ss;
            Class<?> cla = method.getDeclaringClass();
            List<Map.Entry<String, Method>> list = this.timeMethods.get(cla);
            if (list == null) {
                list = new ArrayList<Map.Entry<String, Method>>();
            }
            Schedule sch = method.getAnnotation(Schedule.class);
            for (String s : ss = sch.value().split(",")) {
                list.add(PartUtils.getEntry(s, method));
            }
            this.timeMethods.put(cla, list);
            Logger logger = contextManager.getContextEntity(Logger.class);
            if (logger != null) {
                logger.Log("new Schedule " + method.getName() + " from " + method.getDeclaringClass().getSimpleName(), 0);
            }
        } else if (method.isAnnotationPresent(CronSchedule.class)) {
            Object o = contextManager.getContextEntity(method.getDeclaringClass());
            CronSchedule schedule = method.getAnnotation(CronSchedule.class);
            String cron = schedule.value();
            if (!cron.isEmpty()) {
                method.setAccessible(true);
                CronUtils.INSTANCE.addCronJob(cron, c -> {
                    try {
                        Object[] objects = this.automaticWiringParams.wiring(method, contextManager);
                        method.invoke(o, objects);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    @Override
    public void manager(Class clas, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        for (Method method : clas.getDeclaredMethods()) {
            this.manager(method, contextManager);
        }
    }
}

