/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.annotations.Action;
import io.github.kloping.MySpringTool.annotations.After;
import io.github.kloping.MySpringTool.annotations.Before;
import io.github.kloping.MySpringTool.annotations.Controller;
import io.github.kloping.MySpringTool.annotations.DefAction;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ActionManager;
import io.github.kloping.MySpringTool.interfaces.component.ClassManager;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.MySpringTool.interfaces.entitys.MatherResult;
import io.github.kloping.judge.Judge;
import io.github.kloping.map.MapUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionManagerImpl
implements ActionManager {
    public static final Pattern PATTERN0 = Pattern.compile("<.*>");
    public static final Pattern PATTERN1 = Pattern.compile("<.+=>.+>");
    public Map<String, String> histIndexes = new HashMap<String, String>();
    private Map<Character, List<String>> indexMap = new HashMap<Character, List<String>>();
    private List<Character> csO = Arrays.asList(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('*'));
    private Logger logger;
    private Map<String, Set<Method>> action2methods = new ConcurrentHashMap<String, Set<Method>>();
    private Set<Class<?>> classSet = new CopyOnWriteArraySet();
    private List<Method> defActionMethods = new ArrayList<Method>();
    private static List<Character> need1 = new LinkedList<Character>();

    public ActionManagerImpl(ClassManager classManager, Setting setting) {
        classManager.registeredAnnotation(Controller.class, this);
        setting.getSTARTED_RUNNABLE().add(() -> {
            this.logger = setting.getContextManager().getContextEntity(Logger.class);
        });
    }

    public void makeIndex() {
        this.indexMap.clear();
        for (String k : this.action2methods.keySet()) {
            char[] cArray = k.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (this.csO.contains(c)) continue;
                MapUtils.append(this.indexMap, (Object)c, (Object)k);
            }
        }
    }

    public synchronized MatherResult mather(String regx) {
        if (regx == null || regx.trim().isEmpty()) {
            return null;
        }
        if (this.indexMap.isEmpty()) {
            this.makeIndex();
        }
        if (this.action2methods.containsKey(regx)) {
            Set<Method> set = this.action2methods.get(regx);
            MatherResult mr = new MatherResult(regx, regx, set.toArray(new Method[0]));
            return mr;
        }
        if (this.histIndexes.containsKey(regx)) {
            MatherResult r = null;
            try {
                r = this.mr(regx, this.histIndexes.get(regx));
                if (r != null) {
                    return r;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (char c : this.getShortestSortedChars(regx)) {
            if (!this.indexMap.containsKey(Character.valueOf(c))) continue;
            for (String s : this.indexMap.get(Character.valueOf(c))) {
                MatherResult r = null;
                try {
                    r = this.mr(regx, s);
                }
                catch (Exception e) {
                    continue;
                }
                if (r == null) continue;
                this.histIndexes.put(regx, s);
                return r;
            }
        }
        return new MatherResult(null, null, this.defActionMethods.toArray(new Method[0]));
    }

    private List<Character> getShortestSortedChars(String s0) {
        HashMap<Character, Integer> c2n = new HashMap<Character, Integer>();
        for (char c : s0.toCharArray()) {
            if (!this.indexMap.containsKey(Character.valueOf(c))) continue;
            int n = this.indexMap.get(Character.valueOf(c)).size();
            c2n.put(Character.valueOf(c), n);
        }
        LinkedList ls = new LinkedList(c2n.entrySet());
        Collections.sort(ls, new Comparator<Map.Entry<Character, Integer>>(){

            @Override
            public int compare(Map.Entry<Character, Integer> o1, Map.Entry<Character, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        LinkedList<Character> endLs = new LinkedList<Character>();
        for (Map.Entry entry : ls) {
            endLs.add((Character)entry.getKey());
        }
        return endLs;
    }

    private MatherResult mr(String regx, String s) throws Exception {
        String[] ss;
        String regxNow;
        String s2;
        String s1;
        String regxNow2;
        if (regx.matches(s)) {
            Set<Method> set = this.action2methods.get(s);
            MatherResult mr = new MatherResult(s, regx, set.toArray(new Method[0]));
            return mr;
        }
        Matcher matcher = PATTERN0.matcher(s);
        if (matcher.find() && regx.matches(regxNow2 = s.replace(s1 = matcher.group(), s2 = s1.substring(1, s1.length() - 1)))) {
            Set<Method> set = this.action2methods.get(s);
            MatherResult mr = new MatherResult(s, regx, set.toArray(new Method[0]));
            return mr;
        }
        matcher = PATTERN1.matcher(s);
        if (matcher.find() && regx.matches(regxNow = s.replace(s1 = matcher.group(), (ss = (s2 = s1.substring(1, s1.length() - 1)).split("=>"))[0]))) {
            String s4 = ActionManagerImpl.filterM1(ss[0]);
            String[] ss2 = regxNow.split(s4);
            String nowRegx = regx;
            String m1 = regxNow.replace(ss[0], "");
            nowRegx = nowRegx.replaceFirst(m1, "");
            Set<Method> set = this.action2methods.get(s);
            MatherResult mr = new MatherResult(s, regx, set.toArray(new Method[0]));
            if (nowRegx.matches(ss[0])) {
                mr.getParams().put(ss[1], nowRegx);
            }
            return mr;
        }
        return null;
    }

    @Override
    public Class<?>[] getAll() {
        return this.classSet.toArray(new Class[0]);
    }

    @Override
    public void manager(Method method, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        this.manager(contextManager.getContextEntity(method.getDeclaringClass()));
    }

    @Override
    public void manager(Object obj) throws IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            return;
        }
        if (obj.getClass() == null) {
            return;
        }
        if (obj.getClass() == Class.class) {
            return;
        }
        if (!this.classSet.add(obj.getClass())) {
            return;
        }
        Method before = null;
        Method after = null;
        for (Method declaredMethod : obj.getClass().getDeclaredMethods()) {
            if (declaredMethod.isAnnotationPresent(Before.class)) {
                declaredMethod.setAccessible(true);
                before = declaredMethod;
                if (this.logger == null) continue;
                this.logger.Log("new before " + declaredMethod.getName() + " from " + declaredMethod.getDeclaringClass().getSimpleName(), 0);
                continue;
            }
            if (!declaredMethod.isAnnotationPresent(After.class)) continue;
            declaredMethod.setAccessible(true);
            after = declaredMethod;
            if (this.logger == null) continue;
            this.logger.Log("new after  " + declaredMethod.getName() + " from " + declaredMethod.getDeclaringClass().getSimpleName(), 0);
        }
        for (Method declaredMethod : obj.getClass().getDeclaredMethods()) {
            if (declaredMethod.isAnnotationPresent(Action.class)) {
                declaredMethod.setAccessible(true);
                Action action = declaredMethod.getDeclaredAnnotation(Action.class);
                LinkedHashSet<String> actionsStr = new LinkedHashSet<String>();
                if (!action.value().trim().isEmpty()) {
                    actionsStr.add(action.value());
                }
                for (String ac : action.otherName()) {
                    if (ac.trim().isEmpty()) continue;
                    actionsStr.add(ac);
                }
                for (String actionV : actionsStr) {
                    if (before != null) {
                        ActionManagerImpl.append(this.action2methods, actionV, before);
                    }
                    ActionManagerImpl.append(this.action2methods, actionV, declaredMethod);
                    if (after == null) continue;
                    ActionManagerImpl.append(this.action2methods, actionV, after);
                }
                if (this.logger == null) continue;
                this.logger.Log("new action  " + declaredMethod.getName() + " from " + declaredMethod.getDeclaringClass().getSimpleName(), 0);
                continue;
            }
            if (!declaredMethod.isAnnotationPresent(DefAction.class)) continue;
            declaredMethod.setAccessible(true);
            if (before != null) {
                this.defActionMethods.add(before);
            }
            this.defActionMethods.add(declaredMethod);
            if (after == null) continue;
            this.defActionMethods.add(after);
        }
    }

    public static <K, V> void append(Map<K, Set<V>> map, K k, V v) {
        if (!Judge.isNotNull((Object[])new Object[]{map, k, v})) {
            return;
        }
        Set<V> set = map.get(k);
        if (set == null) {
            set = new CopyOnWriteArraySet<V>();
        }
        set.add(v);
        map.put(k, set);
    }

    public static String filterM1(String m1) {
        StringBuilder sb = new StringBuilder();
        for (char c : m1.toCharArray()) {
            if (need1.contains(Character.valueOf(c))) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public synchronized void replaceAction(String oStr, String nowStr) {
        if (this.action2methods.containsKey(oStr)) {
            Set<Method> set = this.action2methods.get(oStr);
            this.action2methods.put(nowStr, set);
            this.action2methods.remove(oStr);
            for (char c : oStr.toCharArray()) {
                this.indexMap.remove(Character.valueOf(c));
            }
            for (char c : nowStr.toCharArray()) {
                MapUtils.append(this.indexMap, (Object)Character.valueOf(c), (Object)nowStr);
            }
            this.histIndexes.clear();
        }
    }

    static {
        need1.add(Character.valueOf('.'));
        need1.add(Character.valueOf('\\'));
        need1.add(Character.valueOf('['));
        need1.add(Character.valueOf(']'));
        need1.add(Character.valueOf('+'));
        need1.add(Character.valueOf('?'));
        need1.add(Character.valueOf('*'));
        need1.add(Character.valueOf('^'));
        need1.add(Character.valueOf('{'));
    }
}

