/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import io.github.kloping.MySpringTool.interfaces.component.PackageScanner;
import io.github.kloping.file.FileUtils;
import io.github.kloping.io.ReadUtils;
import io.github.kloping.url.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageScannerImpl
implements PackageScanner {
    public static final String JAR_STR = "jar";
    public static final String FILE_STR = "file";
    public static final String JAR0_STR = ".jar!";
    public static final String JAR0FILE_STR = "jar:file:";
    private boolean isRecursion = true;
    private List<Class<?>> classes = new ArrayList();

    public PackageScannerImpl(boolean isRecursion) {
        this.isRecursion = isRecursion;
    }

    @Override
    public List<Class<?>> getDefaultClass() {
        return this.classes;
    }

    @Override
    public Class<?>[] scan(Class<?> cla, ClassLoader loader, String packageName) throws Exception {
        if (!this.getDefaultClass().isEmpty()) {
            return this.getDefaultClass().toArray(new Class[0]);
        }
        Set<String> classNames = null;
        String packagePath = packageName.replace(".", "/");
        URL url = loader.getResource(packagePath);
        if (url != null) {
            String protocol = url.getProtocol().trim();
            if (FILE_STR.equals(protocol)) {
                classNames = this.getClassNameFromDir(url.getPath(), packageName, this.isRecursion);
            } else if (JAR_STR.equals(protocol)) {
                JarFile jarFile = null;
                jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                if (jarFile != null) {
                    classNames = this.getClassNameFromJar(jarFile.entries(), packageName, this.isRecursion);
                }
            }
        }
        CopyOnWriteArraySet classes = new CopyOnWriteArraySet();
        for (String name : classNames) {
            Class<?> c0 = loader.loadClass(name);
            classes.add(c0);
        }
        return classes.toArray(new Class[0]);
    }

    private static URL getJarFileAsJarFile(URL url) throws Exception {
        String urlPath = url.getPath();
        int i0 = urlPath.indexOf(JAR0_STR);
        String jar0 = JAR0FILE_STR + urlPath.substring(0, i0 + JAR0_STR.length() + 1);
        int i1 = jar0.length() - JAR0FILE_STR.length();
        urlPath = urlPath.substring(i1);
        urlPath = urlPath.substring(0, urlPath.indexOf("!"));
        URL urlJar0 = new URL(jar0);
        JarFile jarFile = null;
        jarFile = ((JarURLConnection)urlJar0.openConnection()).getJarFile();
        Enumeration<JarEntry> entryEnumeration = jarFile.entries();
        JarEntry entry = jarFile.getJarEntry(urlPath);
        InputStream is = jarFile.getInputStream(entry);
        File temp = File.createTempFile("temp0", ".jar");
        FileUtils.writeBytesToFile((byte[])ReadUtils.readAll((InputStream)is), (File)temp);
        temp.deleteOnExit();
        return new URL("jar:file:/" + temp.getAbsolutePath() + "!/");
    }

    private Set<String> getClassNameFromDir(String filePath, String packageName, boolean isRecursion) {
        File[] files;
        HashSet<String> className = new HashSet<String>();
        File file = new File(filePath);
        for (File childFile : files = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!isRecursion) continue;
                className.addAll(this.getClassNameFromDir(childFile.getPath(), packageName + "." + childFile.getName(), isRecursion));
                continue;
            }
            String fileName = childFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            className.add(packageName + "." + fileName.replace(".class", ""));
        }
        return className;
    }

    private Set<String> getClassNameFromJar(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        return this.getResource0(jarEntries, packageName, isRecursion);
    }

    private Set<String> getResource0(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entryName;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(entryName = jarEntry.getName().replaceAll("/", ".")).endsWith(".class") || entryName.contains("$") || !entryName.startsWith(packageName)) continue;
            entryName = entryName.replace(".class", "");
            if (isRecursion) {
                classNames.add(entryName);
                continue;
            }
            if (entryName.replace(packageName + ".", "").contains(".")) continue;
            classNames.add(entryName);
        }
        return classNames;
    }

    private Set<String> getClassNameFromJars(URL[] urls, String packageName, boolean isRecursion) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            JarFile jarFile = null;
            if (classPath.endsWith("classes/")) continue;
            if (classPath.startsWith("http")) {
                File temp = File.createTempFile("temp0", ".jar");
                FileUtils.writeBytesToFile((byte[])UrlUtils.getBytesFromHttpUrl((String)classPath.substring(0, classPath.indexOf("!"))), (File)temp);
                jarFile = new JarFile(temp);
                if (jarFile != null) {
                    classNames.addAll(this.getClassNameFromJar(jarFile.entries(), packageName, isRecursion));
                }
                temp.delete();
                continue;
            }
            jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            if (jarFile == null) continue;
            classNames.addAll(this.getClassNameFromJar(jarFile.entries(), packageName, isRecursion));
        }
        return classNames;
    }
}

