/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impls.baseup;

import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.entity.impls.RunnerEve;
import io.github.kloping.MySpringTool.entity.interfaces.Runner;
import io.github.kloping.MySpringTool.exceptions.NoRunException;
import io.github.kloping.MySpringTool.interfaces.Executor;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.QueueExecutor;
import io.github.kloping.MySpringTool.interfaces.entitys.MatherResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QueueExecutorWithReturnsImpl
implements QueueExecutor {
    protected Class<?> cla = Long.class;
    protected Executor executor;
    protected int poolSize = 20;
    protected long waitTime = 10000L;
    private RunnerEve runner1;
    private RunnerEve runner2;
    private Setting setting;
    private Logger logger;
    private ExecutorService threads;
    private ExecutorService runThreads = null;
    protected Map<Object, Queue> queueMap = new ConcurrentHashMap<Object, Queue>();
    protected Set<Object> runSet = new CopyOnWriteArraySet<Object>();

    @Override
    public <T extends Runner> void setBefore(T runner) {
        if (runner instanceof RunnerEve) {
            this.runner1 = (RunnerEve)runner;
        }
    }

    @Override
    public <T extends Runner> void setAfter(T runner) {
        if (runner instanceof RunnerEve) {
            this.runner2 = (RunnerEve)runner;
        }
    }

    public QueueExecutorWithReturnsImpl(Class<?> cla, Executor executor, Setting setting) {
        this.setting = setting;
        this.cla = cla;
        this.executor = executor;
        this.init();
    }

    protected void init() {
        this.threads = new ThreadPoolExecutor(this.poolSize, this.poolSize, this.waitTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize));
        this.runThreads = Executors.newFixedThreadPool(this.poolSize);
        this.logger = this.setting.getContextManager().getContextEntity(Logger.class);
    }

    protected QueueExecutorWithReturnsImpl(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        this.setting = setting;
        this.executor = executor;
        this.poolSize = poolSize;
        this.cla = cla;
        this.waitTime = waitTime;
        this.init();
    }

    public static QueueExecutorWithReturnsImpl create(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        return new QueueExecutorWithReturnsImpl(cla, poolSize, waitTime, executor, setting);
    }

    @Override
    public Object execute(Object This, Method method, Object ... objects) throws InvocationTargetException, IllegalAccessException {
        Object o = null;
        try {
            o = this.executor.execute(This, method, objects);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException ite = e;
            if (ite.getTargetException().getClass() == NoRunException.class) {
                NoRunException exception = (NoRunException)ite.getTargetException();
                this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + exception.getMessage(), 2);
            }
            this.logger.Log("\u5b58\u5728\u6620\u5c04\u4e00\u4e2a\u5f02\u5e38(Has a Invoke Exception)=>" + ite.getTargetException() + " at " + PartUtils.getExceptionLine(ite.getTargetException()), -1);
        }
        return o;
    }

    @Override
    public <T> int queueExecute(T t, Object ... objects) {
        if (t.getClass() != this.cla) {
            this.logger.Log("not is mainKey type for " + t.getClass().getSimpleName(), 2);
            return -1;
        }
        if (this.runSet.add(t)) {
            this.tryRun(t, objects);
            return this.queueMap.size();
        }
        this.append(t, objects);
        this.logger.Log("append queue list and next run", 0);
        return 0;
    }

    protected <T> void tryRun(T t, Object[] objects) {
        this.runThreads.execute(() -> {
            Future<?> future = this.threads.submit(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    Object[] parts = Arrays.copyOfRange(objects, 2, objects.length);
                    if (this.setting.getArgsManager().isLegal(parts)) {
                        this.matcherAndRun(t, objects, startTime, parts);
                    } else {
                        this.logger.Log("Can't Access types for " + Arrays.toString(objects), 2);
                    }
                }
                catch (NoRunException e) {
                    this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + e.getMessage(), 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            this.getVal(future);
            this.runEnd(t);
        });
    }

    protected <T> void matcherAndRun(T t, Object[] objects, long startTime, Object parts) {
        try {
            MatherResult result = (MatherResult)this.setting.getActionManager().mather(objects[1].toString());
            if (result != null) {
                Method[] methods = result.getMethods();
                Class<?> cla = methods[0].getDeclaringClass();
                Object o = this.setting.getContextManager().getContextEntity(cla);
                ArrayList<Object> results = new ArrayList<Object>();
                for (Method m : methods) {
                    Object o1;
                    Object[] parObjs = this.setting.getAutomaticWiringParams().wiring(m, result, results, parts);
                    if (this.runner1 != null) {
                        this.runner1.methodRuined(null, m, t, objects);
                    }
                    if ((o1 = this.executor.execute(o, m, parObjs)) == null) continue;
                    results.add(o1);
                    if (this.runner2 == null) continue;
                    this.runner2.methodRuined(o1, m, t, objects);
                }
                this.logger.Log("lost time " + (System.currentTimeMillis() - startTime) + " Millisecond", 1);
            } else {
                this.logger.Log("No match for " + objects[1].toString(), 2);
            }
        }
        catch (NoRunException e) {
            this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + e.getMessage(), 2);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException ite = e;
            if (ite.getTargetException().getClass() == NoRunException.class) {
                NoRunException exception = (NoRunException)ite.getTargetException();
                this.logger.Log("\u629b\u51fa \u4e0d\u8fd0\u884c\u5f02\u5e38(throw NuRunException): " + exception.getMessage(), 2);
            } else {
                this.logger.Log("\u5b58\u5728\u6620\u5c04\u4e00\u4e2a\u5f02\u5e38(Has a Invoke Exception)=>" + ite.getTargetException() + " at " + PartUtils.getExceptionLine(ite.getTargetException()), -1);
            }
        }
        catch (Exception e) {
            this.logger.Log("\u5b58\u5728\u4e00\u4e2a\u5f02\u5e38(Has a Exception)=>" + e + " at " + PartUtils.getExceptionLine(e), -1);
        }
    }

    protected <T> void runEnd(T t) {
        this.runSet.remove(t);
        if (this.queueMap.containsKey(t)) {
            this.queueExecute(t, this.end(t));
        }
    }

    protected void getVal(Future future) {
        try {
            future.get(this.waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.Log("\u8fd0\u884c\u65f6\u9519\u8bef(Running Has Error)=>" + e, -1);
            future.cancel(true);
        }
        catch (TimeoutException e) {
            this.logger.Log("\u8fd0\u884c\u8d85\u65f6(Run Time Out)=>" + e, -1);
            future.cancel(true);
        }
        catch (Exception e) {
            this.logger.Log("\u5176\u4ed6\u9519\u8bef(Other Error)=>" + e + "\n", -1);
            e.printStackTrace();
            future.cancel(true);
        }
    }

    protected void append(Object t, Object ... objects) {
        if (this.queueMap.containsKey(t)) {
            this.queueMap.get(t).offer(objects);
        } else {
            ConcurrentLinkedDeque<Object[]> queue = new ConcurrentLinkedDeque<Object[]>();
            queue.offer(objects);
            this.queueMap.put(t, queue);
        }
    }

    private Object[] end(Object t) {
        Object[] objects = null;
        if (this.queueMap.containsKey(t)) {
            objects = (Object[])this.queueMap.get(t).poll();
        }
        if (this.queueMap.get(t).isEmpty()) {
            this.queueMap.remove(t);
        }
        return objects;
    }
}

