/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls.baseup;

import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.Setting;
import io.github.kloping.spt.entity.impls.RunnerEve;
import io.github.kloping.spt.entity.interfaces.Runner;
import io.github.kloping.spt.entity.interfaces.RunnerOnThrows;
import io.github.kloping.spt.impls.QueueExecutorImpl;
import io.github.kloping.spt.interfaces.Executor;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.QueueExecutor;
import io.github.kloping.spt.interfaces.entitys.MatherResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QueueExecutorWithReturnsImpl
extends QueueExecutorImpl
implements QueueExecutor {
    protected Class<?> cla = Long.class;
    protected Executor executor;
    protected int poolSize = 20;
    protected long waitTime = 10000L;
    private RunnerEve runner1;
    private RunnerEve runner2;
    private RunnerOnThrows onThrows;
    private Logger logger;
    private ExecutorService threads;
    private ExecutorService runThreads = null;
    protected Map<Object, Queue> queueMap = new ConcurrentHashMap<Object, Queue>();
    protected Set<Object> runSet = new CopyOnWriteArraySet<Object>();

    @Override
    public <T extends RunnerOnThrows> void setException(T r) {
        this.onThrows = r;
    }

    @Override
    public <T extends Runner> void setBefore(T runner) {
        if (runner instanceof RunnerEve) {
            this.runner1 = (RunnerEve)runner;
        }
    }

    @Override
    public <T extends Runner> void setAfter(T runner) {
        if (runner instanceof RunnerEve) {
            this.runner2 = (RunnerEve)runner;
        }
    }

    public QueueExecutorWithReturnsImpl(Class<?> cla, Executor executor, Setting setting) {
        super(setting);
        this.cla = cla;
        this.executor = executor;
        this.init();
    }

    protected void init() {
        this.threads = new ThreadPoolExecutor(this.poolSize, this.poolSize, this.waitTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize));
        this.runThreads = Executors.newFixedThreadPool(this.poolSize);
        this.logger = this.setting.getContextManager().getContextEntity(Logger.class);
    }

    protected QueueExecutorWithReturnsImpl(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        super(setting);
        this.executor = executor;
        this.poolSize = poolSize;
        this.cla = cla;
        this.waitTime = waitTime;
        this.init();
    }

    @Override
    public Object execute(Object This, Method method, Object ... objects) throws Throwable {
        return this.executor.execute(This, method, objects);
    }

    @Override
    public <T> int queueExecute(T t, Object ... objects) {
        if (t.getClass() != this.cla) {
            this.logger.waring("not is mainKey type for " + t.getClass().getSimpleName());
            return -1;
        }
        if (this.runSet.add(t)) {
            this.tryRun(t, objects);
            return this.queueMap.size();
        }
        this.append(t, objects);
        this.logger.info("append queue list and next run");
        return 0;
    }

    protected <T> void tryRun(T t, Object[] objects) {
        this.runThreads.execute(() -> {
            Future<?> future = this.threads.submit(() -> {
                long startTime = System.currentTimeMillis();
                Object[] parts = Arrays.copyOfRange(objects, 2, objects.length);
                if (this.setting.getArgsManager().isLegal(parts)) {
                    this.matcherAndRun(t, objects, startTime, parts);
                } else {
                    this.logger.Log("Can't Access types for " + Arrays.toString(objects), 2);
                }
            });
            this.getVal(future);
            this.runEnd(t);
        });
    }

    protected <T> void matcherAndRun(T t, Object[] objects, long startTime, Object parts) {
        try {
            MatherResult result = (MatherResult)this.setting.getActionManager().mather(objects[1].toString());
            if (result != null) {
                Method[] methods = result.getMethods();
                Class<?> cla = methods[0].getDeclaringClass();
                Object o = this.setting.getContextManager().getContextEntity(cla);
                ArrayList<Object> results = new ArrayList<Object>();
                for (Method m : methods) {
                    Object o1;
                    Object[] parObjs = this.setting.getAutomaticWiringParams().wiring(m, result, results, parts);
                    if (this.runner1 != null) {
                        this.runner1.methodRuined(null, m, t, objects);
                    }
                    if ((o1 = this.executor.execute(o, m, parObjs)) == null) continue;
                    results.add(o1);
                    if (this.runner2 == null) continue;
                    this.runner2.methodRuined(o1, m, t, objects);
                }
                this.logger.Log("lost time " + (System.currentTimeMillis() - startTime) + " Millisecond", 1);
            } else {
                this.logger.Log("No match for " + objects[1].toString(), 2);
            }
        }
        catch (Throwable e) {
            if (this.onThrows != null) {
                this.onThrows.onThrows(e, t, objects);
            }
            this.logger.error(PartUtils.getExceptionLine(e));
        }
    }

    protected <T> void runEnd(T t) {
        this.runSet.remove(t);
        if (this.queueMap.containsKey(t)) {
            this.queueExecute(t, this.end(t));
        }
    }

    protected void getVal(Future future) {
        try {
            future.get(this.waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.Log("\u8fd0\u884c\u65f6\u9519\u8bef(Running Has Error)=>" + e, -1);
            future.cancel(true);
        }
        catch (TimeoutException e) {
            this.logger.Log("\u8fd0\u884c\u8d85\u65f6(Run Time Out)=>" + e, -1);
            future.cancel(true);
        }
        catch (Exception e) {
            this.logger.Log("\u5176\u4ed6\u9519\u8bef(Other Error)=>" + e + "\n", -1);
            e.printStackTrace();
            future.cancel(true);
        }
    }

    protected void append(Object t, Object ... objects) {
        if (this.queueMap.containsKey(t)) {
            this.queueMap.get(t).offer(objects);
        } else {
            ConcurrentLinkedDeque<Object[]> queue = new ConcurrentLinkedDeque<Object[]>();
            queue.offer(objects);
            this.queueMap.put(t, queue);
        }
    }

    private Object[] end(Object t) {
        Object[] objects = null;
        if (this.queueMap.containsKey(t)) {
            objects = (Object[])this.queueMap.get(t).poll();
        }
        if (this.queueMap.get(t).isEmpty()) {
            this.queueMap.remove(t);
        }
        return objects;
    }
}

