/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt;

import io.github.kloping.spt.impls.ActionManagerImpl;
import io.github.kloping.spt.impls.ArgsManagerImpl;
import io.github.kloping.spt.impls.AutomaticWiringValueImpl;
import io.github.kloping.spt.impls.ClassManagerImpl;
import io.github.kloping.spt.impls.ConfigFileManagerImpl;
import io.github.kloping.spt.impls.ContextManagerWithEIImpl;
import io.github.kloping.spt.impls.ExecutorNowImpl;
import io.github.kloping.spt.impls.FieldManagerImpl;
import io.github.kloping.spt.impls.FieldSourceManagerImpl0;
import io.github.kloping.spt.impls.HttpClientManagerImpl;
import io.github.kloping.spt.impls.InstanceCraterImpl;
import io.github.kloping.spt.impls.MethodManagerImpl;
import io.github.kloping.spt.impls.PackageScannerImpl;
import io.github.kloping.spt.impls.QueueExecutorImpl;
import io.github.kloping.spt.impls.TimeMethodManagerImpl;
import io.github.kloping.spt.impls.baseup.AutomaticWiringParamsH2Impl;
import io.github.kloping.spt.interfaces.AutomaticWiringParams;
import io.github.kloping.spt.interfaces.AutomaticWiringValue;
import io.github.kloping.spt.interfaces.Executor;
import io.github.kloping.spt.interfaces.QueueExecutor;
import io.github.kloping.spt.interfaces.component.ActionManager;
import io.github.kloping.spt.interfaces.component.ArgsManager;
import io.github.kloping.spt.interfaces.component.ClassManager;
import io.github.kloping.spt.interfaces.component.ConfigFileManager;
import io.github.kloping.spt.interfaces.component.ContextManager;
import io.github.kloping.spt.interfaces.component.FieldManager;
import io.github.kloping.spt.interfaces.component.FieldSourceManager;
import io.github.kloping.spt.interfaces.component.HttpClientManager;
import io.github.kloping.spt.interfaces.component.InstanceCrater;
import io.github.kloping.spt.interfaces.component.MethodManager;
import io.github.kloping.spt.interfaces.component.PackageScanner;
import io.github.kloping.spt.interfaces.component.TimeMethodManager;
import java.lang.reflect.Field;
import java.util.List;

public abstract class Setting {
    protected ContextManager contextManager;
    protected PackageScanner packageScanner;
    protected AutomaticWiringParams automaticWiringParams;
    protected AutomaticWiringValue automaticWiringValue;
    protected ArgsManager argsManager;
    protected InstanceCrater instanceCrater;
    protected ActionManager actionManager;
    protected MethodManager methodManager;
    protected FieldManager fieldManager;
    protected ClassManager classManager;
    protected ConfigFileManager configFileManager;
    protected Executor executor;
    protected QueueExecutor queueExecutor;
    protected TimeMethodManager timeMethodManager;
    protected HttpClientManager httpClientManager;
    protected FieldSourceManager fieldSourceManager;

    protected Setting() {
    }

    protected Setting defaultInit(Class mainKey, Integer poolSize, Long waitTime) {
        Field[] fields;
        if (this.contextManager == null) {
            this.contextManager = new ContextManagerWithEIImpl();
        }
        if (this.configFileManager == null) {
            this.configFileManager = new ConfigFileManagerImpl(this.contextManager);
        }
        if (this.automaticWiringParams == null) {
            this.automaticWiringParams = new AutomaticWiringParamsH2Impl();
        }
        if (this.automaticWiringValue == null) {
            this.automaticWiringValue = new AutomaticWiringValueImpl();
        }
        if (this.instanceCrater == null) {
            this.instanceCrater = new InstanceCraterImpl();
        }
        if (this.executor == null) {
            this.executor = new ExecutorNowImpl();
        }
        if (this.queueExecutor == null) {
            this.queueExecutor = QueueExecutorImpl.create(mainKey, poolSize, waitTime, this.executor, this);
        }
        if (this.argsManager == null) {
            this.argsManager = new ArgsManagerImpl();
        }
        if (this.packageScanner == null) {
            this.packageScanner = new PackageScannerImpl(true);
        }
        if (this.classManager == null) {
            this.classManager = new ClassManagerImpl(this.instanceCrater, this.contextManager, this.automaticWiringParams, this.actionManager);
        }
        if (this.methodManager == null) {
            this.methodManager = new MethodManagerImpl(this.automaticWiringParams, this.classManager);
        }
        if (this.actionManager == null) {
            this.actionManager = new ActionManagerImpl(this.classManager, this);
        }
        if (this.timeMethodManager == null) {
            this.timeMethodManager = new TimeMethodManagerImpl(this, this.classManager, this.automaticWiringParams);
        }
        if (this.httpClientManager == null) {
            this.httpClientManager = new HttpClientManagerImpl(this, this.classManager);
        }
        if (this.fieldManager == null) {
            this.fieldManager = new FieldManagerImpl(this.automaticWiringValue, this.classManager, this);
        }
        if (this.fieldSourceManager == null) {
            this.fieldSourceManager = new FieldSourceManagerImpl0(this.classManager);
        }
        for (Field field : fields = Setting.class.getDeclaredFields()) {
            Object o = null;
            try {
                o = field.get(this);
            }
            catch (Exception e) {
                continue;
            }
            if (o == null) continue;
            this.contextManager.append(o);
        }
        return this;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public PackageScanner getPackageScanner() {
        return this.packageScanner;
    }

    public AutomaticWiringParams getAutomaticWiringParams() {
        return this.automaticWiringParams;
    }

    public AutomaticWiringValue getAutomaticWiringValue() {
        return this.automaticWiringValue;
    }

    public ArgsManager getArgsManager() {
        return this.argsManager;
    }

    public InstanceCrater getInstanceCrater() {
        return this.instanceCrater;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public MethodManager getMethodManager() {
        return this.methodManager;
    }

    public FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }

    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public QueueExecutor getQueueExecutor() {
        return this.queueExecutor;
    }

    public TimeMethodManager getTimeMethodManager() {
        return this.timeMethodManager;
    }

    public HttpClientManager getHttpClientManager() {
        return this.httpClientManager;
    }

    public FieldSourceManager getFieldSourceManager() {
        return this.fieldSourceManager;
    }

    public abstract List<Runnable> getSTARTED_RUNNABLE();

    public abstract List<Runnable> getPRE_SCAN_RUNNABLE();

    public abstract List<Runnable> getPOST_SCAN_RUNNABLE();
}

