/*
 * Decompiled with CFR 0.152.
 */
package io.github.ModularEnigma;

import io.github.ModularEnigma.RequestBuilder;
import io.github.ModularEnigma.Response;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class Request {
    private final String url;
    private final URI uri;
    private final Method requestMethod;
    private final String requestBody;

    public static RequestBuilder builder() {
        return new RequestBuilder();
    }

    public Request(String url, Method requestMethod, String requestBody) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (requestMethod == null) {
            throw new IllegalArgumentException("Request method must be set");
        }
        try {
            this.uri = URI.create(url);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("URI is not valid as per RFC 2396");
        }
        this.url = url;
        this.requestMethod = requestMethod;
        this.requestBody = requestBody;
    }

    public Response execute() {
        HttpResponse<String> httpResponse;
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.uri).header("Accept", "application/json").header("Content-Type", "application/json");
        switch (this.requestMethod) {
            case POST: {
                builder.POST(HttpRequest.BodyPublishers.ofString(this.requestBody));
                break;
            }
            case GET: {
                builder.GET();
            }
        }
        HttpRequest request = builder.build();
        HttpClient client = HttpClient.newHttpClient();
        try {
            httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Exception raised while sending request.");
        }
        return new Response(httpResponse);
    }

    public String toString() {
        return "Request:\n" + this.requestMethod + " " + this.url + "\nBody: " + this.requestBody + "\n";
    }

    public static enum Method {
        GET,
        POST;

    }
}

