/*
 * Decompiled with CFR 0.152.
 */
package io.github.ModularEnigma;

import io.github.ModularEnigma.Request;

public class RequestBuilder {
    private String url;
    private Request.Method requestMethod;
    private String requestBody;

    public RequestBuilder setURL(String url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        this.url = url;
        return this;
    }

    public RequestBuilder setMethod(Request.Method requestMethod) throws IllegalArgumentException {
        if (requestMethod == null) {
            throw new IllegalArgumentException("requestMethod cannot be null.");
        }
        this.requestMethod = requestMethod;
        return this;
    }

    public RequestBuilder setRequestBody(String body) throws IllegalArgumentException {
        if (body == null) {
            throw new IllegalArgumentException("body cannot be null.");
        }
        this.requestBody = body;
        return this;
    }

    public Request build() throws IllegalStateException {
        if (this.url == null) {
            throw new IllegalStateException("url is required.");
        }
        if (this.requestMethod == null) {
            throw new IllegalStateException("requestMethod is required.");
        }
        return new Request(this.url, this.requestMethod, this.requestBody);
    }
}

