/*
 * Decompiled with CFR 0.152.
 */
package io.githhub.TradersTeam.grand_node_java_client.network;

import io.githhub.TradersTeam.grand_node_java_client.network.CallX;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

class CallXAdapterFactory
extends CallAdapter.Factory {
    private static OkHttpClient okHttpClient;
    private static Executor callbackExecutor;

    public CallXAdapterFactory(OkHttpClient okHttpClient) {
        CallXAdapterFactory.okHttpClient = okHttpClient;
        callbackExecutor = okHttpClient.dispatcher().executorService();
    }

    public CallXAdapterFactory(OkHttpClient okHttpClient, Executor callbackExecutor) {
        CallXAdapterFactory.okHttpClient = okHttpClient;
        CallXAdapterFactory.callbackExecutor = callbackExecutor;
    }

    public CallAdapter<?, ?> get(@NotNull Type type, Annotation @NotNull [] annotations, @NotNull Retrofit retrofit) {
        if (CallXAdapterFactory.getRawType((Type)type) != CallX.class) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException("Call must have generic type (e.g., Call<ResponseBody>)");
        }
        Type responseType = CallXAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)type));
        return new CallXAdapter(responseType);
    }

    private static class MyCallXAdapter<T>
    implements CallX<T> {
        private final Call<T> call;

        MyCallXAdapter(Call<T> call) {
            this.call = call;
        }

        @NotNull
        public Response<T> execute() throws IOException {
            return this.call.execute();
        }

        public void enqueue(@NotNull Callback<T> callback) {
            callbackExecutor.execute(() -> this.call.enqueue(callback));
        }

        public boolean isExecuted() {
            return this.call.isExecuted();
        }

        public void cancel() {
            this.call.cancel();
        }

        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @NotNull
        public Call<T> clone() {
            return new MyCallXAdapter<T>(this.call.clone());
        }

        @NotNull
        public Request request() {
            return this.call.request();
        }

        @NotNull
        public Timeout timeout() {
            return this.call.timeout();
        }

        @Override
        public void async(final BiFunction<Response<T>, Throwable, Boolean> callback) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> {
                        boolean isShutdownNeeded = false;
                        isShutdownNeeded = call.isCanceled() ? ((Boolean)callback.apply(null, new IOException("Canceled"))).booleanValue() : ((Boolean)callback.apply(response, null)).booleanValue();
                        if (isShutdownNeeded) {
                            this.shutdown();
                        }
                    });
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> {
                        boolean isShutdownNeeded = false;
                        isShutdownNeeded = (Boolean)callback.apply(null, t);
                        if (isShutdownNeeded) {
                            this.shutdown();
                        }
                    });
                }
            });
        }

        @Override
        public void async(final boolean isShutdownNeeded, final Consumer<Response<T>> onSuccess, final Consumer<Throwable> onFailure) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> {
                        if (call.isCanceled()) {
                            onFailure.accept(new IOException("Canceled"));
                        } else {
                            onSuccess.accept(response);
                        }
                        if (isShutdownNeeded) {
                            this.shutdown();
                        }
                    });
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> {
                        onFailure.accept(t);
                        if (isShutdownNeeded) {
                            this.shutdown();
                        }
                    });
                }
            });
        }

        private void shutdown() {
            if (okHttpClient != null) {
                okHttpClient.dispatcher().executorService().shutdown();
                okHttpClient.connectionPool().evictAll();
            }
        }
    }

    private static final class CallXAdapter<R>
    implements CallAdapter<R, CallX<R>> {
        private final Type responseType;

        CallXAdapter(Type responseType) {
            this.responseType = responseType;
        }

        @NotNull
        public Type responseType() {
            return this.responseType;
        }

        @NotNull
        public CallX<R> adapt(@NotNull Call<R> call) {
            return new MyCallXAdapter<R>(call);
        }
    }
}

