/*
 * Decompiled with CFR 0.152.
 */
package io.github.acdcjunior.java6fp;

import io.github.acdcjunior.java6fp.fn.FPConsumer;
import io.github.acdcjunior.java6fp.fn.FPFunction;
import io.github.acdcjunior.java6fp.fn.FPSupplier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FPOption<T>
implements Iterable<T> {
    @NotNull
    public abstract List<T> toList();

    @Nullable
    public abstract T orNull();

    @NotNull
    public abstract T getOrElse(@NotNull T var1);

    @NotNull
    public abstract T getOrElse(@NotNull FPSupplier<T> var1);

    @NotNull
    public abstract T get();

    public abstract boolean isEmpty();

    public boolean isDefined() {
        return !this.isEmpty();
    }

    @NotNull
    public abstract FPOption<T> orElse(@NotNull T var1);

    @NotNull
    public abstract FPOption<T> orElseFlat(@NotNull FPOption<T> var1);

    @NotNull
    public abstract FPOption<T> filter(@NotNull FPFunction<T, Boolean> var1);

    @NotNull
    public abstract <R> FPOption<R> map(@NotNull FPFunction<T, R> var1);

    @NotNull
    public abstract <R> FPOption<R> flatMap(@NotNull FPFunction<T, FPOption<R>> var1);

    @Override
    public abstract void forEach(@NotNull FPConsumer<T> var1);

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    @NotNull
    public static <R> FPOption<R> some(@NotNull R value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument of FPOption.Some cannot be null");
        }
        return new Some(value);
    }

    @NotNull
    public static <R> FPOption<R> none() {
        return new None();
    }

    @NotNull
    public static <R> FPOption<R> ofNullable(@Nullable R value) {
        return value == null ? FPOption.none() : FPOption.some(value);
    }

    public static final class None<T>
    extends FPOption<T> {
        private None() {
        }

        public String toString() {
            return "None";
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return None.class.hashCode();
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull T orElse) {
            return orElse;
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull FPSupplier<T> orElseFn) {
            return orElseFn.get();
        }

        @Override
        @NotNull
        public T get() {
            throw new IllegalStateException("FPOption.None has no value");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public FPOption<T> orElse(@NotNull T orElse) {
            return None.some(orElse);
        }

        @Override
        @NotNull
        public FPOption<T> orElseFlat(@NotNull FPOption<T> orElse) {
            return orElse;
        }

        @Override
        @NotNull
        public FPOption<T> filter(@NotNull FPFunction<T, Boolean> fn) {
            return this;
        }

        @Override
        @NotNull
        public <R> FPOption<R> map(@NotNull FPFunction<T, R> fn) {
            return None.none();
        }

        @Override
        @NotNull
        public <R> FPOption<R> flatMap(@NotNull FPFunction<T, FPOption<R>> fn) {
            return None.none();
        }

        @Override
        public void forEach(@NotNull FPConsumer<T> fn) {
        }

        @Override
        @NotNull
        public List<T> toList() {
            return Collections.emptyList();
        }
    }

    public static final class Some<T>
    extends FPOption<T> {
        @NotNull
        private final T value;

        private Some(@NotNull T value) {
            this.value = value;
        }

        public String toString() {
            return String.format("Some(%s)", this.orNull());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Some some = (Some)o;
            return this.value.equals(some.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        @NotNull
        public T orNull() {
            return this.get();
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull T orElse) {
            return this.get();
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull FPSupplier<T> orElseFn) {
            return this.get();
        }

        @Override
        @NotNull
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public FPOption<T> orElse(@NotNull T orElse) {
            return this;
        }

        @Override
        @NotNull
        public FPOption<T> orElseFlat(@NotNull FPOption<T> orElse) {
            return this;
        }

        @Override
        @NotNull
        public FPOption<T> filter(@NotNull FPFunction<T, Boolean> fn) {
            return Boolean.TRUE.equals(this.map(fn).orNull()) ? this : FPOption.none();
        }

        @Override
        @NotNull
        public <R> FPOption<R> map(@NotNull FPFunction<T, R> fn) {
            return Some.ofNullable(fn.apply(this.orNull()));
        }

        @Override
        @NotNull
        public <R> FPOption<R> flatMap(@NotNull FPFunction<T, FPOption<R>> fn) {
            FPOption<R> r = fn.apply(this.orNull());
            if (r == null) {
                return FPOption.none();
            }
            return r;
        }

        @Override
        public void forEach(@NotNull FPConsumer<T> fn) {
            fn.accept(this.orNull());
        }

        @Override
        @NotNull
        public List<T> toList() {
            return Collections.singletonList(this.orNull());
        }
    }
}

