/*
 * Decompiled with CFR 0.152.
 */
package cpufeatures;

import cpufeatures.CpuArchitecture;
import cpufeatures.CpuPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CpuFeatures {
    private static final AtomicBoolean loaded = new AtomicBoolean(false);

    private CpuFeatures() {
    }

    public static void load() {
        if (loaded.getAndSet(true)) {
            return;
        }
        CpuPlatform platform = CpuPlatform.get();
        CpuArchitecture arch = CpuArchitecture.get();
        String resourcePath = "cpufeatures/" + (switch (platform) {
            default -> throw new IncompatibleClassChangeError();
            case CpuPlatform.LINUX -> {
                switch (arch) {
                    case X86: {
                        yield "linux_x86/libcpu_features.so";
                    }
                }
                throw new RuntimeException("Invalid architecture " + String.valueOf((Object)arch) + " for Linux");
            }
            case CpuPlatform.WINDOWS -> {
                switch (arch) {
                    case X86: {
                        yield "windows_x86/libcpu_features.dll";
                    }
                }
                throw new RuntimeException("Invalid architecture " + String.valueOf((Object)arch) + " for Windows");
            }
            case CpuPlatform.MACOS -> {
                switch (arch) {
                    case X86: {
                        yield "macos_x86/libcpu_features.dylib";
                    }
                }
                throw new RuntimeException("Invalid architecture " + String.valueOf((Object)arch) + " for MacOS");
            }
        });
        try (InputStream resourceIn = CpuFeatures.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (resourceIn == null) {
                throw new RuntimeException("No native library in JAR at " + resourcePath);
            }
            Path libFile = Files.createTempFile("cpu_features", null, new FileAttribute[0]);
            Files.copy(resourceIn, libFile, StandardCopyOption.REPLACE_EXISTING);
            System.load(libFile.toAbsolutePath().toString());
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load native library", ex);
        }
    }
}

