/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.file;

import dev.utils.common.CollectionUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.file.FilePartItem;
import dev.utils.common.file.FilePartUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FilePartAssist {
    private final File file;
    private final List<FilePartItem> filePartItems = new ArrayList<FilePartItem>();

    public FilePartAssist(File file, List<FilePartItem> filePartItems) {
        this.file = file;
        if (filePartItems != null) {
            this.filePartItems.addAll(filePartItems);
        }
    }

    public FilePartAssist(String filePath, int partCount) {
        this(FileUtils.getFile(filePath), partCount);
    }

    public FilePartAssist(File file, int partCount) {
        this.file = file;
        if (file != null && file.exists() && partCount > 0) {
            long fileByteLength = file.length();
            long partByteLength = fileByteLength / (long)partCount;
            long remainder = fileByteLength - partByteLength * (long)partCount;
            long total = 0L;
            if (partCount > 1) {
                int len = partCount - 1;
                for (int i = 0; i < len; ++i) {
                    FilePartItem item = new FilePartItem(i, partCount, partByteLength, fileByteLength, total, total + partByteLength);
                    total += partByteLength;
                    this.filePartItems.add(item);
                }
            }
            FilePartItem item = new FilePartItem(partCount - 1, partCount, partByteLength, fileByteLength, total, total + partByteLength + remainder);
            this.filePartItems.add(item);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return FileUtils.getFileName(this.file);
    }

    public List<FilePartItem> getFilePartItems() {
        return this.filePartItems;
    }

    public FilePartItem getFilePartItem(int partIndex) {
        return CollectionUtils.get(this.filePartItems, partIndex);
    }

    public int getPartCount() {
        return this.filePartItems.size();
    }

    public boolean existsPart() {
        return this.getPartCount() != 0;
    }

    public boolean isOnlyOne() {
        return this.getPartCount() == 1;
    }

    public String getPartName(int partIndex) {
        return FilePartUtils.getPartName(this.getFileName(), partIndex);
    }
}

