/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.ConvertUtils;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class CloneUtils {
    private static final String TAG = CloneUtils.class.getSimpleName();

    private CloneUtils() {
    }

    public static <T> T deepClone(Serializable data) {
        if (data == null) {
            return null;
        }
        return (T)ConvertUtils.bytesToObject(CloneUtils.serializableToBytes(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializableToBytes(Serializable serializable) {
        byte[] byArray;
        if (serializable == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "serializableToBytes", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(oos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(oos);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(oos);
        return byArray;
    }

    public static <K, V> boolean deepClone(Map<K, V> map, Map<K, V> datas) {
        if (map != null && datas != null && datas.size() > 0) {
            Iterator<Map.Entry<K, V>> iterator = datas.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Map.Entry<K, V> entry = iterator.next();
                    K key = entry.getKey();
                    Object cloneObj = ConvertUtils.bytesToObject(CloneUtils.serializableToBytes((Serializable)entry.getValue()));
                    if (cloneObj == null) continue;
                    map.put(key, cloneObj);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "deepClone", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static <T> boolean deepClone(Collection<T> collection, Collection<T> datas) {
        if (collection != null && datas != null && datas.size() > 0) {
            Iterator<T> iterator = datas.iterator();
            while (iterator.hasNext()) {
                try {
                    Object cloneObj = ConvertUtils.bytesToObject(CloneUtils.serializableToBytes((Serializable)iterator.next()));
                    if (cloneObj == null) continue;
                    collection.add(cloneObj);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "deepClone", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }
}

