/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.Writer;

public final class CloseUtils {
    private static final String TAG = CloseUtils.class.getSimpleName();

    private CloseUtils() {
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "closeIO", new Object[0]);
            }
        }
    }

    public static void closeIOQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable ... flushables) {
        if (flushables == null) {
            return;
        }
        for (Flushable flushable : flushables) {
            if (flushable == null) continue;
            try {
                flushable.flush();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "flush", new Object[0]);
            }
        }
    }

    public static void flushQuietly(Flushable ... flushables) {
        if (flushables == null) {
            return;
        }
        for (Flushable flushable : flushables) {
            if (flushable == null) continue;
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flushCloseIO(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.flush();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "flushCloseIO", new Object[0]);
        }
        try {
            outputStream.close();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "flushCloseIO", new Object[0]);
        }
    }

    public static void flushCloseIOQuietly(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushCloseIO(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "flushCloseIO", new Object[0]);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "flushCloseIO", new Object[0]);
        }
    }

    public static void flushCloseIOQuietly(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

