/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ScaleUtils {
    private static final String TAG = ScaleUtils.class.getSimpleName();
    public static final List<XY> XY_LIST;

    private ScaleUtils() {
    }

    public static double calcScale(double dividend, double divisor) {
        try {
            return dividend / divisor;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScale", new Object[0]);
            return -1.0;
        }
    }

    public static double calcScaleToMath(double value1, double value2) {
        try {
            return Math.max(value1, value2) / Math.min(value1, value2);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToMath", new Object[0]);
            return -1.0;
        }
    }

    public static int[] calcScaleToWidth(int targetWidth, int currentWidth, int currentHeight) {
        try {
            if (currentWidth == 0) {
                return new int[]{0, 0};
            }
            float scale = (float)targetWidth / (float)currentWidth;
            int scaleHeight = (int)(scale * (float)currentHeight);
            return new int[]{targetWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToWidth", new Object[0]);
            return null;
        }
    }

    public static int[] calcScaleToHeight(int targetHeight, int currentWidth, int currentHeight) {
        try {
            if (currentHeight == 0) {
                return new int[]{0, 0};
            }
            float scale = (float)targetHeight / (float)currentHeight;
            int scaleWidth = (int)(scale * (float)currentWidth);
            return new int[]{scaleWidth, targetHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToHeight", new Object[0]);
            return null;
        }
    }

    public static int[] calcWidthHeightToScale(int width, int height, float widthScale, float heightScale) {
        try {
            if (widthScale >= heightScale) {
                int scaleWidth = width;
                int scaleHeight = (int)((float)scaleWidth * (heightScale / widthScale));
                return new int[]{scaleWidth, scaleHeight};
            }
            int scaleHeight = height;
            int scaleWidth = (int)((float)scaleHeight * (widthScale / heightScale));
            return new int[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthHeightToScale", new Object[0]);
            return null;
        }
    }

    public static int[] calcWidthToScale(int width, float widthScale, float heightScale) {
        try {
            int scaleWidth = width;
            int scaleHeight = (int)((float)scaleWidth * (heightScale / widthScale));
            return new int[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthToScale", new Object[0]);
            return null;
        }
    }

    public static int[] calcHeightToScale(int height, float widthScale, float heightScale) {
        try {
            int scaleHeight = height;
            int scaleWidth = (int)((float)scaleHeight * (widthScale / heightScale));
            return new int[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcHeightToScale", new Object[0]);
            return null;
        }
    }

    public static double[] calcScaleToWidth(double targetWidth, double currentWidth, double currentHeight) {
        try {
            if (currentWidth == 0.0) {
                return new double[]{0.0, 0.0};
            }
            double scale = targetWidth / currentWidth;
            double scaleHeight = scale * currentHeight;
            return new double[]{targetWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToWidth", new Object[0]);
            return null;
        }
    }

    public static double[] calcScaleToHeight(double targetHeight, double currentWidth, double currentHeight) {
        try {
            if (currentHeight == 0.0) {
                return new double[]{0.0, 0.0};
            }
            double scale = targetHeight / currentHeight;
            double scaleWidth = scale * currentWidth;
            return new double[]{scaleWidth, targetHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToHeight", new Object[0]);
            return null;
        }
    }

    public static double[] calcWidthHeightToScale(double width, double height, double widthScale, double heightScale) {
        try {
            if (widthScale >= heightScale) {
                double scaleWidth = width;
                double scaleHeight = scaleWidth * (heightScale / widthScale);
                return new double[]{scaleWidth, scaleHeight};
            }
            double scaleHeight = height;
            double scaleWidth = scaleHeight * (widthScale / heightScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthHeightToScale", new Object[0]);
            return null;
        }
    }

    public static double[] calcWidthToScale(double width, double widthScale, double heightScale) {
        try {
            double scaleWidth = width;
            double scaleHeight = scaleWidth * (heightScale / widthScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthToScale", new Object[0]);
            return null;
        }
    }

    public static double[] calcHeightToScale(double height, double widthScale, double heightScale) {
        try {
            double scaleHeight = height;
            double scaleWidth = scaleHeight * (widthScale / heightScale);
            return new double[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcHeightToScale", new Object[0]);
            return null;
        }
    }

    public static long[] calcScaleToWidth(long targetWidth, long currentWidth, long currentHeight) {
        try {
            if (currentWidth == 0L) {
                return new long[]{0L, 0L};
            }
            long scale = targetWidth / currentWidth;
            long scaleHeight = scale * currentHeight;
            return new long[]{targetWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToWidth", new Object[0]);
            return null;
        }
    }

    public static long[] calcScaleToHeight(long targetHeight, long currentWidth, long currentHeight) {
        try {
            if (currentHeight == 0L) {
                return new long[]{0L, 0L};
            }
            long scale = targetHeight / currentHeight;
            long scaleWidth = scale * currentWidth;
            return new long[]{scaleWidth, targetHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToHeight", new Object[0]);
            return null;
        }
    }

    public static long[] calcWidthHeightToScale(long width, long height, long widthScale, long heightScale) {
        try {
            if (widthScale >= heightScale) {
                long scaleWidth = width;
                long scaleHeight = scaleWidth * (heightScale / widthScale);
                return new long[]{scaleWidth, scaleHeight};
            }
            long scaleHeight = height;
            long scaleWidth = scaleHeight * (widthScale / heightScale);
            return new long[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthHeightToScale", new Object[0]);
            return null;
        }
    }

    public static long[] calcWidthToScale(long width, long widthScale, long heightScale) {
        try {
            long scaleWidth = width;
            long scaleHeight = scaleWidth * (heightScale / widthScale);
            return new long[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthToScale", new Object[0]);
            return null;
        }
    }

    public static long[] calcHeightToScale(long height, long widthScale, long heightScale) {
        try {
            long scaleHeight = height;
            long scaleWidth = scaleHeight * (widthScale / heightScale);
            return new long[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcHeightToScale", new Object[0]);
            return null;
        }
    }

    public static float[] calcScaleToWidth(float targetWidth, float currentWidth, float currentHeight) {
        try {
            if (currentWidth == 0.0f) {
                return new float[]{0.0f, 0.0f};
            }
            float scale = targetWidth / currentWidth;
            float scaleHeight = scale * currentHeight;
            return new float[]{targetWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToWidth", new Object[0]);
            return null;
        }
    }

    public static float[] calcScaleToHeight(float targetHeight, float currentWidth, float currentHeight) {
        try {
            if (currentHeight == 0.0f) {
                return new float[]{0.0f, 0.0f};
            }
            float scale = targetHeight / currentHeight;
            float scaleWidth = scale * currentWidth;
            return new float[]{scaleWidth, targetHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcScaleToHeight", new Object[0]);
            return null;
        }
    }

    public static float[] calcWidthHeightToScale(float width, float height, float widthScale, float heightScale) {
        try {
            if (widthScale >= heightScale) {
                float scaleWidth = width;
                float scaleHeight = scaleWidth * (heightScale / widthScale);
                return new float[]{scaleWidth, scaleHeight};
            }
            float scaleHeight = height;
            float scaleWidth = scaleHeight * (widthScale / heightScale);
            return new float[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthHeightToScale", new Object[0]);
            return null;
        }
    }

    public static float[] calcWidthToScale(float width, float widthScale, float heightScale) {
        try {
            float scaleWidth = width;
            float scaleHeight = scaleWidth * (heightScale / widthScale);
            return new float[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcWidthToScale", new Object[0]);
            return null;
        }
    }

    public static float[] calcHeightToScale(float height, float widthScale, float heightScale) {
        try {
            float scaleHeight = height;
            float scaleWidth = scaleHeight * (widthScale / heightScale);
            return new float[]{scaleWidth, scaleHeight};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "calcHeightToScale", new Object[0]);
            return null;
        }
    }

    public static XY calcXY(int x, int y) {
        return ScaleUtils.calcXY(XY_LIST, x, y);
    }

    public static XY calcXY(List<XY> xyLists, int x, int y) {
        if (xyLists != null && xyLists.size() != 0) {
            ArrayList<XY> lists = new ArrayList<XY>(xyLists);
            Collections.sort(lists);
            double scale = ScaleUtils.calcScale(x, y);
            int len = lists.size();
            for (int i = 0; i < len; ++i) {
                XY xy = (XY)lists.get(i);
                if (!(scale >= xy.scale)) continue;
                return xy;
            }
        }
        return null;
    }

    static {
        ArrayList<XY> xys = new ArrayList<XY>();
        xys.add(new XY(16, 9));
        xys.add(new XY(17, 10));
        xys.add(new XY(15, 9));
        xys.add(new XY(16, 10));
        xys.add(new XY(3, 2));
        xys.add(new XY(4, 3));
        xys.add(new XY(5, 4));
        xys.add(new XY(1, 1));
        XY_LIST = Collections.unmodifiableList(xys);
    }

    public static class XY
    implements Comparable<XY> {
        public final int x;
        public final int y;
        public final double scale;
        public final int type;

        public XY(int x, int y) {
            this(x, y, 0);
        }

        public XY(int x, int y, int type) {
            this.x = x;
            this.y = y;
            this.scale = ScaleUtils.calcScale(x, y);
            this.type = type;
        }

        public String getXYx() {
            return this.getXY("x");
        }

        public String getXY() {
            return this.getXY(":");
        }

        public String getXY(String joint) {
            return this.x + joint + this.y;
        }

        @Override
        public int compareTo(XY xy) {
            if (this.scale < xy.scale) {
                return 1;
            }
            if (this.scale > xy.scale) {
                return -1;
            }
            return 0;
        }
    }
}

