/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESUtils {
    private static final String TAG = DESUtils.class.getSimpleName();

    private DESUtils() {
    }

    public static Key getDESKey(byte[] key) {
        if (key == null) {
            return null;
        }
        try {
            DESKeySpec desKey = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            return keyFactory.generateSecret(desKey);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getDESKey", new Object[0]);
            return null;
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        if (data == null || key == null) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "DES");
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "encrypt", new Object[0]);
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        if (data == null || key == null) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "DES");
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "decrypt", new Object[0]);
            return null;
        }
    }
}

