/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.validator;

import dev.utils.JCLogUtils;
import dev.utils.common.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class IDCardUtils {
    private static final String TAG = IDCardUtils.class.getSimpleName();
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    private static final Map<String, String> sCityCodeMaps = new HashMap<String, String>();
    private static final Map<String, Integer> sTWFirstCodeMaps = new HashMap<String, Integer>();
    private static final Map<String, Integer> sHKFirstCodeMaps = new HashMap<String, Integer>();

    private IDCardUtils() {
    }

    public static boolean validateIdCard15(String idCard) {
        if (IDCardUtils.isNumber(idCard) && idCard.length() == 15) {
            String provinceCode = idCard.substring(0, 2);
            if (sCityCodeMaps.get(provinceCode) == null) {
                return false;
            }
            String birthCode = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                JCLogUtils.eTag(TAG, e, "validateIdCard15", new Object[0]);
            }
            Calendar calendar = Calendar.getInstance();
            if (birthDate != null) {
                calendar.setTime(birthDate);
            }
            return IDCardUtils.validateDateSmallerThenNow(calendar.get(1), Integer.valueOf(birthCode.substring(2, 4)), Integer.valueOf(birthCode.substring(4, 6)));
        }
        return false;
    }

    public static boolean validateIdCard18(String idCard) {
        if (idCard != null && idCard.length() == 18) {
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IDCardUtils.isNumber(code17)) {
                try {
                    int[] cardArys = IDCardUtils.convertCharToInt(code17.toCharArray());
                    int sum17 = IDCardUtils.getPowerSum(cardArys);
                    String str = IDCardUtils.getCheckCode18(sum17);
                    if (str.length() > 0 && str.equalsIgnoreCase(code18)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "validateIdCard18", new Object[0]);
                }
            }
        }
        return false;
    }

    public static String convert15CardTo18(String idCard) {
        if (IDCardUtils.isNumber(idCard) && idCard.length() == 15) {
            Date birthDate = null;
            String birthday = idCard.substring(6, 12);
            try {
                birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                JCLogUtils.eTag(TAG, e, "convert15CardTo18", new Object[0]);
            }
            Calendar calendar = Calendar.getInstance();
            if (birthDate != null) {
                calendar.setTime(birthDate);
            }
            try {
                String year = String.valueOf(calendar.get(1));
                String idCard18 = idCard.substring(0, 6) + year + idCard.substring(8);
                int[] cardArys = IDCardUtils.convertCharToInt(idCard18.toCharArray());
                int sum17 = IDCardUtils.getPowerSum(cardArys);
                String str = IDCardUtils.getCheckCode18(sum17);
                return str.length() > 0 ? idCard18 + str : null;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "convert15CardTo18", new Object[0]);
            }
        }
        return null;
    }

    public static boolean validateTWCard(String idCard) {
        if (idCard == null || idCard.length() != 10) {
            return false;
        }
        try {
            String start = idCard.substring(0, 1);
            String mid = idCard.substring(1, 9);
            String end = idCard.substring(9, 10);
            Integer iStart = sTWFirstCodeMaps.get(start);
            Integer sum = iStart / 10 + iStart % 10 * 9;
            char[] chars = mid.toCharArray();
            Integer iflag = 8;
            for (char c : chars) {
                sum = sum + Integer.valueOf(String.valueOf(c)) * iflag;
                Integer n = iflag;
                Integer n2 = iflag = Integer.valueOf(iflag - 1);
            }
            return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "validateTWCard", new Object[0]);
            return false;
        }
    }

    public static boolean validateHKCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return false;
        }
        try {
            Integer sum;
            String card = idCard.replaceAll("[\\(|\\)]", "");
            if (card.length() == 9) {
                sum = (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
                card = card.substring(1, 9);
            } else {
                sum = 522 + (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 8;
            }
            String mid = card.substring(1, 7);
            String end = card.substring(7, 8);
            char[] chars = mid.toCharArray();
            Integer iflag = 7;
            for (char c : chars) {
                sum = sum + Integer.valueOf(String.valueOf(c)) * iflag;
                Integer n = iflag;
                Integer n2 = iflag = Integer.valueOf(iflag - 1);
            }
            sum = end.equalsIgnoreCase("A") ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.valueOf(end));
            return sum % 11 == 0;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "validateHKCard", new Object[0]);
            return false;
        }
    }

    public static String[] validateIdCard10(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return null;
        }
        String[] info = new String[]{"N", "N", "false"};
        try {
            String card = idCard.replaceAll("[\\(|\\)]", "");
            int cardLength = card.length();
            if (cardLength >= 8 || cardLength <= 10) {
                if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
                    info[0] = "\u53f0\u6e7e";
                    String char2 = idCard.substring(1, 2);
                    if (char2.equals("1")) {
                        info[1] = "M";
                    } else if (char2.equals("2")) {
                        info[1] = "F";
                    } else {
                        info[1] = "N";
                        info[2] = "false";
                        return info;
                    }
                    info[2] = IDCardUtils.validateTWCard(idCard) ? "true" : "false";
                } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
                    info[0] = "\u6fb3\u95e8";
                    info[1] = "N";
                } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
                    info[0] = "\u9999\u6e2f";
                    info[1] = "N";
                    info[2] = IDCardUtils.validateHKCard(idCard) ? "true" : "false";
                }
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "validateIdCard10", new Object[0]);
        }
        return info;
    }

    public static boolean validateCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return false;
        }
        String card = idCard.trim();
        if (IDCardUtils.validateIdCard18(card)) {
            return true;
        }
        if (IDCardUtils.validateIdCard15(card)) {
            return true;
        }
        String[] cardArys = IDCardUtils.validateIdCard10(card);
        return cardArys != null && "true".equals(cardArys[2]);
    }

    public static int getAgeByIdCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return 0;
        }
        try {
            String idCardStr = idCard;
            if (idCardStr.length() == 15) {
                idCardStr = IDCardUtils.convert15CardTo18(idCard);
            }
            if (idCardStr.length() == 18) {
                String year = idCardStr.substring(6, 10);
                int currentYear = Calendar.getInstance().get(1);
                return currentYear - Integer.valueOf(year);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getAgeByIdCard", new Object[0]);
        }
        return 0;
    }

    public static String getBirthByIdCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return null;
        }
        try {
            String idCardStr = idCard;
            if (idCardStr.length() == 15) {
                idCardStr = IDCardUtils.convert15CardTo18(idCard);
            }
            if (idCardStr.length() == 18) {
                return idCardStr.substring(6, 14);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getBirthByIdCard", new Object[0]);
        }
        return null;
    }

    public static String getBirthdayByIdCard(String idCard) {
        String birth = IDCardUtils.getBirthByIdCard(idCard);
        if (birth != null) {
            try {
                return birth.replaceAll("(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3");
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getBirthdayByIdCard", new Object[0]);
            }
        }
        return null;
    }

    public static String getYearByIdCard(String idCard) {
        String birth = IDCardUtils.getBirthByIdCard(idCard);
        if (birth != null) {
            try {
                return birth.substring(0, 4);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getYearByIdCard", new Object[0]);
            }
        }
        return null;
    }

    public static String getMonthByIdCard(String idCard) {
        String birth = IDCardUtils.getBirthByIdCard(idCard);
        if (birth != null) {
            try {
                return birth.substring(4, 6);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getMonthByIdCard", new Object[0]);
            }
        }
        return null;
    }

    public static String getDateByIdCard(String idCard) {
        String birth = IDCardUtils.getBirthByIdCard(idCard);
        if (birth != null) {
            try {
                return birth.substring(6, 8);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getDateByIdCard", new Object[0]);
            }
        }
        return null;
    }

    public static String getGenderByIdCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return null;
        }
        try {
            String idCardStr = idCard;
            if (idCardStr.length() == 15) {
                idCardStr = IDCardUtils.convert15CardTo18(idCard);
            }
            if (idCardStr.length() == 18) {
                String cardNumber = idCardStr.substring(16, 17);
                return Integer.parseInt(cardNumber) % 2 == 0 ? "F" : "M";
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getGenderByIdCard", new Object[0]);
        }
        return "N";
    }

    public static String getProvinceByIdCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return null;
        }
        try {
            int idCardLength = idCard.length();
            if (idCardLength == 15 || idCardLength == 18) {
                return sCityCodeMaps.get(idCard.substring(0, 2));
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getProvinceByIdCard", new Object[0]);
        }
        return null;
    }

    public static int getPowerSum(int[] data) {
        if (data == null) {
            return 0;
        }
        int len = data.length;
        if (len == 0) {
            return 0;
        }
        int powerLength = POWER.length;
        int sum = 0;
        if (powerLength == len) {
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < powerLength; ++j) {
                    if (i != j) continue;
                    sum += data[i] * POWER[j];
                }
            }
        }
        return sum;
    }

    public static String getCheckCode18(int sum) {
        String code = "";
        switch (sum % 11) {
            case 10: {
                code = "2";
                break;
            }
            case 9: {
                code = "3";
                break;
            }
            case 8: {
                code = "4";
                break;
            }
            case 7: {
                code = "5";
                break;
            }
            case 6: {
                code = "6";
                break;
            }
            case 5: {
                code = "7";
                break;
            }
            case 4: {
                code = "8";
                break;
            }
            case 3: {
                code = "9";
                break;
            }
            case 2: {
                code = "x";
                break;
            }
            case 1: {
                code = "0";
                break;
            }
            case 0: {
                code = "1";
            }
        }
        return code;
    }

    private static int[] convertCharToInt(char[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        if (len == 0) {
            return null;
        }
        try {
            int[] arrays = new int[len];
            for (int i = 0; i < len; ++i) {
                arrays[i] = Integer.parseInt(String.valueOf(data[i]));
            }
            return arrays;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "convertCharToInt", new Object[0]);
            return null;
        }
    }

    private static boolean validateDateSmallerThenNow(int yearData, int monthData, int dayData) {
        int datePerMonth;
        int year = Calendar.getInstance().get(1);
        int MIN = 1930;
        if (yearData < MIN || yearData >= year) {
            return false;
        }
        if (monthData < 1 || monthData > 12) {
            return false;
        }
        switch (monthData) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (yearData % 4 == 0 && yearData % 100 != 0 || yearData % 400 == 0) && yearData > MIN && yearData < year;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return dayData >= 1 && dayData <= datePerMonth;
    }

    private static boolean isNumber(String str) {
        return !StringUtils.isEmpty(str) && str.matches("^[0-9]*$");
    }

    static {
        sCityCodeMaps.put("11", "\u5317\u4eac");
        sCityCodeMaps.put("12", "\u5929\u6d25");
        sCityCodeMaps.put("13", "\u6cb3\u5317");
        sCityCodeMaps.put("14", "\u5c71\u897f");
        sCityCodeMaps.put("15", "\u5185\u8499\u53e4");
        sCityCodeMaps.put("21", "\u8fbd\u5b81");
        sCityCodeMaps.put("22", "\u5409\u6797");
        sCityCodeMaps.put("23", "\u9ed1\u9f99\u6c5f");
        sCityCodeMaps.put("31", "\u4e0a\u6d77");
        sCityCodeMaps.put("32", "\u6c5f\u82cf");
        sCityCodeMaps.put("33", "\u6d59\u6c5f");
        sCityCodeMaps.put("34", "\u5b89\u5fbd");
        sCityCodeMaps.put("35", "\u798f\u5efa");
        sCityCodeMaps.put("36", "\u6c5f\u897f");
        sCityCodeMaps.put("37", "\u5c71\u4e1c");
        sCityCodeMaps.put("41", "\u6cb3\u5357");
        sCityCodeMaps.put("42", "\u6e56\u5317");
        sCityCodeMaps.put("43", "\u6e56\u5357");
        sCityCodeMaps.put("44", "\u5e7f\u4e1c");
        sCityCodeMaps.put("45", "\u5e7f\u897f");
        sCityCodeMaps.put("46", "\u6d77\u5357");
        sCityCodeMaps.put("50", "\u91cd\u5e86");
        sCityCodeMaps.put("51", "\u56db\u5ddd");
        sCityCodeMaps.put("52", "\u8d35\u5dde");
        sCityCodeMaps.put("53", "\u4e91\u5357");
        sCityCodeMaps.put("54", "\u897f\u85cf");
        sCityCodeMaps.put("61", "\u9655\u897f");
        sCityCodeMaps.put("62", "\u7518\u8083");
        sCityCodeMaps.put("63", "\u9752\u6d77");
        sCityCodeMaps.put("64", "\u5b81\u590f");
        sCityCodeMaps.put("65", "\u65b0\u7586");
        sCityCodeMaps.put("71", "\u53f0\u6e7e");
        sCityCodeMaps.put("81", "\u9999\u6e2f");
        sCityCodeMaps.put("82", "\u6fb3\u95e8");
        sCityCodeMaps.put("83", "\u53f0\u6e7e");
        sCityCodeMaps.put("91", "\u56fd\u5916");
        sTWFirstCodeMaps.put("A", 10);
        sTWFirstCodeMaps.put("B", 11);
        sTWFirstCodeMaps.put("C", 12);
        sTWFirstCodeMaps.put("D", 13);
        sTWFirstCodeMaps.put("E", 14);
        sTWFirstCodeMaps.put("F", 15);
        sTWFirstCodeMaps.put("G", 16);
        sTWFirstCodeMaps.put("H", 17);
        sTWFirstCodeMaps.put("J", 18);
        sTWFirstCodeMaps.put("K", 19);
        sTWFirstCodeMaps.put("L", 20);
        sTWFirstCodeMaps.put("M", 21);
        sTWFirstCodeMaps.put("N", 22);
        sTWFirstCodeMaps.put("P", 23);
        sTWFirstCodeMaps.put("Q", 24);
        sTWFirstCodeMaps.put("R", 25);
        sTWFirstCodeMaps.put("S", 26);
        sTWFirstCodeMaps.put("T", 27);
        sTWFirstCodeMaps.put("U", 28);
        sTWFirstCodeMaps.put("V", 29);
        sTWFirstCodeMaps.put("X", 30);
        sTWFirstCodeMaps.put("Y", 31);
        sTWFirstCodeMaps.put("W", 32);
        sTWFirstCodeMaps.put("Z", 33);
        sTWFirstCodeMaps.put("I", 34);
        sTWFirstCodeMaps.put("O", 35);
        sHKFirstCodeMaps.put("A", 1);
        sHKFirstCodeMaps.put("B", 2);
        sHKFirstCodeMaps.put("C", 3);
        sHKFirstCodeMaps.put("R", 18);
        sHKFirstCodeMaps.put("U", 21);
        sHKFirstCodeMaps.put("Z", 26);
        sHKFirstCodeMaps.put("X", 24);
        sHKFirstCodeMaps.put("W", 23);
        sHKFirstCodeMaps.put("O", 15);
        sHKFirstCodeMaps.put("N", 14);
    }
}

