/*
 * Decompiled with CFR 0.152.
 */
package dev.utils;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class JCLogUtils {
    private static boolean JUDGE_PRINT_LOG = false;
    private static boolean JUDGE_CONTROL_PRINT_LOG = false;
    private static final String DEFAULT_TAG = JCLogUtils.class.getSimpleName();
    public static final int INFO = 0;
    public static final int DEBUG = 1;
    public static final int ERROR = 2;
    private static Print sPrint;

    private JCLogUtils() {
    }

    public static boolean isPrintLog() {
        return JUDGE_PRINT_LOG;
    }

    public static void setPrintLog(boolean judgePrintLog) {
        JUDGE_PRINT_LOG = judgePrintLog;
    }

    public static void setControlPrintLog(boolean judgeControlPrintLog) {
        JUDGE_CONTROL_PRINT_LOG = judgeControlPrintLog;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static void printLog(int logType, String tag, String message) {
        if (sPrint != null) {
            sPrint.printLog(logType, tag, message);
        }
        if (JUDGE_CONTROL_PRINT_LOG) {
            if (JCLogUtils.isEmpty(tag)) {
                System.out.println(message);
            } else {
                System.out.println(tag + " : " + message);
            }
        }
    }

    private static String createMessage(String message, Object ... args) {
        String result;
        try {
            result = message != null ? (args == null ? "params is null" : (args.length == 0 ? message : String.format(message, args))) : "message is null";
        }
        catch (Exception e) {
            result = e.toString();
        }
        return result;
    }

    private static String splitErrorMessage(Throwable throwable, String message, Object ... args) {
        String result;
        try {
            result = throwable != null ? (message != null ? JCLogUtils.createMessage(message, args) + " : " + throwable.toString() : throwable.toString()) : JCLogUtils.createMessage(message, args);
        }
        catch (Exception e) {
            result = e.toString();
        }
        return result;
    }

    public static void d(String message, Object ... args) {
        JCLogUtils.dTag(DEFAULT_TAG, message, args);
    }

    public static void e(Throwable throwable) {
        JCLogUtils.eTag(DEFAULT_TAG, throwable);
    }

    public static void e(String message, Object ... args) {
        JCLogUtils.e(null, message, args);
    }

    public static void e(Throwable throwable, String message, Object ... args) {
        JCLogUtils.eTag(DEFAULT_TAG, throwable, message, args);
    }

    public static void i(String message, Object ... args) {
        JCLogUtils.iTag(DEFAULT_TAG, message, args);
    }

    public static void xml(String xml) {
        JCLogUtils.xmlTag(DEFAULT_TAG, xml);
    }

    public static void dTag(String tag, String message, Object ... args) {
        if (JUDGE_PRINT_LOG) {
            JCLogUtils.printLog(1, tag, JCLogUtils.createMessage(message, args));
        }
    }

    public static void eTag(String tag, String message, Object ... args) {
        if (JUDGE_PRINT_LOG) {
            JCLogUtils.printLog(2, tag, JCLogUtils.createMessage(message, args));
        }
    }

    public static void eTag(String tag, Throwable throwable) {
        if (JUDGE_PRINT_LOG) {
            JCLogUtils.printLog(2, tag, JCLogUtils.splitErrorMessage(throwable, null, new Object[0]));
        }
    }

    public static void eTag(String tag, Throwable throwable, String message, Object ... args) {
        if (JUDGE_PRINT_LOG) {
            JCLogUtils.printLog(2, tag, JCLogUtils.splitErrorMessage(throwable, message, args));
        }
    }

    public static void iTag(String tag, String message, Object ... args) {
        if (JUDGE_PRINT_LOG) {
            JCLogUtils.printLog(0, tag, JCLogUtils.createMessage(message, args));
        }
    }

    public static void xmlTag(String tag, String xml) {
        if (JUDGE_PRINT_LOG) {
            if (JCLogUtils.isEmpty(xml)) {
                JCLogUtils.printLog(2, tag, "Empty/Null xml content");
                return;
            }
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(xml));
                StreamResult xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(xmlInput, xmlOutput);
                String message = xmlOutput.getWriter().toString().replaceFirst(">", ">\n");
                JCLogUtils.printLog(1, tag, message);
            }
            catch (Exception e) {
                String errorInfo = "null";
                if (e != null) {
                    Throwable throwable = e.getCause();
                    if (throwable != null) {
                        errorInfo = throwable.toString();
                    } else {
                        try {
                            errorInfo = e.toString();
                        }
                        catch (Exception e1) {
                            errorInfo = e1.toString();
                        }
                    }
                }
                JCLogUtils.printLog(2, tag, errorInfo + "\n" + xml);
            }
        }
    }

    public static void setPrint(Print print) {
        sPrint = print;
    }

    public static interface Print {
        public void printLog(int var1, String var2, String var3);
    }
}

