/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.NumberUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DateUtils {
    private static final String TAG = DateUtils.class.getSimpleName();
    public static final String yyyy = "yyyy";
    public static final String yyMMdd = "yy-MM-dd";
    public static final String yyMMdd2 = "yyMMdd";
    public static final String yyyyMMdd = "yyyy-MM-dd";
    public static final String yyyyMMdd2 = "yyyyMMdd";
    public static final String yyyyMMdd3 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String yyyyMMdd4 = "yyyy_MM_dd";
    public static final String yyyyMMdd5 = "yyyy.MM.dd";
    public static final String yyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyyMMddHHmmss2 = "yyyy\u5e74M\u6708d\u65e5 HH:mm:ss";
    public static final String yyyyMMddHHmmss3 = "yyyyMMdd_HHmmss";
    public static final String yyyyMMddHHmmss4 = "yyyyMMdd.HHmmss";
    public static final String MMdd = "MM-dd";
    public static final String MMdd2 = "MM\u6708dd\u65e5";
    public static final String MMdd3 = "MMdd";
    public static final String yy = "yy";
    public static final String MM = "MM";
    public static final String dd = "dd";
    public static final String hh = "hh";
    public static final String HH = "HH";
    public static final String mm = "mm";
    public static final String HHmm = "HH:mm";
    public static final String HHmm2 = "HHmm";
    public static final String HHmmss = "HH:mm:ss";
    public static final String HHmmss2 = "HHmmss";
    public static final String hhmmMMDDyyyy = "hh:mm M\u6708d\u65e5 yyyy";
    public static final String hhmmssMMDDyyyy = "hh:mm:ss M\u6708d\u65e5 yyyy";
    public static final String mmddHHmmyyyyss = "MMddHHmmyyyy.ss";
    public static final int MINUTE_S = 60;
    public static final int HOUR_S = 3600;
    public static final int DAY_S = 86400;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    private static final ThreadLocal<Map<String, SimpleDateFormat>> SDF_THREAD_LOCAL = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };
    private static final String[] ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final int[] CONSTELLATION_DAY = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] CONSTELLATION_DATE = new String[]{"01.20-02.18", "02.19-03.20", "03.21-04.19", "04.20-05.20", "05.21-06.21", "06.22-07.22", "07.23-08.22", "08.23-09.22", "09.23-10.23", "10.24-11.22", "11.23-12.21", "12.22-01.19"};
    private static final String[] CONSTELLATION = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};

    private DateUtils() {
    }

    public static SimpleDateFormat getDefaultFormat() {
        return DateUtils.getSafeDateFormat(yyyyMMddHHmmss);
    }

    public static SimpleDateFormat getSafeDateFormat(String pattern) {
        if (pattern == null) {
            return null;
        }
        Map<String, SimpleDateFormat> sdfMap = SDF_THREAD_LOCAL.get();
        SimpleDateFormat format = sdfMap.get(pattern);
        if (format == null) {
            format = new SimpleDateFormat(pattern);
            sdfMap.put(pattern, format);
        }
        return format;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        if (millis == -1L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static Calendar getCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar getCalendar(String time) {
        return DateUtils.getCalendar(DateUtils.parseLong(time, DateUtils.getDefaultFormat()));
    }

    public static Calendar getCalendar(String time, String pattern) {
        return DateUtils.getCalendar(DateUtils.parseLong(time, DateUtils.getSafeDateFormat(pattern)));
    }

    public static Calendar getCalendar(String time, SimpleDateFormat format) {
        return DateUtils.getCalendar(DateUtils.parseLong(time, format));
    }

    public static Date getCurrentTime() {
        return Calendar.getInstance().getTime();
    }

    public static long getCurrentTimeMillis() {
        return DateUtils.getDateTime(Calendar.getInstance().getTime());
    }

    public static long getDateTime(Date date) {
        if (date != null) {
            return date.getTime();
        }
        return -1L;
    }

    public static String getDateNow() {
        return DateUtils.formatTime(DateUtils.getCurrentTimeMillis(), DateUtils.getDefaultFormat());
    }

    public static String getDateNow(String pattern) {
        return DateUtils.formatTime(DateUtils.getCurrentTimeMillis(), DateUtils.getSafeDateFormat(pattern));
    }

    public static String getDateNow(SimpleDateFormat format) {
        return DateUtils.formatTime(DateUtils.getCurrentTimeMillis(), format);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatTime(DateUtils.getDateTime(date), DateUtils.getDefaultFormat());
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.formatTime(DateUtils.getDateTime(date), DateUtils.getSafeDateFormat(pattern));
    }

    public static String formatDate(Date date, SimpleDateFormat format) {
        return DateUtils.formatTime(DateUtils.getDateTime(date), format);
    }

    public static String formatTime(long millis) {
        return DateUtils.formatTime(millis, DateUtils.getDefaultFormat());
    }

    public static String formatTime(long millis, String pattern) {
        return DateUtils.formatTime(millis, DateUtils.getSafeDateFormat(pattern));
    }

    public static String formatTime(long millis, SimpleDateFormat format) {
        if (millis == -1L || format == null) {
            return null;
        }
        try {
            return format.format(millis);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "formatTime", new Object[0]);
            return null;
        }
    }

    public static Date parseDate(long millis) {
        if (millis == -1L) {
            return null;
        }
        return new Date(millis);
    }

    public static Date parseDate(String time) {
        return DateUtils.parseDate(DateUtils.parseLong(time, DateUtils.getDefaultFormat()));
    }

    public static Date parseDate(String time, String pattern) {
        return DateUtils.parseDate(DateUtils.parseLong(time, DateUtils.getSafeDateFormat(pattern)));
    }

    public static Date parseDate(String time, SimpleDateFormat format) {
        return DateUtils.parseDate(DateUtils.parseLong(time, format));
    }

    public static long parseLong(String time) {
        return DateUtils.parseLong(time, DateUtils.getDefaultFormat());
    }

    public static long parseLong(String time, String pattern) {
        return DateUtils.parseLong(time, DateUtils.getSafeDateFormat(pattern));
    }

    public static long parseLong(String time, SimpleDateFormat format) {
        if (time == null || format == null) {
            return -1L;
        }
        try {
            return format.parse(time).getTime();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseLong", new Object[0]);
            return -1L;
        }
    }

    public static String parseStringDefault(String time, String pattern) {
        return DateUtils.parseString(time, DateUtils.getDefaultFormat(), DateUtils.getSafeDateFormat(pattern));
    }

    public static String parseStringDefault(String time, SimpleDateFormat format) {
        return DateUtils.parseString(time, DateUtils.getDefaultFormat(), format);
    }

    public static String parseString(String time, String timePattern, String pattern) {
        return DateUtils.parseString(time, DateUtils.getSafeDateFormat(timePattern), DateUtils.getSafeDateFormat(pattern));
    }

    public static String parseString(String time, SimpleDateFormat timeFormat, SimpleDateFormat format) {
        if (time != null && timeFormat != null && format != null) {
            try {
                long timeLong = DateUtils.parseLong(time, timeFormat);
                return DateUtils.formatTime(timeLong, format);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "parseString", new Object[0]);
            }
        }
        return null;
    }

    public static int getYear(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(1);
        }
        return -1;
    }

    public static int getYear() {
        return DateUtils.getYear(DateUtils.getCalendar());
    }

    public static int getYear(long millis) {
        return DateUtils.getYear(DateUtils.getCalendar(millis));
    }

    public static int getYear(Date date) {
        return DateUtils.getYear(DateUtils.getCalendar(date));
    }

    public static int getYear(String time) {
        return DateUtils.getYear(DateUtils.parseLong(time));
    }

    public static int getYear(String time, String pattern) {
        return DateUtils.getYear(DateUtils.parseLong(time, pattern));
    }

    public static int getYear(String time, SimpleDateFormat format) {
        return DateUtils.getYear(DateUtils.parseLong(time, format));
    }

    public static int getMonth(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(2) + 1;
        }
        return -1;
    }

    public static int getMonth() {
        return DateUtils.getMonth(DateUtils.getCalendar());
    }

    public static int getMonth(long millis) {
        return DateUtils.getMonth(DateUtils.getCalendar(millis));
    }

    public static int getMonth(Date date) {
        return DateUtils.getMonth(DateUtils.getCalendar(date));
    }

    public static int getMonth(String time) {
        return DateUtils.getMonth(DateUtils.parseLong(time));
    }

    public static int getMonth(String time, String pattern) {
        return DateUtils.getMonth(DateUtils.parseLong(time, pattern));
    }

    public static int getMonth(String time, SimpleDateFormat format) {
        return DateUtils.getMonth(DateUtils.parseLong(time, format));
    }

    public static int getDay(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(5);
        }
        return -1;
    }

    public static int getDay() {
        return DateUtils.getDay(DateUtils.getCalendar());
    }

    public static int getDay(long millis) {
        return DateUtils.getDay(DateUtils.getCalendar(millis));
    }

    public static int getDay(Date date) {
        return DateUtils.getDay(DateUtils.getCalendar(date));
    }

    public static int getDay(String time) {
        return DateUtils.getDay(DateUtils.parseLong(time));
    }

    public static int getDay(String time, String pattern) {
        return DateUtils.getDay(DateUtils.parseLong(time, pattern));
    }

    public static int getDay(String time, SimpleDateFormat format) {
        return DateUtils.getDay(DateUtils.parseLong(time, format));
    }

    public static int getWeek(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(7);
        }
        return -1;
    }

    public static int getWeek() {
        return DateUtils.getWeek(DateUtils.getCalendar());
    }

    public static int getWeek(long millis) {
        return DateUtils.getWeek(DateUtils.getCalendar(millis));
    }

    public static int getWeek(Date date) {
        return DateUtils.getWeek(DateUtils.getCalendar(date));
    }

    public static int getWeek(String time) {
        return DateUtils.getWeek(DateUtils.parseLong(time));
    }

    public static int getWeek(String time, String pattern) {
        return DateUtils.getWeek(DateUtils.parseLong(time, pattern));
    }

    public static int getWeek(String time, SimpleDateFormat format) {
        return DateUtils.getWeek(DateUtils.parseLong(time, format));
    }

    public static int get24Hour(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(11);
        }
        return -1;
    }

    public static int get24Hour() {
        return DateUtils.get24Hour(DateUtils.getCalendar());
    }

    public static int get24Hour(long millis) {
        return DateUtils.get24Hour(DateUtils.getCalendar(millis));
    }

    public static int get24Hour(Date date) {
        return DateUtils.get24Hour(DateUtils.getCalendar(date));
    }

    public static int get24Hour(String time) {
        return DateUtils.get24Hour(DateUtils.parseLong(time));
    }

    public static int get24Hour(String time, String pattern) {
        return DateUtils.get24Hour(DateUtils.parseLong(time, pattern));
    }

    public static int get24Hour(String time, SimpleDateFormat format) {
        return DateUtils.get24Hour(DateUtils.parseLong(time, format));
    }

    public static int get12Hour(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(10);
        }
        return -1;
    }

    public static int get12Hour() {
        return DateUtils.get12Hour(DateUtils.getCalendar());
    }

    public static int get12Hour(long millis) {
        return DateUtils.get12Hour(DateUtils.getCalendar(millis));
    }

    public static int get12Hour(Date date) {
        return DateUtils.get12Hour(DateUtils.getCalendar(date));
    }

    public static int get12Hour(String time) {
        return DateUtils.get12Hour(DateUtils.parseLong(time));
    }

    public static int get12Hour(String time, String pattern) {
        return DateUtils.get12Hour(DateUtils.parseLong(time, pattern));
    }

    public static int get12Hour(String time, SimpleDateFormat format) {
        return DateUtils.get12Hour(DateUtils.parseLong(time, format));
    }

    public static int getMinute(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(12);
        }
        return -1;
    }

    public static int getMinute() {
        return DateUtils.getMinute(DateUtils.getCalendar());
    }

    public static int getMinute(long millis) {
        return DateUtils.getMinute(DateUtils.getCalendar(millis));
    }

    public static int getMinute(Date date) {
        return DateUtils.getMinute(DateUtils.getCalendar(date));
    }

    public static int getMinute(String time) {
        return DateUtils.getMinute(DateUtils.parseLong(time));
    }

    public static int getMinute(String time, String pattern) {
        return DateUtils.getMinute(DateUtils.parseLong(time, pattern));
    }

    public static int getMinute(String time, SimpleDateFormat format) {
        return DateUtils.getMinute(DateUtils.parseLong(time, format));
    }

    public static int getSecond(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(13);
        }
        return -1;
    }

    public static int getSecond() {
        return DateUtils.getSecond(DateUtils.getCalendar());
    }

    public static int getSecond(long millis) {
        return DateUtils.getSecond(DateUtils.getCalendar(millis));
    }

    public static int getSecond(Date date) {
        return DateUtils.getSecond(DateUtils.getCalendar(date));
    }

    public static int getSecond(String time) {
        return DateUtils.getSecond(DateUtils.parseLong(time));
    }

    public static int getSecond(String time, String pattern) {
        return DateUtils.getSecond(DateUtils.parseLong(time, pattern));
    }

    public static int getSecond(String time, SimpleDateFormat format) {
        return DateUtils.getSecond(DateUtils.parseLong(time, format));
    }

    public static boolean isAM(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(9) == 0;
        }
        return false;
    }

    public static boolean isAM() {
        return DateUtils.isAM(DateUtils.getCalendar());
    }

    public static boolean isAM(long millis) {
        return DateUtils.isAM(DateUtils.getCalendar(millis));
    }

    public static boolean isAM(Date date) {
        return DateUtils.isAM(DateUtils.getCalendar(date));
    }

    public static boolean isAM(String time) {
        return DateUtils.isAM(DateUtils.parseLong(time));
    }

    public static boolean isAM(String time, String pattern) {
        return DateUtils.isAM(DateUtils.parseLong(time, pattern));
    }

    public static boolean isAM(String time, SimpleDateFormat format) {
        return DateUtils.isAM(DateUtils.parseLong(time, format));
    }

    public static boolean isPM(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(9) == 1;
        }
        return false;
    }

    public static boolean isPM() {
        return DateUtils.isPM(DateUtils.getCalendar());
    }

    public static boolean isPM(long millis) {
        return DateUtils.isPM(DateUtils.getCalendar(millis));
    }

    public static boolean isPM(Date date) {
        return DateUtils.isPM(DateUtils.getCalendar(date));
    }

    public static boolean isPM(String time) {
        return DateUtils.isPM(DateUtils.parseLong(time));
    }

    public static boolean isPM(String time, String pattern) {
        return DateUtils.isPM(DateUtils.parseLong(time, pattern));
    }

    public static boolean isPM(String time, SimpleDateFormat format) {
        return DateUtils.isPM(DateUtils.parseLong(time, format));
    }

    public static boolean isYear(Calendar calendar, int year) {
        return year != -1 && year == DateUtils.getYear(calendar);
    }

    public static boolean isYear(int year) {
        return DateUtils.isYear(DateUtils.getCalendar(), year);
    }

    public static boolean isYear(long millis, int year) {
        return DateUtils.isYear(DateUtils.getCalendar(millis), year);
    }

    public static boolean isYear(Date date, int year) {
        return DateUtils.isYear(DateUtils.getCalendar(date), year);
    }

    public static boolean isYear(String time, int year) {
        return DateUtils.isYear(DateUtils.parseLong(time), year);
    }

    public static boolean isYear(String time, String pattern, int year) {
        return DateUtils.isYear(DateUtils.parseLong(time, pattern), year);
    }

    public static boolean isYear(String time, SimpleDateFormat format, int year) {
        return DateUtils.isYear(DateUtils.parseLong(time, format), year);
    }

    public static boolean isMonth(Calendar calendar, int month) {
        return month != -1 && month == DateUtils.getMonth(calendar);
    }

    public static boolean isMonth(int month) {
        return DateUtils.isMonth(DateUtils.getCalendar(), month);
    }

    public static boolean isMonth(long millis, int month) {
        return DateUtils.isMonth(DateUtils.getCalendar(millis), month);
    }

    public static boolean isMonth(Date date, int month) {
        return DateUtils.isMonth(DateUtils.getCalendar(date), month);
    }

    public static boolean isMonth(String time, int month) {
        return DateUtils.isMonth(DateUtils.parseLong(time), month);
    }

    public static boolean isMonth(String time, String pattern, int month) {
        return DateUtils.isMonth(DateUtils.parseLong(time, pattern), month);
    }

    public static boolean isMonth(String time, SimpleDateFormat format, int month) {
        return DateUtils.isMonth(DateUtils.parseLong(time, format), month);
    }

    public static boolean isDay(Calendar calendar, int day) {
        return day != -1 && day == DateUtils.getDay(calendar);
    }

    public static boolean isDay(int day) {
        return DateUtils.isDay(DateUtils.getCalendar(), day);
    }

    public static boolean isDay(long millis, int day) {
        return DateUtils.isDay(DateUtils.getCalendar(millis), day);
    }

    public static boolean isDay(Date date, int day) {
        return DateUtils.isDay(DateUtils.getCalendar(date), day);
    }

    public static boolean isDay(String time, int day) {
        return DateUtils.isDay(DateUtils.parseLong(time), day);
    }

    public static boolean isDay(String time, String pattern, int day) {
        return DateUtils.isDay(DateUtils.parseLong(time, pattern), day);
    }

    public static boolean isDay(String time, SimpleDateFormat format, int day) {
        return DateUtils.isDay(DateUtils.parseLong(time, format), day);
    }

    public static boolean isWeek(Calendar calendar, int week) {
        return week != -1 && week == DateUtils.getWeek(calendar);
    }

    public static boolean isWeek(int week) {
        return DateUtils.isWeek(DateUtils.getCalendar(), week);
    }

    public static boolean isWeek(long millis, int week) {
        return DateUtils.isWeek(DateUtils.getCalendar(millis), week);
    }

    public static boolean isWeek(Date date, int week) {
        return DateUtils.isWeek(DateUtils.getCalendar(date), week);
    }

    public static boolean isWeek(String time, int week) {
        return DateUtils.isWeek(DateUtils.parseLong(time), week);
    }

    public static boolean isWeek(String time, String pattern, int week) {
        return DateUtils.isWeek(DateUtils.parseLong(time, pattern), week);
    }

    public static boolean isWeek(String time, SimpleDateFormat format, int week) {
        return DateUtils.isWeek(DateUtils.parseLong(time, format), week);
    }

    public static boolean isHour(Calendar calendar, int hour) {
        return hour != -1 && hour == DateUtils.get24Hour(calendar);
    }

    public static boolean isHour(int hour) {
        return DateUtils.isHour(DateUtils.getCalendar(), hour);
    }

    public static boolean isHour(long millis, int hour) {
        return DateUtils.isHour(DateUtils.getCalendar(millis), hour);
    }

    public static boolean isHour(Date date, int hour) {
        return DateUtils.isHour(DateUtils.getCalendar(date), hour);
    }

    public static boolean isHour(String time, int hour) {
        return DateUtils.isHour(DateUtils.parseLong(time), hour);
    }

    public static boolean isHour(String time, String pattern, int hour) {
        return DateUtils.isHour(DateUtils.parseLong(time, pattern), hour);
    }

    public static boolean isHour(String time, SimpleDateFormat format, int hour) {
        return DateUtils.isHour(DateUtils.parseLong(time, format), hour);
    }

    public static boolean isMinute(Calendar calendar, int minute) {
        return minute != -1 && minute == DateUtils.getMinute(calendar);
    }

    public static boolean isMinute(int minute) {
        return DateUtils.isMinute(DateUtils.getCalendar(), minute);
    }

    public static boolean isMinute(long millis, int minute) {
        return DateUtils.isMinute(DateUtils.getCalendar(millis), minute);
    }

    public static boolean isMinute(Date date, int minute) {
        return DateUtils.isMinute(DateUtils.getCalendar(date), minute);
    }

    public static boolean isMinute(String time, int minute) {
        return DateUtils.isMinute(DateUtils.parseLong(time), minute);
    }

    public static boolean isMinute(String time, String pattern, int minute) {
        return DateUtils.isMinute(DateUtils.parseLong(time, pattern), minute);
    }

    public static boolean isMinute(String time, SimpleDateFormat format, int minute) {
        return DateUtils.isMinute(DateUtils.parseLong(time, format), minute);
    }

    public static boolean isSecond(Calendar calendar, int second) {
        return second != -1 && second == DateUtils.getSecond(calendar);
    }

    public static boolean isSecond(int second) {
        return DateUtils.isSecond(DateUtils.getCalendar(), second);
    }

    public static boolean isSecond(long millis, int second) {
        return DateUtils.isSecond(DateUtils.getCalendar(millis), second);
    }

    public static boolean isSecond(Date date, int second) {
        return DateUtils.isSecond(DateUtils.getCalendar(date), second);
    }

    public static boolean isSecond(String time, int second) {
        return DateUtils.isSecond(DateUtils.parseLong(time), second);
    }

    public static boolean isSecond(String time, String pattern, int second) {
        return DateUtils.isSecond(DateUtils.parseLong(time, pattern), second);
    }

    public static boolean isSecond(String time, SimpleDateFormat format, int second) {
        return DateUtils.isSecond(DateUtils.parseLong(time, format), second);
    }

    public static int getSecondMultiple(long millis) {
        return DateUtils.getMillisMultiple(millis, 1000L);
    }

    public static int getMinuteMultiple(long millis) {
        return DateUtils.getMillisMultiple(millis, 60000L);
    }

    public static int getHourMultiple(long millis) {
        return DateUtils.getMillisMultiple(millis, 3600000L);
    }

    public static int getDayMultiple(long millis) {
        return DateUtils.getMillisMultiple(millis, 86400000L);
    }

    public static int getWeekMultiple(long millis) {
        return DateUtils.getMillisMultiple(millis, 604800000L);
    }

    public static int getMillisMultiple(long millis, long unit) {
        if (millis == -1L) {
            return -1;
        }
        return NumberUtils.multipleI(millis, unit);
    }

    public static long getTimeDiffByCurrent(long millis) {
        if (millis == -1L) {
            return -1L;
        }
        return millis - System.currentTimeMillis();
    }

    public static long getTimeDiffByCurrent(Date date) {
        return DateUtils.getTimeDiffByCurrent(DateUtils.getDateTime(date));
    }

    public static long getTimeDiffByCurrent(String time) {
        return DateUtils.getTimeDiffByCurrent(DateUtils.parseLong(time));
    }

    public static long getTimeDiffByCurrent(String time, String pattern) {
        return DateUtils.getTimeDiffByCurrent(DateUtils.parseLong(time, pattern));
    }

    public static long getTimeDiffByCurrent(String time, SimpleDateFormat format) {
        return DateUtils.getTimeDiffByCurrent(DateUtils.parseLong(time, format));
    }

    public static long getTimeDiff(String time1, String time2) {
        return DateUtils.getTimeDiff(time1, DateUtils.getDefaultFormat(), time2, DateUtils.getDefaultFormat());
    }

    public static long getTimeDiff(String time1, String pattern1, String time2, String pattern2) {
        return DateUtils.getTimeDiff(time1, DateUtils.getSafeDateFormat(pattern1), time2, DateUtils.getSafeDateFormat(pattern2));
    }

    public static long getTimeDiff(String time1, SimpleDateFormat timeFormat1, String time2, SimpleDateFormat timeFormat2) {
        long timeLong1 = DateUtils.parseLong(time1, timeFormat1);
        if (timeLong1 == -1L) {
            return -1L;
        }
        long timeLong2 = DateUtils.parseLong(time2, timeFormat2);
        if (timeLong2 == -1L) {
            return -1L;
        }
        return timeLong1 - timeLong2;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getMonthDayNumberAll(int year, int month) {
        int number = 31;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                number = 31;
                break;
            }
            case 2: {
                if (DateUtils.isLeapYear(year)) {
                    number = 29;
                    break;
                }
                number = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                number = 30;
            }
        }
        return number;
    }

    public static int getYearMonthNumber(int year) {
        if (year == DateUtils.getYear()) {
            return DateUtils.getMonth();
        }
        return 12;
    }

    public static int getMonthDayNumber(int year, int month) {
        if (year == DateUtils.getYear() && month == DateUtils.getMonth()) {
            return DateUtils.getDay();
        }
        return DateUtils.getMonthDayNumberAll(year, month);
    }

    public static String timeAddZero(int time) {
        return DateUtils.timeAddZero(time, true);
    }

    public static String timeAddZero(int time, boolean appendZero) {
        return NumberUtils.addZero(time, appendZero);
    }

    public static String[] getArrayToHH(boolean appendZero) {
        List<String> lists = DateUtils.getListToHH(appendZero);
        return lists.toArray(new String[0]);
    }

    public static List<String> getListToHH(boolean appendZero) {
        ArrayList<String> lists = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            lists.add(DateUtils.timeAddZero(i, appendZero));
        }
        return lists;
    }

    public static String[] getArrayToMM(boolean appendZero) {
        List<String> lists = DateUtils.getListToMM(appendZero);
        return lists.toArray(new String[0]);
    }

    public static List<String> getListToMM(boolean appendZero) {
        ArrayList<String> lists = new ArrayList<String>();
        for (int i = 0; i < 60; ++i) {
            lists.add(DateUtils.timeAddZero(i, appendZero));
        }
        return lists;
    }

    public static String[] getArrayToHHMM(int type, boolean appendZero) {
        List<String> lists = DateUtils.getListToHHMM(type, appendZero);
        return lists.toArray(new String[0]);
    }

    public static List<String> getListToHHMM(int type, boolean appendZero) {
        ArrayList<String> lists = new ArrayList<String>();
        switch (type) {
            case 0: {
                for (int i = 0; i < 24; ++i) {
                    lists.add(DateUtils.timeAddZero(i, appendZero) + ":00");
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 96; ++i) {
                    String minute;
                    String hour;
                    if (i % 2 == 0) {
                        hour = DateUtils.timeAddZero(i / 4, appendZero);
                        minute = i % 4 == 0 ? "00" : "30";
                        lists.add(hour + ":" + minute);
                        continue;
                    }
                    hour = DateUtils.timeAddZero(i / 4, appendZero);
                    minute = (i - 1) % 4 == 0 ? "15" : "45";
                    lists.add(hour + ":" + minute);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 48; ++i) {
                    int hour = i / 2;
                    if (i % 2 == 0) {
                        lists.add(DateUtils.timeAddZero(hour, appendZero) + ":00");
                        continue;
                    }
                    lists.add(DateUtils.timeAddZero(hour, appendZero) + ":30");
                }
                break;
            }
        }
        return lists;
    }

    public static int getListToHHMMPosition(String time, int type) {
        String[] timeSplit;
        if (time != null && time.length() != 0 && (timeSplit = time.split(":")).length == 2) {
            int hour = ConvertUtils.toInt(timeSplit[0], -1);
            if (hour < 0) {
                return -1;
            }
            if (hour > 24) {
                return -1;
            }
            switch (type) {
                case 0: {
                    return hour;
                }
                case 1: 
                case 2: {
                    int minute = ConvertUtils.toInt(timeSplit[1], -1);
                    if (minute < 0) {
                        return -1;
                    }
                    if (minute > 59) {
                        return -1;
                    }
                    if (type == 1) {
                        if (minute < 15) {
                            return hour * 4;
                        }
                        if (minute < 30) {
                            return hour * 4 + 1;
                        }
                        if (minute < 45) {
                            return hour * 4 + 2;
                        }
                        return hour * 4 + 3;
                    }
                    if (minute >= 30) {
                        return hour * 2 + 1;
                    }
                    return hour * 2;
                }
            }
        }
        return -1;
    }

    public static String millisToFitTimeSpan(long millis, int precision, boolean appendZero) {
        if (precision >= 1 && precision <= 5) {
            int[] result = DateUtils.millisToTimeArrays(millis);
            String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < precision; ++i) {
                builder.append(DateUtils.timeAddZero(result[i], appendZero)).append(units[i]);
            }
            return builder.toString();
        }
        return "";
    }

    public static int[] millisToTimeArrays(long millis) {
        if (millis > 0L) {
            return NumberUtils.calculateUnitI(millis, new long[]{86400000L, 3600000L, 60000L, 1000L, 1L});
        }
        return new int[5];
    }

    public static String timeConvertByMillis(long millis) {
        return DateUtils.timeConvertByMillis(millis, false);
    }

    public static String timeConvertByMillis(long millis, boolean handlerMoreThanDay) {
        int[] result = DateUtils.millisToTimeArrays(millis);
        if (result[0] > 0 && !handlerMoreThanDay) {
            return null;
        }
        return DateUtils.timeAddZero(result[0] * 24 + result[1]) + ":" + DateUtils.timeAddZero(result[2]) + ":" + DateUtils.timeAddZero(result[3]);
    }

    public static String timeConvertBySecond(long second) {
        return DateUtils.timeConvertBySecond(second, false);
    }

    public static String timeConvertBySecond(long second, boolean handlerMoreThanDay) {
        return DateUtils.timeConvertByMillis(second * 1000L, handlerMoreThanDay);
    }

    public static boolean isInTime(long time, long startTime, long endTime) {
        if (time == -1L || startTime == -1L || endTime == -1L) {
            return false;
        }
        Calendar check = Calendar.getInstance();
        check.setTimeInMillis(time);
        Calendar begin = Calendar.getInstance();
        begin.setTimeInMillis(startTime);
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(endTime);
        if (check.after(begin) && check.before(end)) {
            return true;
        }
        return time == startTime || time == endTime;
    }

    public static boolean isInTime(Date time, Date startTime, Date endTime) {
        return DateUtils.isInTime(DateUtils.getDateTime(time), DateUtils.getDateTime(startTime), DateUtils.getDateTime(endTime));
    }

    public static boolean isInTimeFormat(String time, String startTime, String endTime, String pattern) {
        return DateUtils.isInTimeFormat(time, startTime, endTime, pattern, false);
    }

    public static boolean isInTimeFormat(String time, String startTime, String endTime, String pattern, boolean handlerMoreThanDay) {
        return DateUtils.isInTimeFormat(time, startTime, endTime, DateUtils.getSafeDateFormat(pattern), handlerMoreThanDay);
    }

    public static boolean isInTimeFormat(String time, String startTime, String endTime, SimpleDateFormat format) {
        return DateUtils.isInTimeFormat(time, startTime, endTime, format, false);
    }

    public static boolean isInTimeFormat(String time, String startTime, String endTime, SimpleDateFormat format, boolean handlerMoreThanDay) {
        if (time == null || startTime == null || endTime == null) {
            return false;
        }
        long check = DateUtils.parseLong(time, format);
        long start = DateUtils.parseLong(startTime, format);
        long end = DateUtils.parseLong(endTime, format);
        if (check == -1L || start == -1L || end == -1L) {
            return false;
        }
        if (handlerMoreThanDay && end < start) {
            return check >= start || check <= end;
        }
        return check >= start && check <= end;
    }

    public static boolean isInTimeHHmm(String startTime, String endTime) {
        return DateUtils.isInTimeHHmm(startTime, endTime, true);
    }

    public static boolean isInTimeHHmm(String startTime, String endTime, boolean handlerMoreThanDay) {
        return DateUtils.isInTimeFormat(DateUtils.getDateNow(HHmm), startTime, endTime, HHmm, handlerMoreThanDay);
    }

    public static boolean isInTimeHHmm(String time, String startTime, String endTime) {
        return DateUtils.isInTimeHHmm(time, startTime, endTime, true);
    }

    public static boolean isInTimeHHmm(String time, String startTime, String endTime, boolean handlerMoreThanDay) {
        return DateUtils.isInTimeFormat(time, startTime, endTime, HHmm, handlerMoreThanDay);
    }

    public static boolean isInTimeHHmmss(String startTime, String endTime) {
        return DateUtils.isInTimeHHmmss(startTime, endTime, true);
    }

    public static boolean isInTimeHHmmss(String startTime, String endTime, boolean handlerMoreThanDay) {
        return DateUtils.isInTimeFormat(DateUtils.getDateNow(HHmmss), startTime, endTime, HHmmss, handlerMoreThanDay);
    }

    public static boolean isInTimeHHmmss(String time, String startTime, String endTime) {
        return DateUtils.isInTimeHHmmss(time, startTime, endTime, true);
    }

    public static boolean isInTimeHHmmss(String time, String startTime, String endTime, boolean handlerMoreThanDay) {
        return DateUtils.isInTimeFormat(time, startTime, endTime, HHmmss, handlerMoreThanDay);
    }

    public static long getEndTimeDiffHHmm(String endTime) {
        return DateUtils.getEndTimeDiff(System.currentTimeMillis(), endTime, HHmm);
    }

    public static long getEndTimeDiffHHmm(long startTime, String endTime) {
        return DateUtils.getEndTimeDiff(startTime, endTime, HHmm);
    }

    public static long getEndTimeDiff(String endTime, String format) {
        return DateUtils.getEndTimeDiff(System.currentTimeMillis(), endTime, format);
    }

    public static long getEndTimeDiff(long startTime, String endTime, String format) {
        if (startTime < 1L || endTime == null || format == null) {
            return -1L;
        }
        try {
            boolean isSecond = format.endsWith(":ss");
            String start = DateUtils.formatTime(startTime, format);
            int startNumber = Integer.parseInt(start.replace(":", ""));
            int endNumber = Integer.parseInt(endTime.replace(":", ""));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(startTime));
            if (startNumber > endNumber) {
                calendar.add(5, 1);
            }
            String yyyyMMddDate = DateUtils.formatDate(calendar.getTime(), yyyyMMdd);
            String yyyyMMddHHmmssDate = yyyyMMddDate + " " + endTime + (isSecond ? "" : ":00");
            return DateUtils.parseLong(yyyyMMddHHmmssDate, yyyyMMddHHmmss);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getEndTimeDiff", new Object[0]);
            return -1L;
        }
    }

    public static String getZodiac(int year) {
        return ZODIAC[Math.abs(year) % 12];
    }

    public static String getConstellation(int month, int day) {
        if (month > 12 || month < 1) {
            return null;
        }
        return CONSTELLATION[day >= CONSTELLATION_DAY[month - 1] ? month - 1 : (month + 10) % 12];
    }

    public static String getConstellationDate(int month, int day) {
        if (month > 12 || month < 1) {
            return null;
        }
        return CONSTELLATION_DATE[day >= CONSTELLATION_DAY[month - 1] ? month - 1 : (month + 10) % 12];
    }
}

