/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.JCLogUtils;
import dev.utils.common.DateUtils;
import dev.utils.common.RandomUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.encrypt.MD5Utils;
import java.util.Random;
import java.util.UUID;

public final class DevCommonUtils {
    private static final String TAG = DevCommonUtils.class.getSimpleName();

    private DevCommonUtils() {
    }

    public static StringBuilder timeRecord(StringBuilder builder, long startTime, long endTime) {
        return DevCommonUtils.timeRecord(builder, null, startTime, endTime);
    }

    public static StringBuilder timeRecord(StringBuilder builder, String title, long startTime, long endTime) {
        if (builder == null) {
            return builder;
        }
        long diffTime = endTime - startTime;
        if (!StringUtils.isEmpty((CharSequence)title)) {
            builder.append(DevFinal.NEW_LINE_STR);
            builder.append(title);
        }
        builder.append(DevFinal.NEW_LINE_STR).append("\u5f00\u59cb\u65f6\u95f4: ").append(DateUtils.formatTime(startTime)).append(DevFinal.NEW_LINE_STR).append("\u7ed3\u675f\u65f6\u95f4: ").append(DateUtils.formatTime(endTime)).append(DevFinal.NEW_LINE_STR).append("\u6240\u7528\u65f6\u95f4(\u6beb\u79d2): ").append(diffTime).append(DevFinal.NEW_LINE_STR).append("\u6240\u7528\u65f6\u95f4(\u79d2): ").append(diffTime / 1000L);
        return builder;
    }

    public static long getOperateTime(long operateTime) {
        return DevCommonUtils.getOperateTime(operateTime, -1);
    }

    public static long getOperateTime(long operateTime, int randomTime) {
        int random = 0;
        if (randomTime >= 2) {
            random = RandomUtils.getRandom(randomTime);
        }
        return Math.max(0L, operateTime) + (long)random;
    }

    public static void sleepOperate(long sleepTime) {
        DevCommonUtils.sleepOperate(sleepTime, -1);
    }

    public static void sleepOperate(long sleepTime, int randomTime) {
        long time = DevCommonUtils.getOperateTime(sleepTime, randomTime);
        if (time > 0L) {
            try {
                Thread.sleep(time);
            }
            catch (Throwable throwable) {
                JCLogUtils.eTag(TAG, throwable, "sleepOperate", new Object[0]);
            }
        }
    }

    public static boolean isHttpRes(String str) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            return str.toLowerCase().startsWith("http:") || str.toLowerCase().startsWith("https:");
        }
        return false;
    }

    public static String whileMD5(String str, int number, boolean isUppercase, String ... salts) {
        if (str != null && number >= 1) {
            int saltLen = salts != null ? salts.length : 0;
            String tempString = str;
            if (isUppercase) {
                for (int i = 0; i < number; ++i) {
                    if (saltLen > i) {
                        String salt = salts[i];
                        if (salt != null) {
                            tempString = MD5Utils.md5Upper(tempString + salt);
                            continue;
                        }
                        tempString = MD5Utils.md5Upper(tempString);
                        continue;
                    }
                    tempString = MD5Utils.md5Upper(tempString);
                }
            } else {
                for (int i = 0; i < number; ++i) {
                    if (saltLen > i) {
                        String salt = salts[i];
                        if (salt != null) {
                            tempString = MD5Utils.md5(tempString + salt);
                            continue;
                        }
                        tempString = MD5Utils.md5(tempString);
                        continue;
                    }
                    tempString = MD5Utils.md5(tempString);
                }
            }
            return tempString;
        }
        return str;
    }

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }

    public static int randomUUIDToHashCode() {
        return UUID.randomUUID().hashCode();
    }

    public static int randomUUIDToHashCode(UUID uuid) {
        return uuid != null ? uuid.hashCode() : 0;
    }

    public static UUID getRandomUUID() {
        String random1 = String.valueOf(900000 + new Random().nextInt(10000));
        String random2 = String.valueOf(900000 + new Random().nextInt(10000));
        String time = System.currentTimeMillis() + random1 + random2;
        return new UUID(time.hashCode(), (long)random1.hashCode() << 32 | (long)random2.hashCode());
    }

    public static String getRandomUUIDToString() {
        return DevCommonUtils.getRandomUUID().toString();
    }
}

