/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.encrypt;

import dev.utils.JCLogUtils;
import dev.utils.common.ArrayUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.cipher.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptUtils {
    private static final String TAG = EncryptUtils.class.getSimpleName();

    private EncryptUtils() {
    }

    public static byte[] encryptMD2(byte[] data) {
        return EncryptUtils.hashTemplate(data, "MD2");
    }

    public static String encryptMD2ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptMD2ToHexString(data.getBytes());
    }

    public static String encryptMD2ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptMD2(data));
    }

    public static byte[] encryptMD5(byte[] data) {
        return EncryptUtils.hashTemplate(data, "MD5");
    }

    public static String encryptMD5ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptMD5ToHexString(data.getBytes());
    }

    public static String encryptMD5ToHexString(String data, String salt) {
        if (data == null && salt == null) {
            return null;
        }
        if (salt == null) {
            return ConvertUtils.toHexString(EncryptUtils.encryptMD5(data.getBytes()));
        }
        if (data == null) {
            return ConvertUtils.toHexString(EncryptUtils.encryptMD5(salt.getBytes()));
        }
        return ConvertUtils.toHexString(EncryptUtils.encryptMD5((data + salt).getBytes()));
    }

    public static String encryptMD5ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptMD5(data));
    }

    public static String encryptMD5ToHexString(byte[] data, byte[] salt) {
        if (data == null && salt == null) {
            return null;
        }
        if (salt == null) {
            return ConvertUtils.toHexString(EncryptUtils.encryptMD5(data));
        }
        if (data == null) {
            return ConvertUtils.toHexString(EncryptUtils.encryptMD5(salt));
        }
        byte[] bytes = ArrayUtils.arrayCopy(data, salt);
        return ConvertUtils.toHexString(EncryptUtils.encryptMD5(bytes));
    }

    public static byte[] encryptMD5File(String filePath) {
        File file = StringUtils.isEmpty((CharSequence)filePath) ? null : new File(filePath);
        return EncryptUtils.encryptMD5File(file);
    }

    public static String encryptMD5FileToHexString(String filePath) {
        File file = StringUtils.isEmpty((CharSequence)filePath) ? null : new File(filePath);
        return EncryptUtils.encryptMD5FileToHexString(file);
    }

    public static String encryptMD5FileToHexString(File file) {
        return ConvertUtils.toHexString(EncryptUtils.encryptMD5File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptMD5File(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, digest);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            digest = dis.getMessageDigest();
            byArray = digest.digest();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                JCLogUtils.eTag(TAG, e, "encryptMD5File", new Object[0]);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(dis);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(dis);
            return byArray2;
        }
        CloseUtils.closeIOQuietly(dis);
        return byArray;
    }

    public static byte[] encryptSHA1(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-1");
    }

    public static String encryptSHA1ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptSHA1ToHexString(data.getBytes());
    }

    public static String encryptSHA1ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptSHA1(data));
    }

    public static byte[] encryptSHA224(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA224");
    }

    public static String encryptSHA224ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptSHA224ToHexString(data.getBytes());
    }

    public static String encryptSHA224ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptSHA224(data));
    }

    public static byte[] encryptSHA256(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-256");
    }

    public static String encryptSHA256ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptSHA256ToHexString(data.getBytes());
    }

    public static String encryptSHA256ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptSHA256(data));
    }

    public static byte[] encryptSHA384(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-384");
    }

    public static String encryptSHA384ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptSHA384ToHexString(data.getBytes());
    }

    public static String encryptSHA384ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptSHA384(data));
    }

    public static byte[] encryptSHA512(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-512");
    }

    public static String encryptSHA512ToHexString(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptSHA512ToHexString(data.getBytes());
    }

    public static String encryptSHA512ToHexString(byte[] data) {
        return ConvertUtils.toHexString(EncryptUtils.encryptSHA512(data));
    }

    public static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(data);
            return digest.digest();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "hashTemplate", new Object[0]);
            return null;
        }
    }

    public static byte[] encryptHmacMD5(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacMD5");
    }

    public static String encryptHmacMD5ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacMD5ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacMD5ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacMD5(data, key));
    }

    public static byte[] encryptHmacSHA1(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA1");
    }

    public static String encryptHmacSHA1ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacSHA1ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA1ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacSHA1(data, key));
    }

    public static byte[] encryptHmacSHA224(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA224");
    }

    public static String encryptHmacSHA224ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacSHA224ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA224ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacSHA224(data, key));
    }

    public static byte[] encryptHmacSHA256(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA256");
    }

    public static String encryptHmacSHA256ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacSHA256ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA256ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacSHA256(data, key));
    }

    public static byte[] encryptHmacSHA384(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA384");
    }

    public static String encryptHmacSHA384ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacSHA384ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA384ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacSHA384(data, key));
    }

    public static byte[] encryptHmacSHA512(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA512");
    }

    public static String encryptHmacSHA512ToHexString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return EncryptUtils.encryptHmacSHA512ToHexString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA512ToHexString(byte[] data, byte[] key) {
        return ConvertUtils.toHexString(EncryptUtils.encryptHmacSHA512(data, key));
    }

    public static byte[] hmacTemplate(byte[] data, byte[] key, String algorithm) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "hmacTemplate", new Object[0]);
            return null;
        }
    }

    public static byte[] encryptDES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DES", transformation, iv, true);
    }

    public static byte[] encryptDESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptDES(data, key, transformation, iv));
    }

    public static String encryptDESToHexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return ConvertUtils.toHexString(EncryptUtils.encryptDES(data, key, transformation, iv));
    }

    public static byte[] decryptDES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DES", transformation, iv, false);
    }

    public static byte[] decryptDESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptDES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decryptDESToHexString(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptDES(ConvertUtils.decodeHex(data), key, transformation, iv);
    }

    public static byte[] encrypt3DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DESede", transformation, iv, true);
    }

    public static byte[] encrypt3DESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encrypt3DES(data, key, transformation, iv));
    }

    public static String encrypt3DESToHexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return ConvertUtils.toHexString(EncryptUtils.encrypt3DES(data, key, transformation, iv));
    }

    public static byte[] decrypt3DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DESede", transformation, iv, false);
    }

    public static byte[] decrypt3DESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decrypt3DES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decrypt3DESToHexString(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decrypt3DES(ConvertUtils.decodeHex(data), key, transformation, iv);
    }

    public static byte[] encryptAES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "AES", transformation, iv, true);
    }

    public static byte[] encryptAESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptAES(data, key, transformation, iv));
    }

    public static String encryptAESToHexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return ConvertUtils.toHexString(EncryptUtils.encryptAES(data, key, transformation, iv));
    }

    public static byte[] decryptAES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "AES", transformation, iv, false);
    }

    public static byte[] decryptAESToBase64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptAES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decryptAESToHexString(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptAES(ConvertUtils.decodeHex(data), key, transformation, iv);
    }

    public static byte[] symmetricTemplate(byte[] data, byte[] key, String algorithm, String transformation, byte[] iv, boolean isEncrypt) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKey secretKey;
            if ("DES".equals(algorithm)) {
                DESKeySpec desKey = new DESKeySpec(key);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                secretKey = keyFactory.generateSecret(desKey);
            } else {
                secretKey = new SecretKeySpec(key, algorithm);
            }
            Cipher cipher = Cipher.getInstance(transformation);
            if (iv == null || iv.length == 0) {
                cipher.init(isEncrypt ? 1 : 2, secretKey);
            } else {
                IvParameterSpec params = new IvParameterSpec(iv);
                cipher.init(isEncrypt ? 1 : 2, (Key)secretKey, params);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "symmetricTemplate", new Object[0]);
            return null;
        }
    }

    public static byte[] encryptRSA(byte[] data, byte[] key, boolean isPublicKey, String transformation) {
        return EncryptUtils.rsaTemplate(data, key, isPublicKey, transformation, true);
    }

    public static byte[] encryptRSAToBase64(byte[] data, byte[] key, boolean isPublicKey, String transformation) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptRSA(data, key, isPublicKey, transformation));
    }

    public static String encryptRSAToHexString(byte[] data, byte[] key, boolean isPublicKey, String transformation) {
        return ConvertUtils.toHexString(EncryptUtils.encryptRSA(data, key, isPublicKey, transformation));
    }

    public static byte[] decryptRSA(byte[] data, byte[] key, boolean isPublicKey, String transformation) {
        return EncryptUtils.rsaTemplate(data, key, isPublicKey, transformation, false);
    }

    public static byte[] decryptRSAToBase64(byte[] data, byte[] key, boolean isPublicKey, String transformation) {
        return EncryptUtils.decryptRSA(EncryptUtils.base64Decode(data), key, isPublicKey, transformation);
    }

    public static byte[] decryptRSAToHexString(String data, byte[] key, boolean isPublicKey, String transformation) {
        return EncryptUtils.decryptRSA(ConvertUtils.decodeHex(data), key, isPublicKey, transformation);
    }

    public static byte[] rsaTemplate(byte[] data, byte[] key, boolean isPublicKey, String transformation, boolean isEncrypt) {
        if (data == null || key == null) {
            return null;
        }
        try {
            Key rsaKey;
            EncodedKeySpec keySpec;
            int dataLength = data.length;
            int keyLength = key.length;
            if (dataLength == 0 || keyLength == 0) {
                return null;
            }
            if (isPublicKey) {
                keySpec = new X509EncodedKeySpec(key);
                rsaKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            } else {
                keySpec = new PKCS8EncodedKeySpec(key);
                rsaKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            if (rsaKey == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(isEncrypt ? 1 : 2, rsaKey);
            int maxLen = isEncrypt ? 117 : 128;
            int count = dataLength / maxLen;
            if (count > 0) {
                byte[] ret = new byte[]{};
                byte[] buffer = new byte[maxLen];
                int index = 0;
                for (int i = 0; i < count; ++i) {
                    System.arraycopy(data, index, buffer, 0, maxLen);
                    ret = ArrayUtils.arrayCopy(ret, cipher.doFinal(buffer));
                    index += maxLen;
                }
                if (index != dataLength) {
                    int restLen = dataLength - index;
                    buffer = new byte[restLen];
                    System.arraycopy(data, index, buffer, 0, restLen);
                    ret = ArrayUtils.arrayCopy(ret, cipher.doFinal(buffer));
                }
                return ret;
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "rsaTemplate", new Object[0]);
            return null;
        }
    }

    private static byte[] base64Encode(byte[] input) {
        if (input == null) {
            return null;
        }
        return Base64.encode(input, 2);
    }

    private static byte[] base64Decode(byte[] input) {
        if (input == null) {
            return null;
        }
        return Base64.decode(input, 2);
    }
}

