/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigDecimalUtils {
    private static final String TAG = BigDecimalUtils.class.getSimpleName();
    private static int NEW_SCALE = 10;
    private static int ROUNDING_MODE = 1;

    private BigDecimalUtils() {
    }

    public static void setScale(int scale, int roundingMode) {
        NEW_SCALE = scale;
        ROUNDING_MODE = roundingMode;
    }

    public static BigDecimal getBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double)value);
            }
            if (value instanceof Long) {
                return new BigDecimal((Long)value);
            }
            if (value instanceof Float) {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
            if (value instanceof Integer) {
                return new BigDecimal((Integer)value);
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getBigDecimal", new Object[0]);
        }
        return null;
    }

    public static Operation operation(Object value) {
        return new Operation(value);
    }

    public static Operation operation(Object value, Config config) {
        return new Operation(value, config);
    }

    public static String adjustDouble(String value, int numOfIntPart, int numOfDecimalPart) {
        if (value == null) {
            return null;
        }
        try {
            int i;
            int j;
            String[] array = value.split("\\.");
            char[] tempA = new char[numOfIntPart];
            char[] tempB = new char[numOfDecimalPart];
            if (array[0].length() == numOfIntPart) {
                int i2;
                for (i2 = 0; i2 < array[0].length(); ++i2) {
                    tempA[i2] = array[0].charAt(i2);
                }
                if (numOfDecimalPart <= array[1].length()) {
                    for (i2 = 0; i2 < numOfDecimalPart; ++i2) {
                        tempB[i2] = array[1].charAt(i2);
                    }
                }
                if (numOfDecimalPart > array[1].length()) {
                    for (i2 = 0; i2 < numOfDecimalPart; ++i2) {
                        tempB[i2] = i2 < array[1].length() ? array[1].charAt(i2) : (char)48;
                    }
                }
                if (numOfDecimalPart == 0) {
                    return String.valueOf(tempA) + String.valueOf(tempB);
                }
                return String.valueOf(tempA) + "." + String.valueOf(tempB);
            }
            if (array[0].length() > numOfIntPart) {
                int i3;
                int j2;
                int i4 = array[0].length() - 1;
                for (j2 = 0; i4 >= array[0].length() - numOfIntPart && j2 < numOfIntPart; --i4, ++j2) {
                    tempA[j2] = array[0].charAt(i4);
                }
                char[] tempA1 = new char[numOfIntPart];
                j2 = 0;
                for (int k = tempA.length - 1; j2 < numOfIntPart && k >= 0; ++j2, --k) {
                    tempA1[j2] = tempA[k];
                }
                if (numOfDecimalPart <= array[1].length()) {
                    for (i3 = 0; i3 < numOfDecimalPart; ++i3) {
                        tempB[i3] = array[1].charAt(i3);
                    }
                }
                if (numOfDecimalPart > array[1].length()) {
                    for (i3 = 0; i3 < numOfDecimalPart; ++i3) {
                        tempB[i3] = i3 < array[1].length() ? array[1].charAt(i3) : (char)48;
                    }
                }
                return String.valueOf(tempA1) + "." + String.valueOf(tempB);
            }
            char[] tempA1 = new char[numOfIntPart];
            int i5 = array[0].length() - 1;
            for (j = 0; i5 >= 0 && j < numOfIntPart; --i5, ++j) {
                tempA1[j] = array[0].charAt(i5);
            }
            for (i5 = array[0].length(); i5 < array[0].length() + numOfIntPart - array[0].length(); ++i5) {
                tempA1[i5] = 48;
            }
            char[] tempA2 = new char[numOfIntPart];
            j = 0;
            for (int k = tempA1.length - 1; j < numOfIntPart && k >= 0; --k, ++j) {
                tempA2[j] = tempA1[k];
            }
            if (numOfDecimalPart > array[1].length()) {
                for (i = 0; i < numOfDecimalPart; ++i) {
                    tempB[i] = i < array[1].length() ? array[1].charAt(i) : (char)48;
                }
            }
            if (numOfDecimalPart <= array[1].length()) {
                for (i = 0; i < numOfDecimalPart; ++i) {
                    tempB[i] = array[1].charAt(i);
                }
            }
            if (numOfDecimalPart == 0) {
                return String.valueOf(tempA2) + String.valueOf(tempB);
            }
            return String.valueOf(tempA2) + "." + String.valueOf(tempB);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "adjustDouble", new Object[0]);
            return null;
        }
    }

    public static double add(Object v1, Object v2) throws Exception {
        return BigDecimalUtils.add(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double add(Object v1, Object v2, int scale) throws Exception {
        return BigDecimalUtils.add(v1, v2, scale, ROUNDING_MODE);
    }

    public static double add(Object v1, Object v2, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.add(v1, v2, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.add(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double add(Object v1, Object v2, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).add(v2).setScale(scale, roundingMode).requireNonNull().doubleValue();
    }

    public static double subtract(Object v1, Object v2) throws Exception {
        return BigDecimalUtils.subtract(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double subtract(Object v1, Object v2, int scale) throws Exception {
        return BigDecimalUtils.subtract(v1, v2, scale, ROUNDING_MODE);
    }

    public static double subtract(Object v1, Object v2, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.subtract(v1, v2, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.subtract(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double subtract(Object v1, Object v2, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).subtract(v2).setScale(scale, roundingMode).requireNonNull().doubleValue();
    }

    public static double multiply(Object v1, Object v2) throws Exception {
        return BigDecimalUtils.multiply(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double multiply(Object v1, Object v2, int scale) throws Exception {
        return BigDecimalUtils.multiply(v1, v2, scale, ROUNDING_MODE);
    }

    public static double multiply(Object v1, Object v2, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.multiply(v1, v2, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.multiply(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double multiply(Object v1, Object v2, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).multiply(v2).setScale(scale, roundingMode).requireNonNull().doubleValue();
    }

    public static double divide(Object v1, Object v2) throws Exception {
        return BigDecimalUtils.divide(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double divide(Object v1, Object v2, int scale) throws Exception {
        return BigDecimalUtils.divide(v1, v2, scale, ROUNDING_MODE);
    }

    public static double divide(Object v1, Object v2, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.divide(v1, v2, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.divide(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double divide(Object v1, Object v2, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).divide(v2, scale, roundingMode).requireNonNull().doubleValue();
    }

    public static double remainder(Object v1, Object v2) throws Exception {
        return BigDecimalUtils.remainder(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double remainder(Object v1, Object v2, int scale) throws Exception {
        return BigDecimalUtils.remainder(v1, v2, scale, ROUNDING_MODE);
    }

    public static double remainder(Object v1, Object v2, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.remainder(v1, v2, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.remainder(v1, v2, NEW_SCALE, ROUNDING_MODE);
    }

    public static double remainder(Object v1, Object v2, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).remainder(v2).setScale(scale, roundingMode).requireNonNull().doubleValue();
    }

    public static double round(Object v1) throws Exception {
        return BigDecimalUtils.round(v1, NEW_SCALE, ROUNDING_MODE);
    }

    public static double round(Object v1, int scale) throws Exception {
        return BigDecimalUtils.round(v1, scale, ROUNDING_MODE);
    }

    public static double round(Object v1, Config config) throws Exception {
        if (config != null) {
            return BigDecimalUtils.round(v1, config.getScale(), config.getRoundingMode());
        }
        return BigDecimalUtils.round(v1, NEW_SCALE, ROUNDING_MODE);
    }

    public static double round(Object v1, int scale, int roundingMode) throws Exception {
        return BigDecimalUtils.operation(v1).setThrowError(true).round(scale, roundingMode).requireNonNull().doubleValue();
    }

    public static int compareTo(Object v1, Object v2) {
        try {
            return BigDecimalUtils.operation(v1).setThrowError(true).compareTo(v2);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "compareTo", new Object[0]);
            return -2;
        }
    }

    public static final class Operation {
        private BigDecimal mValue;
        private Config mConfig;
        private boolean mThrowError = false;

        public Operation(Object value) {
            this(value, null);
        }

        public Operation(Object value, Config config) {
            this.mValue = BigDecimalUtils.getBigDecimal(value);
            this.mConfig = config;
        }

        public Operation requireNonNull() {
            if (this.mValue != null) {
                return this;
            }
            throw new NullPointerException("mValue is null");
        }

        private void throwException() {
            if (this.mThrowError) {
                throw new CalculateException();
            }
        }

        public BigDecimal getBigDecimal() {
            return this.mValue;
        }

        public Operation setBigDecimal(Object value) {
            this.mValue = BigDecimalUtils.getBigDecimal(value);
            return this;
        }

        public Config getConfig() {
            return this.mConfig;
        }

        public Operation setConfig(Config config) {
            return this.setConfig(config, true);
        }

        public Operation setConfig(Config config, boolean set) {
            this.mConfig = config;
            if (set) {
                this.setScaleByConfig();
            }
            return this;
        }

        public Operation removeConfig() {
            return this.setConfig(null, false);
        }

        public Operation setScale(int scale, int roundingMode) {
            return this.setScale(new Config(scale, roundingMode));
        }

        public Operation setScale(Config config) {
            if (this.mValue != null && config != null) {
                try {
                    this.mValue = this.mValue.setScale(config.getScale(), config.getRoundingMode());
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "setScale", new Object[0]);
                    this.throwException();
                }
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation setScaleByConfig() {
            return this.setScale(this.mConfig);
        }

        public boolean isThrowError() {
            return this.mThrowError;
        }

        public Operation setThrowError(boolean throwError) {
            this.mThrowError = throwError;
            return this;
        }

        public Operation clone() {
            return new Operation(this.mValue, this.mConfig);
        }

        public String toString() {
            return this.mValue != null ? this.mValue.toString() : null;
        }

        public String toPlainString() {
            return this.mValue != null ? this.mValue.toPlainString() : null;
        }

        public String toEngineeringString() {
            return this.mValue != null ? this.mValue.toEngineeringString() : null;
        }

        public int intValue() {
            return this.mValue != null ? this.mValue.intValue() : 0;
        }

        public float floatValue() {
            return this.mValue != null ? this.mValue.floatValue() : 0.0f;
        }

        public long longValue() {
            return this.mValue != null ? this.mValue.longValue() : 0L;
        }

        public double doubleValue() {
            return this.mValue != null ? this.mValue.doubleValue() : 0.0;
        }

        public Operation add(Object value) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                this.mValue = this.mValue.add(bigDecimal);
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation subtract(Object value) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                this.mValue = this.mValue.subtract(bigDecimal);
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation multiply(Object value) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                this.mValue = this.mValue.multiply(bigDecimal);
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation divide(Object value) {
            return this.divide(value, this.mConfig);
        }

        public Operation divide(Object value, Config config) {
            if (config != null) {
                return this.divide(value, config.getScale(), config.getRoundingMode());
            }
            return this.divide(value, NEW_SCALE, ROUNDING_MODE);
        }

        public Operation divide(Object value, int scale, int roundingMode) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                try {
                    this.mValue = this.mValue.divide(bigDecimal, scale, roundingMode);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "divide", new Object[0]);
                    this.throwException();
                }
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation remainder(Object value) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                this.mValue = this.mValue.remainder(bigDecimal);
            } else {
                this.throwException();
            }
            return this;
        }

        public Operation round() {
            return this.round(this.mConfig);
        }

        public Operation round(Config config) {
            return this.divide(new BigDecimal("1"), config);
        }

        public Operation round(int scale, int roundingMode) {
            return this.divide(new BigDecimal("1"), scale, roundingMode);
        }

        public int compareTo(Object value) {
            BigDecimal bigDecimal = BigDecimalUtils.getBigDecimal(value);
            if (this.mValue != null && bigDecimal != null) {
                try {
                    return this.mValue.compareTo(bigDecimal);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "compareTo", new Object[0]);
                    this.throwException();
                }
            } else {
                this.throwException();
            }
            return -2;
        }

        public String formatMoney() {
            return this.formatMoney(this.mConfig);
        }

        public String formatMoney(int splitNumber, String splitSymbol) {
            return this.formatMoney(this.mConfig, splitNumber, splitSymbol);
        }

        public String formatMoney(Config config) {
            return this.formatMoney(config, 3, ",");
        }

        public String formatMoney(Config config, int splitNumber, String splitSymbol) {
            if (config != null) {
                return this.formatMoney(config.getScale(), config.getRoundingMode(), splitNumber, splitSymbol);
            }
            return this.formatMoney(NEW_SCALE, ROUNDING_MODE, splitNumber, splitSymbol);
        }

        public String formatMoney(int scale, int mode, int splitNumber, String splitSymbol) {
            if (this.mValue == null) {
                return null;
            }
            try {
                int len;
                if (this.mValue.doubleValue() == 0.0) {
                    return this.mValue.setScale(scale, mode).toPlainString();
                }
                String valuePlain = this.mValue.toPlainString();
                boolean isNegative = valuePlain.startsWith("-");
                BigDecimal bigDecimal = new BigDecimal(isNegative ? valuePlain.substring(1) : valuePlain);
                valuePlain = bigDecimal.setScale(scale, mode).toPlainString();
                String[] values = valuePlain.split("\\.");
                boolean isDecimal = values.length == 2;
                String symbol = splitSymbol != null ? splitSymbol : "";
                int number = Math.max(splitNumber, 0);
                StringBuilder builder = new StringBuilder();
                int splitPos = 1;
                for (int i = len = values[0].length() - 1; i >= 0; --i) {
                    char ch = values[0].charAt(i);
                    builder.append(ch);
                    if (number > 0 && splitPos % number == 0 && i != 0) {
                        builder.append(symbol);
                    }
                    ++splitPos;
                }
                builder.reverse();
                if (isDecimal) {
                    builder.append(".").append(values[1]);
                }
                return isNegative ? "-" + builder.toString() : builder.toString();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "formatMoney", new Object[0]);
                return null;
            }
        }
    }

    public static final class Config {
        private final int mScale;
        private final int mRoundingMode;

        public Config() {
            this(NEW_SCALE, ROUNDING_MODE);
        }

        public Config(int scale, int roundingMode) {
            this.mScale = scale;
            this.mRoundingMode = roundingMode;
        }

        public int getScale() {
            return this.mScale;
        }

        public int getRoundingMode() {
            return this.mRoundingMode;
        }
    }

    public static class CalculateException
    extends RuntimeException {
    }
}

