/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtils {
    private static final String TAG = StreamUtils.class.getSimpleName();

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream inputToOutputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (inputStream == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer, 0, 1024)) != -1) {
                baos.write(buffer, 0, len);
            }
            byteArrayOutputStream = baos;
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                JCLogUtils.eTag(TAG, e, "inputToOutputStream", new Object[0]);
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(inputStream);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(inputStream);
            return byteArrayOutputStream2;
        }
        CloseUtils.closeIOQuietly(inputStream);
        return byteArrayOutputStream;
    }

    public static ByteArrayInputStream outputToInputStream(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputToInputStream", new Object[0]);
            return null;
        }
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            return StreamUtils.inputToOutputStream(inputStream).toByteArray();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "inputStreamToBytes", new Object[0]);
            return null;
        }
    }

    public static InputStream bytesToInputStream(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "bytesToInputStream", new Object[0]);
            return null;
        }
    }

    public static byte[] outputStreamToBytes(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        try {
            return ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputStreamToBytes", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytesToOutputStream(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            baos.write(bytes);
            byteArrayOutputStream = baos;
        }
        catch (Exception e) {
            OutputStream outputStream;
            try {
                JCLogUtils.eTag(TAG, e, "bytesToOutputStream", new Object[0]);
                outputStream = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(baos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(baos);
            return outputStream;
        }
        CloseUtils.closeIOQuietly(baos);
        return byteArrayOutputStream;
    }

    public static String inputStreamToString(InputStream inputStream, String charsetName) {
        if (inputStream == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new String(StreamUtils.inputStreamToBytes(inputStream), charsetName);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "inputStreamToString", new Object[0]);
            return null;
        }
    }

    public static InputStream stringToInputStream(String str, String charsetName) {
        if (str == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(str.getBytes(charsetName));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "stringToInputStream", new Object[0]);
            return null;
        }
    }

    public static String outputStreamToString(OutputStream outputStream, String charsetName) {
        if (outputStream == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new String(StreamUtils.outputStreamToBytes(outputStream), charsetName);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputStreamToString", new Object[0]);
            return null;
        }
    }

    public static OutputStream stringToOutputStream(String str, String charsetName) {
        if (str == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return StreamUtils.bytesToOutputStream(str.getBytes(charsetName));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "stringToOutputStream", new Object[0]);
            return null;
        }
    }
}

