/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeUtils {
    private static final String TAG = TypeUtils.class.getSimpleName();

    private TypeUtils() {
    }

    public static Type getArrayType(final Type type) {
        if (type == null) {
            return null;
        }
        try {
            return new GenericArrayType(){

                @Override
                public Type getGenericComponentType() {
                    return type;
                }
            };
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getArrayType", new Object[0]);
            return null;
        }
    }

    public static Type getListType(Type type) {
        if (type == null) {
            return null;
        }
        try {
            return new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getListType", new Object[0]);
            return null;
        }
    }

    public static Type getSetType(Type type) {
        if (type == null) {
            return null;
        }
        try {
            return new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)Set.class));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getSetType", new Object[0]);
            return null;
        }
    }

    public static Type getMapType(Type keyType, Type valueType) {
        if (keyType == null || valueType == null) {
            return null;
        }
        try {
            return new ParameterizedTypeImpl(new Type[]{keyType, valueType}, null, (Type)((Object)Map.class));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMapType", new Object[0]);
            return null;
        }
    }

    public static Type getType(Type rawType, Type ... typeArguments) {
        try {
            return new ParameterizedTypeImpl(typeArguments, null, rawType);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getType", new Object[0]);
            return null;
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type ownerType;
        private final Type rawType;

        public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
            this.actualTypeArguments = actualTypeArguments;
            this.ownerType = ownerType;
            this.rawType = rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)object;
            if (!Arrays.equals(this.actualTypeArguments, that.actualTypeArguments)) {
                return false;
            }
            if (this.ownerType != null ? !this.ownerType.equals(that.ownerType) : that.ownerType != null) {
                return false;
            }
            return this.rawType != null ? this.rawType.equals(that.rawType) : that.rawType == null;
        }

        public int hashCode() {
            int result = this.actualTypeArguments != null ? Arrays.hashCode(this.actualTypeArguments) : 0;
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
            return result;
        }
    }
}

