/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.validator;

import dev.utils.JCLogUtils;
import dev.utils.common.StringUtils;
import java.util.regex.Pattern;

public final class ValidatorUtils {
    private static final String TAG = ValidatorUtils.class.getSimpleName();

    private ValidatorUtils() {
    }

    public static boolean match(String regex, String input) {
        if (!StringUtils.isEmpty((CharSequence)input)) {
            try {
                return Pattern.matches(regex, input);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "match", new Object[0]);
            }
        }
        return false;
    }

    public static boolean isNumber(String str) {
        return ValidatorUtils.match("^[0-9]*$", str);
    }

    public static boolean isNumberDecimal(String str) {
        return ValidatorUtils.match("^[0-9]*[.]?[0-9]*$", str);
    }

    public static boolean isLetter(String str) {
        return ValidatorUtils.match("^[A-Za-z]+$", str);
    }

    public static boolean isContainNumber(String str) {
        return ValidatorUtils.match(".*\\d+.*", str);
    }

    public static boolean isNumberLetter(String str) {
        return ValidatorUtils.match("^[A-Za-z0-9]+$", str);
    }

    public static boolean isSpec(String str) {
        return ValidatorUtils.match("^[\\u4E00-\\u9FA5A-Za-z0-9]+$", str);
    }

    public static boolean isWx(String str) {
        return ValidatorUtils.match("^[a-zA-Z]{1}[-_a-zA-Z0-9]{5,19}+$", str);
    }

    public static boolean isRealName(String str) {
        return ValidatorUtils.match("^[\\u4e00-\\u9fa5]+(\u2022[\\u4e00-\\u9fa5]*)*$|^[\\u4e00-\\u9fa5]+(\u00b7[\\u4e00-\\u9fa5]*)*$", str);
    }

    public static boolean isNickName(String str) {
        return ValidatorUtils.match("^[\\u4E00-\\u9FA5A-Za-z0-9_]+$", str);
    }

    public static boolean isUserName(String str) {
        return ValidatorUtils.match("^[a-zA-Z]\\w{5,17}$", str);
    }

    public static boolean isPassword(String str) {
        return ValidatorUtils.match("^[a-zA-Z0-9]{6,18}$", str);
    }

    public static boolean isEmail(String str) {
        return ValidatorUtils.match("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", str);
    }

    public static boolean isUrl(String str) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            return ValidatorUtils.match("http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?", str.toLowerCase());
        }
        return false;
    }

    public static boolean isIPAddress(String str) {
        return ValidatorUtils.match("(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})", str);
    }

    public static boolean isChinese(String str) {
        return ValidatorUtils.match("^[\u4e00-\u9fa5]+$", str);
    }

    public static boolean isChineseAll(String str) {
        return ValidatorUtils.match("^[\u0391-\uffe5]+$", str);
    }

    public static boolean isContainChinese(String str) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            try {
                int length = str.length();
                if (length != 0) {
                    char[] dChar = str.toCharArray();
                    for (int i = 0; i < length; ++i) {
                        boolean flag = String.valueOf(dChar[i]).matches("[\u0391-\uffe5]");
                        if (!flag) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "isContainChinese", new Object[0]);
            }
        }
        return false;
    }
}

