/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public final class ObjectUtils {
    private static final String TAG = ObjectUtils.class.getSimpleName();

    private ObjectUtils() {
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        try {
            if (object.getClass().isArray() && Array.getLength(object) == 0) {
                return true;
            }
            if (object instanceof CharSequence && object.toString().length() == 0) {
                return true;
            }
            if (object instanceof Collection && ((Collection)object).isEmpty()) {
                return true;
            }
            if (object instanceof Map && ((Map)object).isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "isEmpty", new Object[0]);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    public static <T> boolean equals(T value1, T value2) {
        if (value1 != null && value2 != null) {
            try {
                if (value1 instanceof String && value2 instanceof String) {
                    return value1.equals(value2);
                }
                if (value1 instanceof CharSequence && value2 instanceof CharSequence) {
                    CharSequence v1 = (CharSequence)value1;
                    CharSequence v2 = (CharSequence)value2;
                    int length = v1.length();
                    if (length == v2.length()) {
                        for (int i = 0; i < length; ++i) {
                            if (v1.charAt(i) == v2.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                return value1.equals(value2);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "equals", new Object[0]);
                return false;
            }
        }
        return value1 == null && value2 == null;
    }

    public static <T> T requireNonNull(T object, String message) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <T> T getOrDefault(T object, T defaultObject) {
        return object != null ? object : defaultObject;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static String getObjectTag(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + Integer.toHexString(object.hashCode());
    }

    public static <T> T convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (T)object;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "convert", new Object[0]);
            return null;
        }
    }
}

