/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.comparator;

import dev.utils.common.comparator.sort.DateSort;
import dev.utils.common.comparator.sort.DateSortAsc;
import dev.utils.common.comparator.sort.DateSortDesc;
import dev.utils.common.comparator.sort.DoubleSort;
import dev.utils.common.comparator.sort.DoubleSortAsc;
import dev.utils.common.comparator.sort.DoubleSortDesc;
import dev.utils.common.comparator.sort.FileLastModifiedSortAsc;
import dev.utils.common.comparator.sort.FileLastModifiedSortDesc;
import dev.utils.common.comparator.sort.FileLengthSortAsc;
import dev.utils.common.comparator.sort.FileLengthSortDesc;
import dev.utils.common.comparator.sort.FileNameSortAsc;
import dev.utils.common.comparator.sort.FileNameSortDesc;
import dev.utils.common.comparator.sort.FileSortAsc;
import dev.utils.common.comparator.sort.FileSortDesc;
import dev.utils.common.comparator.sort.FloatSort;
import dev.utils.common.comparator.sort.FloatSortAsc;
import dev.utils.common.comparator.sort.FloatSortDesc;
import dev.utils.common.comparator.sort.IntSort;
import dev.utils.common.comparator.sort.IntSortAsc;
import dev.utils.common.comparator.sort.IntSortDesc;
import dev.utils.common.comparator.sort.LongSort;
import dev.utils.common.comparator.sort.LongSortAsc;
import dev.utils.common.comparator.sort.LongSortDesc;
import dev.utils.common.comparator.sort.StringSort;
import dev.utils.common.comparator.sort.StringSortAsc;
import dev.utils.common.comparator.sort.StringSortDesc;
import dev.utils.common.comparator.sort.StringSortWindowsSimple;
import dev.utils.common.comparator.sort.StringSortWindowsSimple2;
import dev.utils.common.comparator.sort.WindowsExplorerFileSimpleComparator;
import dev.utils.common.comparator.sort.WindowsExplorerFileSimpleComparator2;
import dev.utils.common.comparator.sort.WindowsExplorerStringSimpleComparator;
import dev.utils.common.comparator.sort.WindowsExplorerStringSimpleComparator2;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ComparatorUtils {
    private ComparatorUtils() {
    }

    public static boolean reverse(List<?> list) {
        if (list != null) {
            Collections.reverse(list);
            return true;
        }
        return false;
    }

    public static <T> boolean sort(List<T> list, Comparator<? super T> comparator) {
        if (list != null) {
            Collections.sort(list, comparator);
            return true;
        }
        return false;
    }

    public static <T extends Comparable<? super T>> boolean sortAsc(List<T> list) {
        if (list != null) {
            Collections.sort(list);
            return true;
        }
        return false;
    }

    public static <T> boolean sortDesc(List<T> list) {
        return ComparatorUtils.sort(list, Collections.reverseOrder());
    }

    public static <T extends File> boolean sortFileLastModifiedAsc(List<T> list) {
        return ComparatorUtils.sort(list, new FileLastModifiedSortAsc());
    }

    public static <T extends File> boolean sortFileLastModifiedDesc(List<T> list) {
        return ComparatorUtils.sort(list, new FileLastModifiedSortDesc());
    }

    public static <T extends File> boolean sortFileLengthAsc(List<T> list) {
        return ComparatorUtils.sort(list, new FileLengthSortAsc());
    }

    public static <T extends File> boolean sortFileLengthDesc(List<T> list) {
        return ComparatorUtils.sort(list, new FileLengthSortDesc());
    }

    public static <T extends File> boolean sortFileNameAsc(List<T> list) {
        return ComparatorUtils.sort(list, new FileNameSortAsc());
    }

    public static <T extends File> boolean sortFileNameDesc(List<T> list) {
        return ComparatorUtils.sort(list, new FileNameSortDesc());
    }

    public static <T extends File> boolean sortFileAsc(List<T> list) {
        return ComparatorUtils.sort(list, new FileSortAsc());
    }

    public static <T extends File> boolean sortFileDesc(List<T> list) {
        return ComparatorUtils.sort(list, new FileSortDesc());
    }

    public static <T extends DateSort> boolean sortDateAsc(List<T> list) {
        return ComparatorUtils.sort(list, new DateSortAsc());
    }

    public static <T extends DateSort> boolean sortDateDesc(List<T> list) {
        return ComparatorUtils.sort(list, new DateSortDesc());
    }

    public static <T extends DoubleSort> boolean sortDoubleAsc(List<T> list) {
        return ComparatorUtils.sort(list, new DoubleSortAsc());
    }

    public static <T extends DoubleSort> boolean sortDoubleDesc(List<T> list) {
        return ComparatorUtils.sort(list, new DoubleSortDesc());
    }

    public static <T extends FloatSort> boolean sortFloatAsc(List<T> list) {
        return ComparatorUtils.sort(list, new FloatSortAsc());
    }

    public static <T extends FloatSort> boolean sortFloatDesc(List<T> list) {
        return ComparatorUtils.sort(list, new FloatSortDesc());
    }

    public static <T extends IntSort> boolean sortIntAsc(List<T> list) {
        return ComparatorUtils.sort(list, new IntSortAsc());
    }

    public static <T extends IntSort> boolean sortIntDesc(List<T> list) {
        return ComparatorUtils.sort(list, new IntSortDesc());
    }

    public static <T extends LongSort> boolean sortLongAsc(List<T> list) {
        return ComparatorUtils.sort(list, new LongSortAsc());
    }

    public static <T extends LongSort> boolean sortLongDesc(List<T> list) {
        return ComparatorUtils.sort(list, new LongSortDesc());
    }

    public static <T extends StringSort> boolean sortStringAsc(List<T> list) {
        return ComparatorUtils.sort(list, new StringSortAsc());
    }

    public static <T extends StringSort> boolean sortStringDesc(List<T> list) {
        return ComparatorUtils.sort(list, new StringSortDesc());
    }

    public static <T extends StringSort> boolean sortStringWindowsSimpleAsc(List<T> list) {
        return ComparatorUtils.sort(list, new StringSortWindowsSimple());
    }

    public static <T extends StringSort> boolean sortStringWindowsSimpleDesc(List<T> list) {
        boolean result = ComparatorUtils.sortStringWindowsSimpleAsc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }

    public static <T extends StringSort> boolean sortStringWindowsSimple2Asc(List<T> list) {
        return ComparatorUtils.sort(list, new StringSortWindowsSimple2());
    }

    public static <T extends StringSort> boolean sortStringWindowsSimple2Desc(List<T> list) {
        boolean result = ComparatorUtils.sortStringWindowsSimple2Asc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }

    public static boolean sortWindowsExplorerFileSimpleComparatorAsc(List<File> list) {
        return ComparatorUtils.sort(list, new WindowsExplorerFileSimpleComparator());
    }

    public static boolean sortWindowsExplorerFileSimpleComparatorDesc(List<File> list) {
        boolean result = ComparatorUtils.sortWindowsExplorerFileSimpleComparatorAsc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }

    public static boolean sortWindowsExplorerFileSimpleComparator2Asc(List<File> list) {
        return ComparatorUtils.sort(list, new WindowsExplorerFileSimpleComparator2());
    }

    public static boolean sortWindowsExplorerFileSimpleComparator2Desc(List<File> list) {
        boolean result = ComparatorUtils.sortWindowsExplorerFileSimpleComparator2Asc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }

    public static boolean sortWindowsExplorerStringSimpleComparatorAsc(List<String> list) {
        return ComparatorUtils.sort(list, new WindowsExplorerStringSimpleComparator());
    }

    public static boolean sortWindowsExplorerStringSimpleComparatorDesc(List<String> list) {
        boolean result = ComparatorUtils.sortWindowsExplorerStringSimpleComparatorAsc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }

    public static boolean sortWindowsExplorerStringSimpleComparator2Asc(List<String> list) {
        return ComparatorUtils.sort(list, new WindowsExplorerStringSimpleComparator2());
    }

    public static boolean sortWindowsExplorerStringSimpleComparator2Desc(List<String> list) {
        boolean result = ComparatorUtils.sortWindowsExplorerStringSimpleComparator2Asc(list);
        if (result) {
            ComparatorUtils.reverse(list);
        }
        return result;
    }
}

