/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

public final class ForUtils {
    private static final String TAG = ForUtils.class.getSimpleName();

    private ForUtils() {
    }

    public static <T> boolean forArgs(Consumer<T> action, T ... args) {
        return ForUtils.forArgs(action, false, args);
    }

    public static <T> boolean forArgs(Consumer<T> action, boolean checkLength, T ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                T value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static <T> boolean forSimpleArgs(ConsumerSimple<T> action, T ... args) {
        return ForUtils.forSimpleArgs(action, false, args);
    }

    public static <T> boolean forSimpleArgs(ConsumerSimple<T> action, boolean checkLength, T ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (T value : args) {
                action.accept(value);
            }
            return true;
        }
        return false;
    }

    public static boolean forInts(IntConsumer action, int ... args) {
        return ForUtils.forInts(action, false, args);
    }

    public static boolean forInts(IntConsumer action, boolean checkLength, int ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                int value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forDoubles(DoubleConsumer action, double ... args) {
        return ForUtils.forDoubles(action, false, args);
    }

    public static boolean forDoubles(DoubleConsumer action, boolean checkLength, double ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                double value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forFloats(FloatConsumer action, float ... args) {
        return ForUtils.forFloats(action, false, args);
    }

    public static boolean forFloats(FloatConsumer action, boolean checkLength, float ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                float value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forLongs(LongConsumer action, long ... args) {
        return ForUtils.forLongs(action, false, args);
    }

    public static boolean forLongs(LongConsumer action, boolean checkLength, long ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                long value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forBooleans(BooleanConsumer action, boolean ... args) {
        return ForUtils.forBooleans(action, false, args);
    }

    public static boolean forBooleans(BooleanConsumer action, boolean checkLength, boolean ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                boolean value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forBytes(ByteConsumer action, byte ... args) {
        return ForUtils.forBytes(action, false, args);
    }

    public static boolean forBytes(ByteConsumer action, boolean checkLength, byte ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                byte value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forChars(CharConsumer action, char ... args) {
        return ForUtils.forChars(action, false, args);
    }

    public static boolean forChars(CharConsumer action, boolean checkLength, char ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                char value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forShorts(ShortConsumer action, short ... args) {
        return ForUtils.forShorts(action, false, args);
    }

    public static boolean forShorts(ShortConsumer action, boolean checkLength, short ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                short value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static interface ShortConsumer {
        public void accept(int var1, short var2);
    }

    public static interface CharConsumer {
        public void accept(int var1, char var2);
    }

    public static interface ByteConsumer {
        public void accept(int var1, byte var2);
    }

    public static interface BooleanConsumer {
        public void accept(int var1, boolean var2);
    }

    public static interface LongConsumer {
        public void accept(int var1, long var2);
    }

    public static interface FloatConsumer {
        public void accept(int var1, float var2);
    }

    public static interface DoubleConsumer {
        public void accept(int var1, double var2);
    }

    public static interface IntConsumer {
        public void accept(int var1, int var2);
    }

    public static interface ConsumerSimple<T> {
        public void accept(T var1);
    }

    public static interface Consumer<T> {
        public void accept(int var1, T var2);
    }
}

