/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.assist.record;

import dev.utils.common.DateUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.assist.record.RecordInsert;
import java.io.File;
import java.util.Date;

public final class RecordConfig {
    private final String mStoragePath;
    private final String mFileName = "log_record.txt";
    private final String mFolderName;
    private final TIME mFileIntervalTime;
    private boolean mHandler;
    private boolean mInsertHeaderData;
    private RecordInsert mRecordInsert;

    private RecordConfig(String storagePath, String folderName, TIME fileIntervalTime, boolean handler, boolean insertHeaderData) {
        this.mStoragePath = storagePath;
        this.mFolderName = folderName;
        this.mFileIntervalTime = fileIntervalTime;
        this.mHandler = handler;
        this.mInsertHeaderData = insertHeaderData;
    }

    public static RecordConfig get(String storagePath, String folderName) {
        return RecordConfig.get(storagePath, folderName, TIME.DEFAULT, true, true);
    }

    public static RecordConfig get(String storagePath, String folderName, TIME fileIntervalTime) {
        return RecordConfig.get(storagePath, folderName, fileIntervalTime, true, true);
    }

    public static RecordConfig get(String storagePath, String folderName, TIME fileIntervalTime, boolean handler) {
        return RecordConfig.get(storagePath, folderName, fileIntervalTime, handler, true);
    }

    public static RecordConfig get(String storagePath, String folderName, TIME fileIntervalTime, boolean handler, boolean insertHeaderData) {
        if (StringUtils.isEmpty(storagePath, folderName)) {
            return null;
        }
        return new RecordConfig(storagePath, folderName, fileIntervalTime != null ? fileIntervalTime : TIME.DEFAULT, handler, insertHeaderData);
    }

    public String getStoragePath() {
        return this.mStoragePath;
    }

    public String getFileName() {
        return "log_record.txt";
    }

    public String getFolderName() {
        return this.mFolderName;
    }

    public TIME getFileIntervalTime() {
        return this.mFileIntervalTime;
    }

    public boolean isHandler() {
        return this.mHandler;
    }

    public RecordConfig setHandler(boolean handler) {
        this.mHandler = handler;
        return this;
    }

    public boolean isInsertHeaderData() {
        return this.mInsertHeaderData;
    }

    public RecordConfig setInsertHeaderData(boolean insertHeaderData) {
        this.mInsertHeaderData = insertHeaderData;
        return this;
    }

    public RecordInsert getRecordInsert() {
        return this.mRecordInsert;
    }

    public RecordInsert getRecordInsert(RecordInsert defaultValue) {
        if (this.mRecordInsert != null) {
            return this.mRecordInsert;
        }
        return defaultValue;
    }

    public RecordConfig setRecordInsert(RecordInsert recordInsert) {
        this.mRecordInsert = recordInsert;
        return this;
    }

    public String getFinalPath() {
        File file = FileUtils.getFile(this.mStoragePath, this.getIntervalTimeFolder());
        FileUtils.createFolder(file);
        return FileUtils.getAbsolutePath(file);
    }

    private String getIntervalTimeFolder() {
        String folder = String.format("FileRecord/%s/%s/", DateUtils.getDateNow("yyyy_MM_dd"), this.mFolderName);
        switch (this.mFileIntervalTime) {
            case DEFAULT: {
                return folder;
            }
            case HH: 
            case MM: 
            case SS: {
                Date date = new Date();
                String hh_Format = DateUtils.timeAddZero(DateUtils.get24Hour(date));
                if (this.mFileIntervalTime == TIME.HH) {
                    return folder + "HH_" + hh_Format + File.separator;
                }
                String mm_Format = DateUtils.timeAddZero(DateUtils.getMinute(date));
                if (this.mFileIntervalTime == TIME.MM) {
                    return folder + "HH_" + hh_Format + "/MM_" + mm_Format + File.separator;
                }
                String ss_Format = DateUtils.timeAddZero(DateUtils.getSecond(date));
                return folder + "HH_" + hh_Format + "/MM_" + mm_Format + "/SS_" + ss_Format + File.separator;
            }
        }
        return null;
    }

    public static enum TIME {
        DEFAULT,
        HH,
        MM,
        SS;

    }
}

