/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.format;

import dev.utils.common.BigDecimalUtils;
import dev.utils.common.NumberUtils;

public class UnitSpanFormatter {
    private final int precision;
    private final boolean appendZero;
    private final String defaultValue;

    public UnitSpanFormatter(int precision, boolean appendZero, String defaultValue) {
        this.precision = precision;
        this.appendZero = appendZero;
        this.defaultValue = defaultValue;
    }

    public static UnitSpanFormatter get(int precision) {
        return new UnitSpanFormatter(precision, false, null);
    }

    public static UnitSpanFormatter get(int precision, String defaultValue) {
        return new UnitSpanFormatter(precision, false, defaultValue);
    }

    public static UnitSpanFormatter get(int precision, boolean appendZero) {
        return new UnitSpanFormatter(precision, appendZero, null);
    }

    public static UnitSpanFormatter get(int precision, boolean appendZero, String defaultValue) {
        return new UnitSpanFormatter(precision, appendZero, defaultValue);
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isAppendZero() {
        return this.appendZero;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String format(double[] values, String[] units) {
        return this.format(values, units, null);
    }

    public String format(double[] values, String[] units, BigDecimalUtils.Operation operation) {
        if (this.precision > 0 && values != null && units != null && this.precision <= values.length && this.precision <= units.length) {
            BigDecimalUtils.Operation op = null;
            if (operation != null) {
                op = operation.clone();
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.precision; ++i) {
                if (op != null) {
                    String value = op.setBigDecimal(values[i]).round().toPlainString();
                    builder.append(value);
                } else {
                    builder.append(values[i]);
                }
                builder.append(units[i]);
            }
            return builder.toString();
        }
        return this.defaultValue;
    }

    public String format(float[] values, String[] units) {
        return this.format(values, units, (BigDecimalUtils.Operation)null);
    }

    public String format(float[] values, String[] units, BigDecimalUtils.Operation operation) {
        if (this.precision > 0 && values != null && units != null && this.precision <= values.length && this.precision <= units.length) {
            BigDecimalUtils.Operation op = null;
            if (operation != null) {
                op = operation.clone();
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.precision; ++i) {
                if (op != null) {
                    String value = op.setBigDecimal(Float.valueOf(values[i])).round().toPlainString();
                    builder.append(value);
                } else {
                    builder.append(values[i]);
                }
                builder.append(units[i]);
            }
            return builder.toString();
        }
        return this.defaultValue;
    }

    public String format(long[] values, String[] units) {
        if (this.precision > 0 && values != null && units != null && this.precision <= values.length && this.precision <= units.length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.precision; ++i) {
                long value = values[i];
                builder.append(NumberUtils.addZero(value, this.appendZero)).append(units[i]);
            }
            return builder.toString();
        }
        return this.defaultValue;
    }

    public String format(int[] values, String[] units) {
        if (this.precision > 0 && values != null && units != null && this.precision <= values.length && this.precision <= units.length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.precision; ++i) {
                long value = values[i];
                builder.append(NumberUtils.addZero(value, this.appendZero)).append(units[i]);
            }
            return builder.toString();
        }
        return this.defaultValue;
    }

    public String format(Object[] values, String[] units) {
        if (this.precision > 0 && values != null && units != null && this.precision <= values.length && this.precision <= units.length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.precision; ++i) {
                builder.append(values[i]).append(units[i]);
            }
            return builder.toString();
        }
        return this.defaultValue;
    }

    public String formatBySpan(double value, double[] unitSpans, String[] units) {
        return this.formatBySpan(value, unitSpans, units, null);
    }

    public String formatBySpan(double value, double[] unitSpans, String[] units, BigDecimalUtils.Operation operation) {
        if (unitSpans != null && units != null) {
            double[] values = NumberUtils.calculateUnitD(value, unitSpans);
            return this.format(values, units, operation);
        }
        return this.defaultValue;
    }

    public String formatBySpan(float value, float[] unitSpans, String[] units) {
        return this.formatBySpan(value, unitSpans, units, (BigDecimalUtils.Operation)null);
    }

    public String formatBySpan(float value, float[] unitSpans, String[] units, BigDecimalUtils.Operation operation) {
        if (unitSpans != null && units != null) {
            float[] values = NumberUtils.calculateUnitF(value, unitSpans);
            return this.format(values, units, operation);
        }
        return this.defaultValue;
    }

    public String formatBySpan(long value, long[] unitSpans, String[] units) {
        if (unitSpans != null && units != null) {
            long[] values = NumberUtils.calculateUnitL(value, unitSpans);
            return this.format(values, units);
        }
        return this.defaultValue;
    }

    public String formatBySpan(int value, int[] unitSpans, String[] units) {
        if (unitSpans != null && units != null) {
            int[] values = NumberUtils.calculateUnitI(value, unitSpans);
            return this.format(values, units);
        }
        return this.defaultValue;
    }
}

