/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common.thread;

import dev.utils.common.thread.DevThreadPool;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DevThreadManager {
    private static final DevThreadPool sDevThreadPool = new DevThreadPool(DevThreadPool.DevThreadPoolType.CALC_CPU);
    private static final Map<String, DevThreadPool> sThreadMaps = new LinkedHashMap<String, DevThreadPool>();
    private static final Map<String, Object> sConfigMaps = new HashMap<String, Object>();

    private DevThreadManager() {
    }

    public static synchronized DevThreadPool getInstance(int threadNumber) {
        String key = "n_" + threadNumber;
        DevThreadPool devThreadPool = sThreadMaps.get(key);
        if (devThreadPool != null) {
            return devThreadPool;
        }
        devThreadPool = new DevThreadPool(threadNumber);
        sThreadMaps.put(key, devThreadPool);
        return devThreadPool;
    }

    public static synchronized DevThreadPool getInstance(String key) {
        DevThreadPool devThreadPool = sThreadMaps.get(key);
        if (devThreadPool != null) {
            return devThreadPool;
        }
        Object object = sConfigMaps.get(key);
        if (object != null) {
            try {
                devThreadPool = object instanceof DevThreadPool.DevThreadPoolType ? new DevThreadPool((DevThreadPool.DevThreadPoolType)((Object)object)) : (object instanceof Integer ? new DevThreadPool((Integer)object) : new DevThreadPool(Integer.parseInt((String)object)));
                sThreadMaps.put(key, devThreadPool);
                return devThreadPool;
            }
            catch (Exception e) {
                return sDevThreadPool;
            }
        }
        return sDevThreadPool;
    }

    public static void initConfig(Map<String, Object> mapConfigs) {
        if (mapConfigs != null) {
            sConfigMaps.putAll(mapConfigs);
        }
    }

    public static void putConfig(String key, Object value) {
        sConfigMaps.put(key, value);
    }

    public static void removeConfig(String key) {
        sConfigMaps.remove(key);
    }
}

