/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ForUtils {
    private static final String TAG = ForUtils.class.getSimpleName();

    private ForUtils() {
    }

    public static <T> boolean forArgs(Consumer<T> action, T ... args) {
        return ForUtils.forArgs(action, false, args);
    }

    public static <T> boolean forArgs(Consumer<T> action, boolean checkLength, T ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                T value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static <T> boolean forSimpleArgs(ConsumerSimple<T> action, T ... args) {
        return ForUtils.forSimpleArgs(action, false, args);
    }

    public static <T> boolean forSimpleArgs(ConsumerSimple<T> action, boolean checkLength, T ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (T value : args) {
                action.accept(value);
            }
            return true;
        }
        return false;
    }

    public static <T> boolean forList(Consumer<T> action, List<T> list) {
        return ForUtils.forList(action, false, list);
    }

    public static <T> boolean forList(Consumer<T> action, boolean checkLength, List<T> list) {
        if (action != null && list != null) {
            int len = list.size();
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                T value = list.get(i);
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static <T> boolean forListIterator(ConsumerIterator<T> action, List<T> list) {
        return ForUtils.forListIterator(action, false, list);
    }

    public static <T> boolean forListIterator(ConsumerIterator<T> action, boolean checkLength, List<T> list) {
        if (action != null && list != null) {
            int len = list.size();
            if (len == 0) {
                return !checkLength;
            }
            Iterator<T> iterator = list.iterator();
            while (iterator.hasNext()) {
                T value = iterator.next();
                action.accept(iterator, value);
            }
            return true;
        }
        return false;
    }

    public static <T> boolean forSet(ConsumerIterator<T> action, Set<T> sets) {
        return ForUtils.forSet(action, false, sets);
    }

    public static <T> boolean forSet(ConsumerIterator<T> action, boolean checkLength, Set<T> sets) {
        if (action != null && sets != null) {
            int len = sets.size();
            if (len == 0) {
                return !checkLength;
            }
            Iterator<T> iterator = sets.iterator();
            while (iterator.hasNext()) {
                T value = iterator.next();
                action.accept(iterator, value);
            }
            return true;
        }
        return false;
    }

    public static <K, V> boolean forMap(ConsumerMap<K, V> action, Map<K, V> maps) {
        return ForUtils.forMap(action, false, maps);
    }

    public static <K, V> boolean forMap(ConsumerMap<K, V> action, boolean checkLength, Map<K, V> maps) {
        if (action != null && maps != null) {
            int len = maps.size();
            if (len == 0) {
                return !checkLength;
            }
            Iterator<Map.Entry<K, V>> iterator = maps.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                action.accept(iterator, entry, entry.getKey(), entry.getValue());
            }
            return true;
        }
        return false;
    }

    public static boolean forInts(IntConsumer action, int ... args) {
        return ForUtils.forInts(action, false, args);
    }

    public static boolean forInts(IntConsumer action, boolean checkLength, int ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                int value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forDoubles(DoubleConsumer action, double ... args) {
        return ForUtils.forDoubles(action, false, args);
    }

    public static boolean forDoubles(DoubleConsumer action, boolean checkLength, double ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                double value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forFloats(FloatConsumer action, float ... args) {
        return ForUtils.forFloats(action, false, args);
    }

    public static boolean forFloats(FloatConsumer action, boolean checkLength, float ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                float value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forLongs(LongConsumer action, long ... args) {
        return ForUtils.forLongs(action, false, args);
    }

    public static boolean forLongs(LongConsumer action, boolean checkLength, long ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                long value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forBooleans(BooleanConsumer action, boolean ... args) {
        return ForUtils.forBooleans(action, false, args);
    }

    public static boolean forBooleans(BooleanConsumer action, boolean checkLength, boolean ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                boolean value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forBytes(ByteConsumer action, byte ... args) {
        return ForUtils.forBytes(action, false, args);
    }

    public static boolean forBytes(ByteConsumer action, boolean checkLength, byte ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                byte value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forChars(CharConsumer action, char ... args) {
        return ForUtils.forChars(action, false, args);
    }

    public static boolean forChars(CharConsumer action, boolean checkLength, char ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                char value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static boolean forShorts(ShortConsumer action, short ... args) {
        return ForUtils.forShorts(action, false, args);
    }

    public static boolean forShorts(ShortConsumer action, boolean checkLength, short ... args) {
        if (action != null && args != null) {
            int len = args.length;
            if (len == 0) {
                return !checkLength;
            }
            for (int i = 0; i < len; ++i) {
                short value = args[i];
                action.accept(i, value);
            }
            return true;
        }
        return false;
    }

    public static interface Consumer<T> {
        public void accept(int var1, T var2);
    }

    public static interface ConsumerSimple<T> {
        public void accept(T var1);
    }

    public static interface ConsumerIterator<T> {
        public void accept(Iterator<T> var1, T var2);
    }

    public static interface ConsumerMap<K, V> {
        public void accept(Iterator<Map.Entry<K, V>> var1, Map.Entry<K, V> var2, K var3, V var4);
    }

    public static interface IntConsumer {
        public void accept(int var1, int var2);
    }

    public static interface DoubleConsumer {
        public void accept(int var1, double var2);
    }

    public static interface FloatConsumer {
        public void accept(int var1, float var2);
    }

    public static interface LongConsumer {
        public void accept(int var1, long var2);
    }

    public static interface BooleanConsumer {
        public void accept(int var1, boolean var2);
    }

    public static interface ByteConsumer {
        public void accept(int var1, byte var2);
    }

    public static interface CharConsumer {
        public void accept(int var1, char var2);
    }

    public static interface ShortConsumer {
        public void accept(int var1, short var2);
    }
}

