/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public final class HttpURLConnectionUtils {
    private static final String TAG = HttpURLConnectionUtils.class.getSimpleName();
    private static final int TIMEOUT_IN_MILLIONS = 5000;
    public static final String BAIDU_URL = "https://www.baidu.com";

    private HttpURLConnectionUtils() {
    }

    public static void doGetAsync(String urlStr, Callback callback) {
        new Thread(() -> {
            try {
                HttpURLConnectionUtils.request("GET", urlStr, null, null, callback);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "doGetAsync", new Object[0]);
            }
        }).start();
    }

    public static void doPostAsync(String urlStr, String params, Callback callback) {
        new Thread(() -> {
            try {
                HttpURLConnectionUtils.request("POST", urlStr, null, params, callback);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "doPostAsync", new Object[0]);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void request(String method, String urlStr, Map<String, String> headers, String params, Callback callback) {
        ByteArrayOutputStream baos;
        InputStream is;
        HttpURLConnection connection;
        block19: {
            connection = null;
            is = null;
            baos = null;
            try {
                URL url = new URL(urlStr);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(method);
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (params != null && params.length() != 0) {
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    OutputStream os = connection.getOutputStream();
                    os.write(params.getBytes());
                    os.flush();
                    os.close();
                }
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode >= 200 && responseCode < 300) {
                    int len;
                    is = connection.getInputStream();
                    baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    String result = baos.toString();
                    if (callback != null) {
                        callback.onResponse(result, connection.getDate());
                    }
                    break block19;
                }
                if (callback == null) break block19;
                callback.onFail(new Exception("responseCode not >= 200 or < 300, code: " + responseCode));
            }
            catch (Exception e) {
                block20: {
                    try {
                        JCLogUtils.eTag(TAG, e, "request", new Object[0]);
                        if (callback == null) break block20;
                        callback.onFail(e);
                    }
                    catch (Throwable throwable) {
                        CloseUtils.closeIOQuietly(baos, is);
                        if (connection != null) {
                            try {
                                connection.disconnect();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                CloseUtils.closeIOQuietly(baos, is);
                if (connection != null) {
                    try {
                        connection.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        CloseUtils.closeIOQuietly(baos, is);
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception url) {}
        }
    }

    public static void getNetTime(TimeCallback callback) {
        HttpURLConnectionUtils.getNetTime(BAIDU_URL, callback);
    }

    public static void getNetTime(String urlStr, TimeCallback callback) {
        new Thread(() -> HttpURLConnectionUtils.reqNetTime(urlStr, callback)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reqNetTime(String urlStr, TimeCallback callback) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            long date = connection.getDate();
            if (date <= 0L) {
                date = -1L;
            }
            if (callback != null) {
                callback.onResponse(date);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getNetTime", new Object[0]);
            if (callback != null) {
                callback.onFail(e);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static interface Callback {
        public void onResponse(String var1, long var2);

        public void onFail(Throwable var1);
    }

    public static interface TimeCallback {
        public void onResponse(long var1);

        public void onFail(Throwable var1);
    }
}

