/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.JCLogUtils;
import dev.utils.common.CollectionUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.ObjectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MapUtils {
    private static final String TAG = MapUtils.class.getSimpleName();

    private MapUtils() {
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static int length(Map<?, ?> map) {
        return MapUtils.length(map, 0);
    }

    public static int length(Map<?, ?> map, int defaultLength) {
        return map != null ? map.size() : defaultLength;
    }

    public static boolean isLength(Map<?, ?> map, int length) {
        return map != null && map.size() == length;
    }

    public static boolean greaterThan(Map<?, ?> map, int length) {
        return map != null && map.size() > length;
    }

    public static boolean greaterThanOrEqual(Map<?, ?> map, int length) {
        return map != null && map.size() >= length;
    }

    public static boolean lessThan(Map<?, ?> map, int length) {
        return map != null && map.size() < length;
    }

    public static boolean lessThanOrEqual(Map<?, ?> map, int length) {
        return map != null && map.size() <= length;
    }

    public static int getCount(Map<?, ?> ... maps) {
        if (maps == null) {
            return 0;
        }
        int count = 0;
        for (Map<?, ?> map : maps) {
            count += MapUtils.length(map);
        }
        return count;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map != null) {
            try {
                return map.get(key);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        if (map != null) {
            try {
                V value = map.get(key);
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, V value) {
        if (map != null) {
            try {
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    V v = entry.getValue();
                    if (!MapUtils.equals(v, value)) continue;
                    return entry.getKey();
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getKeyByValue", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> List<K> getKeysByValue(Map<K, V> map, V value) {
        if (map != null) {
            try {
                ArrayList<K> lists = new ArrayList<K>();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    V v = entry.getValue();
                    if (!MapUtils.equals(v, value)) continue;
                    lists.add(entry.getKey());
                }
                return lists;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getKeysByValue", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> List<K> getKeys(Map<K, V> map) {
        if (map != null) {
            try {
                return new ArrayList<K>(map.keySet());
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getKeys", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> K[] getKeysToArrays(Map<K, V> map) {
        if (map != null) {
            try {
                return CollectionUtils.toArrayT(MapUtils.getKeys(map));
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getKeysToArrays", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> List<V> getValues(Map<K, V> map) {
        if (map != null) {
            try {
                return new ArrayList<V>(map.values());
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getValues", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> V[] getValuesToArrays(Map<K, V> map) {
        if (map != null) {
            try {
                return CollectionUtils.toArrayT(MapUtils.getValues(map));
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getValuesToArrays", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> getFirst(LinkedHashMap<K, V> map) {
        if (map != null) {
            try {
                return map.entrySet().iterator().next();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getFirst", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> getLast(LinkedHashMap<K, V> map) {
        return MapUtils.getLast(map, true);
    }

    public static <K, V> Map.Entry<K, V> getLast(LinkedHashMap<K, V> map, boolean isReflection) {
        if (map != null) {
            if (isReflection) {
                try {
                    Field tail = map.getClass().getDeclaredField("tail");
                    tail.setAccessible(true);
                    return (Map.Entry)tail.get(map);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "getLast", new Object[0]);
                }
            } else {
                try {
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    Map.Entry<K, V> tail = null;
                    while (iterator.hasNext()) {
                        tail = iterator.next();
                    }
                    return tail;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "getLast", new Object[0]);
                }
            }
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> getNext(LinkedHashMap<K, V> map, K key) {
        if (map != null) {
            try {
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    K k = entry.getKey();
                    if (!MapUtils.equals(k, key)) continue;
                    return entry;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getNext", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> getPrevious(LinkedHashMap<K, V> map, K key) {
        if (map != null) {
            try {
                Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                Map.Entry<K, V> temp = null;
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry = iterator.next();
                    K k = entry.getKey();
                    if (MapUtils.equals(k, key)) {
                        return temp;
                    }
                    temp = entry;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getPrevious", new Object[0]);
            }
        }
        return null;
    }

    public static <K, V> boolean put(Map<K, V> map, K key, V value) {
        return MapUtils.put(map, key, value, false);
    }

    public static <K, V> boolean put(Map<K, V> map, K key, V value, boolean notNull) {
        if (map != null) {
            if (notNull && key == null) {
                return false;
            }
            try {
                map.put(key, value);
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "put", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean putNotNull(Map<K, V> map, K key, V value) {
        return MapUtils.put(map, key, value, true);
    }

    public static <K, V> boolean put(Map<K, V> map, Map.Entry<K, V> entry) {
        return MapUtils.put(map, entry, false);
    }

    public static <K, V> boolean put(Map<K, V> map, Map.Entry<K, V> entry, boolean notNull) {
        if (map != null && entry != null) {
            if (notNull && entry.getKey() == null) {
                return false;
            }
            try {
                map.put(entry.getKey(), entry.getValue());
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "put", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean putNotNull(Map<K, V> map, Map.Entry<K, V> entry) {
        return MapUtils.put(map, entry, true);
    }

    public static <K, V> boolean putAll(Map<K, V> map, List<K> listKeys, List<V> listValues) {
        return MapUtils.putAll(map, listKeys, listValues, false);
    }

    public static <K, V> boolean putAll(Map<K, V> map, List<K> listKeys, List<V> listValues, boolean notNull) {
        if (map != null && listKeys != null && listValues != null && listKeys.size() == listValues.size()) {
            try {
                int len = listKeys.size();
                for (int i = 0; i < len; ++i) {
                    K key = listKeys.get(i);
                    if (notNull && key == null) continue;
                    map.put(key, listValues.get(i));
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "putAll", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean putAllNotNull(Map<K, V> map, List<K> listKeys, List<V> listValues) {
        return MapUtils.putAll(map, listKeys, listValues, true);
    }

    public static <K, V> boolean putAll(Map<K, V> map, K[] keys, V[] values) {
        return MapUtils.putAll(map, keys, values, false);
    }

    public static <K, V> boolean putAll(Map<K, V> map, K[] keys, V[] values, boolean notNull) {
        if (map != null && keys != null && values != null && keys.length == values.length) {
            try {
                int len = keys.length;
                for (int i = 0; i < len; ++i) {
                    K key = keys[i];
                    if (notNull && key == null) continue;
                    map.put(key, values[i]);
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "putAll", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean putAllNotNull(Map<K, V> map, K[] keys, V[] values) {
        return MapUtils.putAll(map, keys, values, true);
    }

    public static <K, V> boolean putAll(Map<K, V> map, Map<K, V> mapData) {
        return MapUtils.putAll(map, mapData, false);
    }

    public static <K, V> boolean putAll(Map<K, V> map, Map<K, V> mapData, boolean notNull) {
        if (map != null && mapData != null) {
            if (notNull) {
                try {
                    for (Map.Entry<K, V> entry : mapData.entrySet()) {
                        K key = entry.getKey();
                        if (key == null) continue;
                        map.put(key, entry.getValue());
                    }
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "putAll", new Object[0]);
                }
            } else {
                try {
                    map.putAll(mapData);
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "putAll", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <K, V> boolean putAllNotNull(Map<K, V> map, Map<K, V> mapData) {
        return MapUtils.putAll(map, mapData, true);
    }

    public static <K, V> boolean remove(Map<K, V> map, K key) {
        if (map != null) {
            try {
                map.remove(key);
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "remove", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean remove(Map<K, V> map, K key, V value) {
        if (map != null) {
            try {
                if (MapUtils.equals(value, map.get(key))) {
                    map.remove(key);
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "remove", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean removeToKeys(Map<K, V> map, Collection<K> keys) {
        if (map != null && keys != null) {
            try {
                for (K key : keys) {
                    map.remove(key);
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToKeys", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean removeToValue(Map<K, V> map, V value) {
        if (map != null) {
            try {
                Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry = iterator.next();
                    V v = entry.getValue();
                    if (!MapUtils.equals(v, value)) continue;
                    iterator.remove();
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToValue", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean removeToValues(Map<K, V> map, Collection<V> values) {
        if (map != null && values != null) {
            try {
                for (V value : values) {
                    MapUtils.removeToValue(map, value);
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToValues", new Object[0]);
            }
        }
        return false;
    }

    public static <T> boolean equals(T value1, T value2) {
        return ObjectUtils.equals(value1, value2);
    }

    public static <K, V> boolean toggle(Map<K, V> map, K key, V value) {
        if (map != null) {
            boolean existKey = map.containsKey(key);
            try {
                if (existKey) {
                    map.remove(key);
                } else {
                    map.put(key, value);
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "toggle", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean isNullToValue(Map<K, V> map, K key) {
        if (map != null) {
            return map.get(key) == null;
        }
        return true;
    }

    public static <K, V> boolean containsKey(Map<K, V> map, K key) {
        if (map != null) {
            try {
                return map.containsKey(key);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "containsKey", new Object[0]);
            }
        }
        return false;
    }

    public static <K, V> boolean containsValue(Map<K, V> map, V value) {
        if (map != null) {
            try {
                return map.containsValue(value);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "containsValue", new Object[0]);
            }
        }
        return false;
    }

    public static <K, T> boolean putToList(Map<K, List<T>> map, K key, T value) {
        return MapUtils.putToList(map, key, value, true);
    }

    public static <K, T> boolean putToList(Map<K, List<T>> map, K key, T value, boolean isNew) {
        if (map != null) {
            if (map.containsKey(key)) {
                List<T> lists = map.get(key);
                if (lists != null) {
                    try {
                        lists.add(value);
                        map.put(key, lists);
                        return true;
                    }
                    catch (Exception e) {
                        JCLogUtils.eTag(TAG, e, "putToList", new Object[0]);
                    }
                }
            } else if (isNew) {
                try {
                    ArrayList<T> lists = new ArrayList<T>();
                    lists.add(value);
                    map.put(key, lists);
                    return true;
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "putToList", new Object[0]);
                }
            }
        }
        return false;
    }

    public static <K, T> boolean removeToList(Map<K, List<T>> map, K key) {
        if (map != null) {
            try {
                map.remove(key);
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToList", new Object[0]);
            }
        }
        return false;
    }

    public static <K, T> boolean removeToList(Map<K, List<T>> map, K key, T value) {
        List<T> lists;
        if (map != null && map.containsKey(key) && (lists = map.get(key)) != null) {
            try {
                lists.remove(value);
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToList", new Object[0]);
            }
        }
        return false;
    }

    public static <K, T> boolean removeToLists(Map<K, List<T>> map, K key, List<T> lists) {
        List<T> list;
        if (map != null && lists != null && map.containsKey(key) && (list = map.get(key)) != null) {
            try {
                list.removeAll(lists);
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "removeToLists", new Object[0]);
            }
        }
        return false;
    }

    public static <K, T> boolean removeToMap(Map<K, List<T>> map, Map<K, List<T>> removeMap) {
        return MapUtils.removeToMap(map, removeMap, true, false);
    }

    public static <K, T> boolean removeToMap(Map<K, List<T>> map, Map<K, List<T>> removeMap, boolean removeEmpty, boolean isNullRemoveAll) {
        if (map != null && removeMap != null) {
            for (Map.Entry<K, List<T>> entry : removeMap.entrySet()) {
                K key = entry.getKey();
                if (!map.containsKey(key)) continue;
                List<T> value = entry.getValue();
                try {
                    if (value != null) {
                        map.get(key).removeAll(value);
                    } else if (isNullRemoveAll) {
                        map.remove(key);
                    }
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "removeToMap - removeAll", new Object[0]);
                }
                if (!removeEmpty) continue;
                List<T> lists = map.get(key);
                try {
                    if (lists != null && lists.size() != 0) continue;
                    map.remove(key);
                }
                catch (Exception e) {
                    JCLogUtils.eTag(TAG, e, "removeToMap", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static <K, V> StringBuilder mapToString(Map<K, V> map, String symbol) {
        return MapUtils.mapToString(map, symbol, new StringBuilder());
    }

    public static <K, V> StringBuilder mapToString(Map<K, V> map, String symbol, StringBuilder builder) {
        if (map != null && builder != null) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                builder.append(ConvertUtils.toString(entry.getKey()));
                builder.append(symbol);
                builder.append(ConvertUtils.toString(entry.getValue()));
                if (!iterator.hasNext()) continue;
                builder.append(DevFinal.SYMBOL.NEW_LINE);
            }
        }
        return builder;
    }
}

