/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.NumberUtils;
import dev.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtils {
    private static final String TAG = StreamUtils.class.getSimpleName();
    public static final int EOF = -1;

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream inputToOutputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (inputStream == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byteArrayOutputStream = baos;
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                JCLogUtils.eTag(TAG, e, "inputToOutputStream", new Object[0]);
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(inputStream);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(inputStream);
            return byteArrayOutputStream2;
        }
        CloseUtils.closeIOQuietly(inputStream);
        return byteArrayOutputStream;
    }

    public static ByteArrayInputStream outputToInputStream(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputToInputStream", new Object[0]);
            return null;
        }
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            return StreamUtils.inputToOutputStream(inputStream).toByteArray();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "inputStreamToBytes", new Object[0]);
            return null;
        }
    }

    public static InputStream bytesToInputStream(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "bytesToInputStream", new Object[0]);
            return null;
        }
    }

    public static byte[] outputStreamToBytes(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        try {
            return ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputStreamToBytes", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytesToOutputStream(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            baos.write(bytes);
            byteArrayOutputStream = baos;
        }
        catch (Exception e) {
            OutputStream outputStream;
            try {
                JCLogUtils.eTag(TAG, e, "bytesToOutputStream", new Object[0]);
                outputStream = null;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(baos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(baos);
            return outputStream;
        }
        CloseUtils.closeIOQuietly(baos);
        return byteArrayOutputStream;
    }

    public static String inputStreamToString(InputStream inputStream, String charsetName) {
        if (inputStream == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new String(StreamUtils.inputStreamToBytes(inputStream), charsetName);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "inputStreamToString", new Object[0]);
            return null;
        }
    }

    public static InputStream stringToInputStream(String str, String charsetName) {
        if (str == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(str.getBytes(charsetName));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "stringToInputStream", new Object[0]);
            return null;
        }
    }

    public static String outputStreamToString(OutputStream outputStream, String charsetName) {
        if (outputStream == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return new String(StreamUtils.outputStreamToBytes(outputStream), charsetName);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "outputStreamToString", new Object[0]);
            return null;
        }
    }

    public static OutputStream stringToOutputStream(String str, String charsetName) {
        if (str == null || StringUtils.isEmpty((CharSequence)charsetName)) {
            return null;
        }
        try {
            return StreamUtils.bytesToOutputStream(str.getBytes(charsetName));
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "stringToOutputStream", new Object[0]);
            return null;
        }
    }

    public static boolean inputWriteOutputStream(InputStream inputStream, OutputStream outputStream) {
        return StreamUtils.inputWriteOutputStream(inputStream, outputStream, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inputWriteOutputStream(InputStream inputStream, OutputStream outputStream, int bufferSize) {
        boolean bl;
        try {
            int len;
            byte[] data = new byte[bufferSize];
            while ((len = inputStream.read(data)) != -1) {
                outputStream.write(data, 0, len);
            }
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "inputWriteOutputStream", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(inputStream, outputStream);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(inputStream, outputStream);
            return bl2;
        }
        CloseUtils.closeIOQuietly(inputStream, outputStream);
        return bl;
    }

    public static boolean inputWriteOutputStreamCallback(InputStream inputStream, OutputStream outputStream, long totalSize, WriteCallback callback) {
        return StreamUtils.inputWriteOutputStreamCallback(inputStream, outputStream, 8192, totalSize, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inputWriteOutputStreamCallback(InputStream inputStream, OutputStream outputStream, int bufferSize, long totalSize, WriteCallback callback) {
        if (callback != null && totalSize > 0L) {
            boolean bl;
            callback.onStart();
            try {
                int len;
                byte[] data = new byte[bufferSize];
                int currentSize = 0;
                while ((len = inputStream.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                    double percentD = NumberUtils.percentD(currentSize += len, totalSize) * 100.0;
                    callback.onProgress(currentSize, totalSize, (int)percentD);
                }
                callback.onFinish();
                callback.onEnd();
                bl = true;
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    JCLogUtils.eTag(TAG, e, "inputWriteOutputStreamCallback", new Object[0]);
                    callback.onError(e);
                    callback.onEnd();
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(inputStream, outputStream);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(inputStream, outputStream);
                return bl2;
            }
            CloseUtils.closeIOQuietly(inputStream, outputStream);
            return bl;
        }
        return false;
    }

    public static interface WriteCallback {
        public void onStart();

        public void onProgress(long var1, long var3, int var5);

        public void onError(Throwable var1);

        public void onFinish();

        public void onEnd();
    }
}

