/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import nts.AuthenticationFailureException;
import nts.NTSUDPClient;
import nts.NtpUtils;
import nts.NtpV3Packet;
import nts.TimeInfo;
import nts.TimeStamp;

public class NTSTime {
    public static void main(String[] args) {
        ArrayList<String> TIME_SERVERS = new ArrayList<String>(List.of("paris.time.system76.com", "time.cloudflare.com"));
        NTSUDPClient client = new NTSUDPClient();
        for (String host : TIME_SERVERS) {
            try {
                InetAddress hostAddr = InetAddress.getByName(host);
                TimeInfo info = client.getTime(hostAddr);
                System.out.println(" Server: " + host);
                NTSTime.processResponse(info);
            }
            catch (UnknownHostException e) {
                System.err.println("Unknown host: " + e.getMessage());
            }
            catch (AuthenticationFailureException e) {
                System.err.println("Authentication failure: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        client.close();
    }

    public static void processResponse(TimeInfo info) {
        DecimalFormat numberFormat = new DecimalFormat("0.00");
        NtpV3Packet message = info.getMessage();
        int stratum = message.getStratum();
        String refType = stratum <= 0 ? "(Unspecified or Unavailable)" : (stratum == 1 ? "(Primary Reference; e.g., GPS)" : "(Secondary Reference; e.g. via NTP or SNTP)");
        System.out.println(" Stratum: " + stratum + " " + refType);
        int version = message.getVersion();
        int li = message.getLeapIndicator();
        System.out.println(" leap=" + li + ", version=" + version + ", precision=" + message.getPrecision());
        System.out.println(" mode: " + message.getModeName() + " (" + message.getMode() + ")");
        int poll = message.getPoll();
        System.out.println(" poll: " + (poll <= 0 ? 1 : (int)Math.pow(2.0, poll)) + " seconds (2 ** " + poll + ")");
        double disp = message.getRootDispersionInMillisDouble();
        System.out.println(" rootdelay=" + numberFormat.format(message.getRootDelayInMillisDouble()) + ", rootdispersion(ms): " + numberFormat.format(disp));
        int refId = message.getReferenceId();
        Object refAddr = NtpUtils.getHostAddress(refId);
        String refName = null;
        if (refId != 0) {
            if (((String)refAddr).equals("127.127.1.0")) {
                refName = "LOCAL";
            } else if (stratum >= 2) {
                if (!((String)refAddr).startsWith("127.127")) {
                    try {
                        InetAddress addr = InetAddress.getByName((String)refAddr);
                        String name = addr.getHostName();
                        if (name != null && !name.equals(refAddr)) {
                            refName = name;
                        }
                    }
                    catch (UnknownHostException e) {
                        refName = NtpUtils.getReferenceClock(message);
                    }
                }
            } else if (version >= 3 && (stratum == 0 || stratum == 1)) {
                refName = NtpUtils.getReferenceClock(message);
            }
        }
        if (refName != null && refName.length() > 1) {
            refAddr = (String)refAddr + " (" + refName + ")";
        }
        System.out.println(" Reference Identifier:\t" + (String)refAddr);
        TimeStamp refNtpTime = message.getReferenceTimeStamp();
        System.out.println(" Reference Timestamp:\t" + String.valueOf(refNtpTime) + "  " + refNtpTime.toDateString());
        TimeStamp origNtpTime = message.getOriginateTimeStamp();
        System.out.println(" Originate Timestamp:\t" + String.valueOf(origNtpTime) + "  " + origNtpTime.toDateString());
        long destTimeMillis = info.getReturnTime();
        TimeStamp rcvNtpTime = message.getReceiveTimeStamp();
        System.out.println(" Receive Timestamp:\t" + String.valueOf(rcvNtpTime) + "  " + rcvNtpTime.toDateString());
        TimeStamp xmitNtpTime = message.getTransmitTimeStamp();
        System.out.println(" Transmit Timestamp:\t" + String.valueOf(xmitNtpTime) + "  " + xmitNtpTime.toDateString());
        TimeStamp destNtpTime = TimeStamp.getNtpTime(destTimeMillis);
        System.out.println(" Destination Timestamp:\t" + String.valueOf(destNtpTime) + "  " + destNtpTime.toDateString());
        info.computeDetails();
        Long offsetMillis = info.getOffset();
        Long delayMillis = info.getDelay();
        String delay = delayMillis == null ? "N/A" : delayMillis.toString();
        String offset = offsetMillis == null ? "N/A" : offsetMillis.toString();
        System.out.println(" Roundtrip delay(ms)=" + delay + ", clock offset(ms)=" + offset);
    }
}

