/*
 * Decompiled with CFR 0.152.
 */
package nts;

import java.io.IOException;
import java.security.Security;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import nts.NTSConfig;
import nts.NTSKEMessage;
import nts.NTSKERecords.Constants;
import nts.NTSKERecords.NTSKERecordFactory;
import org.conscrypt.Conscrypt;

public class NTSKEHandshake {
    public static String LABEL = "EXPORTER-network-time-security";
    public static byte[] PROTO_ID_NTPV4 = new byte[]{0, 0};
    public static byte[] AEAD_AES_SIV_CMAC_256 = new byte[]{0, 15};
    public static byte C2S_CONTEXT = 0;
    public static byte S2C_CONTEXT = 1;
    private SSLSocketFactory factory;

    public NTSKEHandshake() {
        try {
            Security.insertProviderAt(Conscrypt.newProvider(), 1);
            X509TrustManager tm = Conscrypt.getDefaultX509TrustManager();
            SSLContext context = SSLContext.getInstance("TLSv1.3", "Conscrypt");
            context.init(null, new TrustManager[]{tm}, null);
            this.factory = context.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printSession(SSLSession session) {
        try {
            System.out.println("Protocol: " + session.getProtocol());
            System.out.println("Cipher Suite: " + session.getCipherSuite());
            System.out.println("Peer Host: " + session.getPeerHost());
            System.out.println("Peer Port: " + session.getPeerPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] getKeyExpansionContext(byte CS2orS2C) {
        byte[] key_extraction_context = new byte[5];
        System.arraycopy(PROTO_ID_NTPV4, 0, key_extraction_context, 0, 2);
        System.arraycopy(AEAD_AES_SIV_CMAC_256, 0, key_extraction_context, 2, 2);
        key_extraction_context[4] = CS2orS2C;
        return key_extraction_context;
    }

    public NTSConfig doHandshake(String host, int port) {
        try {
            SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
            SSLParameters params = socket.getSSLParameters();
            params.setProtocols(new String[]{"TLSv1.3"});
            socket.setSSLParameters(params);
            socket.setSoTimeout(300);
            Conscrypt.setApplicationProtocols((SSLSocket)socket, (String[])new String[]{"ntske/1"});
            socket.startHandshake();
            NTSKEMessage NtsKeClientMessage = new NTSKEMessage();
            NtsKeClientMessage.addNTSKERecord(NTSKERecordFactory.getNTSNextProtocolNegotiationRecord(Constants.NTSNextProtocols.NTPv4));
            NtsKeClientMessage.addNTSKERecord(NTSKERecordFactory.getAEADAlgorithmNegotiationRecord(Constants.AEADAlgorithms.AEAD_AES_SIV_CMAC_256));
            NtsKeClientMessage.addNTSKERecord(NTSKERecordFactory.getEndOfMessageRecord());
            socket.getOutputStream().write(NtsKeClientMessage.toBytes());
            socket.getOutputStream().flush();
            byte[] response = new byte[1024];
            int bytesRead = socket.getInputStream().read(response);
            if (bytesRead < 0) {
                throw new IOException("Unable to read NTS KE Response from server");
            }
            NTSKEMessage NTSKEResponseMessage = NTSKEMessage.parseNTSKERawMessage(response, bytesRead);
            byte[] context_c2s = NTSKEHandshake.getKeyExpansionContext(C2S_CONTEXT);
            byte[] context_s2c = NTSKEHandshake.getKeyExpansionContext(S2C_CONTEXT);
            byte[] c2s_key = Conscrypt.exportKeyingMaterial((SSLSocket)socket, (String)LABEL, (byte[])context_c2s, (int)32);
            byte[] s2c_key = Conscrypt.exportKeyingMaterial((SSLSocket)socket, (String)LABEL, (byte[])context_s2c, (int)32);
            socket.close();
            NTSConfig ntsConfig = NTSKEResponseMessage.parseResponse(host, port);
            ntsConfig.C2SKey = c2s_key;
            ntsConfig.S2CKey = s2c_key;
            return ntsConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String host = "ntppool1.time.nl";
        int port = 4460;
        NTSKEHandshake tlsHandshake = new NTSKEHandshake();
        NTSConfig ntsConfig = tlsHandshake.doHandshake(host, port);
        System.out.println("Result: " + String.valueOf(ntsConfig));
    }
}

