/*
 * Decompiled with CFR 0.152.
 */
package nts.NTSKERecords;

import nts.NTSKERecords.Constants;
import nts.NTSKERecords.NTSKERecord;
import nts.NTSKERecords.NTSKERecordType;

public class Error
extends NTSKERecord {
    public Constants.ErrorCodes errorCode;

    public Error(Constants.ErrorCodes errorCode) {
        super(1, NTSKERecordType.Error.getValue(), 2, errorCode.getBytesValue());
        this.errorCode = errorCode;
    }

    public Error(byte[] rawRecord) {
        super(rawRecord);
        if (this.criticalBit != 1) {
            throw new IllegalArgumentException("Critical bit must be set to 1 for Error record.");
        }
        if (this.recordType != NTSKERecordType.Error) {
            throw new IllegalArgumentException("Record type must be Error.");
        }
        if (this.bodyLength != 2 || this.recordBody == null) {
            throw new IllegalArgumentException("Body length must be 2 for Error record.");
        }
        this.errorCode = Constants.ErrorCodes.fromBytes(this.recordBody);
    }
}

