/*
 * Decompiled with CFR 0.152.
 */
package nts;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import nts.AuthenticationFailureException;
import nts.NTSConfig;
import nts.NTSExtensionFields.FieldType;
import nts.NTSExtensionFields.NTSExtensionField;
import nts.NTSPeer;
import nts.NtpV3Packet;
import nts.NtsImpl;
import nts.NtsNakException;
import nts.TimeInfo;
import nts.TimeStamp;
import org.apache.commons.net.DatagramSocketClient;

public final class NTSUDPClient
extends DatagramSocketClient {
    public static final int DEFAULT_PORT = 123;
    private int version = 4;
    private List<NTSPeer> peers = new ArrayList<NTSPeer>();

    private NTSPeer getNtsPeer(InetAddress host) {
        for (NTSPeer peer : this.peers) {
            if (!peer.KEHost.equals(host.getHostAddress())) continue;
            return peer;
        }
        NTSPeer peer = new NTSPeer(host.getHostAddress());
        this.peers.add(peer);
        return peer;
    }

    private void removeNtsPeer(InetAddress host) {
        NTSPeer peer = this.getNtsPeer(host);
        if (peer != null) {
            this.peers.remove(peer);
        }
    }

    public TimeInfo getTime(InetAddress host) throws IOException, AuthenticationFailureException, NtsNakException {
        return this.getTime(host, 123);
    }

    public TimeInfo getTime(InetAddress host, int port) throws IOException, AuthenticationFailureException, NtsNakException {
        NTSPeer peer = this.getNtsPeer(host);
        if (peer.nakReceived) {
            peer.doHandshake();
        }
        NTSConfig ntsConfig = peer.ntsConfig;
        if (!this.isOpen()) {
            this.open();
        }
        NtsImpl message = new NtsImpl(ntsConfig.C2SKey);
        byte[] cookie = ntsConfig.cookies.get(0);
        ntsConfig.cookies.remove(0);
        int ncookies_needed = 8 - ntsConfig.cookies.size();
        message.buildRequest(cookie, ncookies_needed);
        DatagramPacket sendPacket = message.getDatagramPacket();
        sendPacket.setAddress(host);
        sendPacket.setPort(port);
        NtsImpl recMessage = new NtsImpl(ntsConfig.S2CKey);
        DatagramPacket receivePacket = recMessage.getDatagramPacket(sendPacket.getLength());
        TimeStamp now = TimeStamp.getCurrentTime();
        message.setTransmitTime(now);
        message.createAuthAndEncEF();
        this.checkOpen().send(sendPacket);
        this.checkOpen().receive(receivePacket);
        long returnTimeMillis = System.currentTimeMillis();
        try {
            recMessage.validate(message);
            peer.nakReceived = false;
            List<NTSExtensionField> new_cookies = recMessage.getExtensionFields(FieldType.NTS_COOKIE.getValue());
            for (NTSExtensionField new_cookie : new_cookies) {
                ntsConfig.cookies.add(new_cookie.body);
            }
        }
        catch (NtsNakException e) {
            peer.nakReceived = true;
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return new TimeInfo((NtpV3Packet)recMessage, returnTimeMillis, false);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

