/*
 * Decompiled with CFR 0.152.
 */
package nts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nts.NTSExtensionFields.NTSExtensionField;
import nts.NtpV3Impl;
import nts.NtpV4Packet;

public class NtpV4Impl
extends NtpV3Impl
implements NtpV4Packet {
    private static final int EF_INDEX = 48;
    public List<NTSExtensionField> extensionFields = new ArrayList<NTSExtensionField>();

    public NtpV4Impl() {
        this.setVersion(4);
    }

    @Override
    public void addExtensionField(NTSExtensionField field) {
        int idx = this.buf.length;
        int len = field.getFieldLength();
        byte[] new_buf = new byte[idx + len];
        this.extensionFields.add(field);
        byte[] bb = field.toByteArray();
        System.arraycopy(this.buf, 0, new_buf, 0, idx);
        System.arraycopy(bb, 0, new_buf, idx, field.getFieldLength());
        this.buf = new_buf;
    }

    @Override
    public void addExtensionFields(List<NTSExtensionField> fields) {
        int extLen = 0;
        for (NTSExtensionField ef : this.extensionFields) {
            extLen += ef.getFieldLength();
        }
        if (extLen == 0) {
            return;
        }
        byte[] new_buf = new byte[this.buf.length + extLen];
        System.arraycopy(this.buf, 0, new_buf, 0, this.buf.length);
        int offset = this.buf.length;
        for (NTSExtensionField ef : this.extensionFields) {
            byte[] fieldBytes = ef.toByteArray();
            System.arraycopy(fieldBytes, 0, new_buf, offset, fieldBytes.length);
            offset += fieldBytes.length;
        }
        this.buf = new_buf;
    }

    private void extractExtensionFields() {
        NTSExtensionField ef;
        for (int idx = 48; idx < this.buf.length; idx += ef.getFieldLength()) {
            ef = NTSExtensionField.fromBytes(this.buf, idx);
            this.extensionFields.add(ef);
        }
    }

    @Override
    public List<NTSExtensionField> getExtensionFields() {
        if (this.extensionFields.size() == 0 && this.buf.length > 48) {
            this.extractExtensionFields();
        }
        return this.extensionFields;
    }

    @Override
    public List<NTSExtensionField> getExtensionFields(int type) {
        ArrayList<NTSExtensionField> res = new ArrayList<NTSExtensionField>();
        for (NTSExtensionField ef : this.getExtensionFields()) {
            if (ef.fieldType.getValue() != type) continue;
            res.add(ef);
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NtpV4Impl other = (NtpV4Impl)obj;
        return Arrays.equals(this.buf, other.buf);
    }

    @Override
    public String toString() {
        String res = "[version:" + this.getVersion() + ", mode:" + this.getMode() + ", poll:" + this.getPoll() + ", precision:" + this.getPrecision() + ", delay:" + this.getRootDelay() + ", dispersion(ms):" + this.getRootDispersionInMillisDouble() + ", id:" + this.getReferenceIdString() + ", xmitTime:" + this.getTransmitTimeStamp().toDateString();
        for (NTSExtensionField fld : this.extensionFields) {
            res = res + ", " + String.valueOf(fld);
        }
        return res + " ]";
    }
}

