/*
 * Decompiled with CFR 0.152.
 */
package nts;

import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.SecretKeyAccess;
import com.google.crypto.tink.daead.AesSivKey;
import com.google.crypto.tink.daead.AesSivParameters;
import com.google.crypto.tink.daead.subtle.DeterministicAeads;
import com.google.crypto.tink.subtle.AesSiv;
import com.google.crypto.tink.util.SecretBytes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import nts.AuthenticationFailureException;
import nts.NTSExtensionFields.FieldType;
import nts.NTSExtensionFields.NTSExtensionField;
import nts.NtpV4Impl;
import nts.NtsNakException;
import nts.NtsPacket;

public class NtsImpl
extends NtpV4Impl
implements NtsPacket {
    public int associatedDataLenght;
    public byte[] plaintext;
    public NTSExtensionField authAndEncEF;
    private DeterministicAeads AesSivDaead;

    public NtsImpl(byte[] key) {
        try {
            AesSivParameters AES_SIV_PARAMETERS = AesSivParameters.builder().setKeySizeBytes(32).setVariant(AesSivParameters.Variant.NO_PREFIX).build();
            SecretBytes keyBytes = SecretBytes.copyFrom((byte[])key, (SecretKeyAccess)InsecureSecretKeyAccess.get());
            AesSivKey aesSivkey = AesSivKey.builder().setParameters(AES_SIV_PARAMETERS).setKeyBytes(keyBytes).build();
            this.AesSivDaead = AesSiv.create((AesSivKey)aesSivkey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create AES SIV KEY: " + e.getMessage());
        }
    }

    @Override
    public void buildRequest(byte[] cookie, int num_cookies) {
        super.buildRequest();
        byte[] unique_identifier = new byte[32];
        new SecureRandom().nextBytes(unique_identifier);
        this.addUniqueIdentifierEF(unique_identifier);
        this.addCookieEF(cookie);
        for (int idx = 0; idx < num_cookies - 1; ++idx) {
            this.addCookiePlaceholderEF(cookie);
        }
        this.prepareAuthAndEncEF();
    }

    @Override
    public void addUniqueIdentifierEF(byte[] unique_identifier_body) {
        if (unique_identifier_body == null || unique_identifier_body.length < 32) {
            throw new IllegalArgumentException("unique_identifier_ef must be at least 32 bytes long");
        }
        this.addExtensionField(new NTSExtensionField(FieldType.UNIQUE_IDENTIFIER, unique_identifier_body));
    }

    @Override
    public void addCookieEF(byte[] cookie_body) {
        this.addExtensionField(new NTSExtensionField(FieldType.NTS_COOKIE, cookie_body));
    }

    @Override
    public void addCookiePlaceholderEF(byte[] existing_cookie) {
        this.addExtensionField(new NTSExtensionField(FieldType.NTS_COOKIE_PLACEHOLDER, new byte[existing_cookie.length]));
    }

    private byte[] prepareAuthAndEncBody() {
        int nonceLength = 16;
        int ciphertextLength = 16;
        byte[] auth_and_enc_body = new byte[4 + nonceLength + ciphertextLength];
        auth_and_enc_body[0] = (byte)(nonceLength >> 8 & 0xFF);
        auth_and_enc_body[1] = (byte)(nonceLength & 0xFF);
        auth_and_enc_body[2] = (byte)(ciphertextLength >> 8 & 0xFF);
        auth_and_enc_body[3] = (byte)(ciphertextLength & 0xFF);
        return auth_and_enc_body;
    }

    @Override
    public void prepareAuthAndEncEF() {
        this.associatedDataLenght = this.buf.length;
        this.plaintext = "".getBytes();
        byte[] authAndEncBody = this.prepareAuthAndEncBody();
        this.authAndEncEF = new NTSExtensionField(FieldType.NTS_AUTH_AND_ENC, authAndEncBody);
        this.addExtensionField(this.authAndEncEF);
    }

    @Override
    public void createAuthAndEncEF(byte[] nonce) {
        try {
            byte[] ciphertext = this.AesSivDaead.encryptDeterministicallyWithAssociatedDatas(this.plaintext, (byte[][])new byte[][]{Arrays.copyOfRange(this.buf, 0, this.associatedDataLenght), nonce});
            this.authAndEncEF.replaceBody(nonce, 4);
            this.authAndEncEF.replaceBody(ciphertext, 4 + nonce.length);
            System.arraycopy(this.authAndEncEF.toByteArray(), 0, this.buf, this.associatedDataLenght, this.authAndEncEF.getFieldLength());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt NTS packet: " + e.getMessage());
        }
    }

    @Override
    public void createAuthAndEncEF() {
        byte[] nonce = new byte[16];
        new SecureRandom().nextBytes(nonce);
        this.createAuthAndEncEF(nonce);
    }

    private int getShort(byte[] buf, int index) {
        return NtsImpl.ui(buf[index]) << 8 | NtsImpl.ui(buf[index + 1]);
    }

    private void extractExtensionFieldsFrom(byte[] src, int idx) {
        while (idx < src.length) {
            NTSExtensionField ef = NTSExtensionField.fromBytes(src, idx);
            if (ef.fieldType == FieldType.NTS_AUTH_AND_ENC) {
                this.associatedDataLenght = idx;
                this.authAndEncEF = ef;
            }
            idx += ef.getFieldLength();
            this.extensionFields.add(ef);
        }
    }

    private void extractExtensionFields() {
        int idx = 48;
        this.associatedDataLenght = -1;
        this.authAndEncEF = null;
        this.extractExtensionFieldsFrom(this.buf, idx);
    }

    @Override
    public byte[] decryptAndVerify() throws AuthenticationFailureException {
        byte[] pt;
        if (this.associatedDataLenght == -1 || this.authAndEncEF == null) {
            this.extractExtensionFields();
            if (this.associatedDataLenght == -1 || this.authAndEncEF == null) {
                throw new RuntimeException("No authentication information found");
            }
        }
        int nonce_len = this.getShort(this.authAndEncEF.body, 0);
        int ct_len = this.getShort(this.authAndEncEF.body, 2);
        byte[] nonce = Arrays.copyOfRange(this.authAndEncEF.body, 4, 4 + nonce_len);
        byte[] ct = Arrays.copyOfRange(this.authAndEncEF.body, 4 + nonce_len, 4 + nonce_len + ct_len);
        byte[] ad = Arrays.copyOfRange(this.buf, 0, this.associatedDataLenght);
        try {
            pt = this.AesSivDaead.decryptDeterministicallyWithAssociatedDatas(ct, (byte[][])new byte[][]{ad, nonce});
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationFailureException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.extractExtensionFieldsFrom(pt, 0);
        return pt;
    }

    @Override
    public void validate(NtsPacket req) throws IOException, NtsNakException, AuthenticationFailureException {
        if (this.getStratum() == 0 && this.getReferenceIdString() == "NTSN") {
            throw new NtsNakException();
        }
        super.validate(req);
        this.decryptAndVerify();
    }
}

