/*
 * Decompiled with CFR 0.152.
 */
package nts;

import java.util.ArrayList;
import java.util.List;
import nts.NTSKERecords.Constants;

public class NTSConfig {
    public Constants.NTSNextProtocols NTSProtocol;
    public Constants.AEADAlgorithms AEADAlgorithm;
    public List<byte[]> cookies = new ArrayList<byte[]>();
    public String host;
    public int port;
    public byte[] C2SKey;
    public byte[] S2CKey;

    public NTSConfig(Constants.NTSNextProtocols NTSProtocol, Constants.AEADAlgorithms AEADAlgorithm, List<byte[]> cookies, String host, int port, byte[] C2SKey, byte[] S2CKey) {
        this.NTSProtocol = NTSProtocol;
        this.AEADAlgorithm = AEADAlgorithm;
        this.cookies = cookies;
        this.host = host;
        this.port = port;
        this.C2SKey = C2SKey;
        this.S2CKey = S2CKey;
    }

    public NTSConfig() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NTSConfig {").append("\n  NTSProtocol: ").append((Object)this.NTSProtocol).append("\n  AEADAlgorithm: ").append((Object)this.AEADAlgorithm).append("\n  cookies: [");
        if (this.cookies != null) {
            for (int i = 0; i < this.cookies.size(); ++i) {
                sb.append(NTSConfig.bytesToHex(this.cookies.get(i)));
                if (i >= this.cookies.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("]").append("\n  host: ").append(this.host).append("\n  port: ").append(this.port).append("\n  C2SKey: ").append(NTSConfig.bytesToHex(this.C2SKey)).append("\n  S2CKey: ").append(NTSConfig.bytesToHex(this.S2CKey)).append("\n}");
        return sb.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

