/*
 * Decompiled with CFR 0.152.
 */
package nts.NTSExtensionFields;

public enum FieldType {
    UNIQUE_IDENTIFIER(260),
    NTS_COOKIE(516),
    NTS_COOKIE_PLACEHOLDER(772),
    NTS_AUTH_AND_ENC(1028);

    private final int value;

    private FieldType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getBytesValue() {
        return new byte[]{(byte)(this.value >> 8), (byte)(this.value & 0xFF)};
    }

    public static FieldType fromValue(int value) {
        for (FieldType protocol : FieldType.values()) {
            if (protocol.value != value) continue;
            return protocol;
        }
        throw new IllegalArgumentException("Unknown NTSNextProtocol value: " + value);
    }

    public static FieldType fromBytes(byte[] bytes) {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("ErrorCode must be represented by 2 bytes.");
        }
        int value = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        return FieldType.fromValue(value);
    }
}

