/*
 * Decompiled with CFR 0.152.
 */
package nts.NTSExtensionFields;

import java.util.Arrays;
import nts.NTSExtensionFields.FieldType;

public class NTSExtensionField {
    public FieldType fieldType;
    private int fieldLength;
    public byte[] body;

    public NTSExtensionField(FieldType fieldType, byte[] body) {
        this.fieldType = fieldType;
        this.fieldLength = body.length + 4;
        this.body = body;
    }

    public static NTSExtensionField fromBytes(byte[] buf, int idx) {
        int num_bytes = buf.length;
        int remaining = num_bytes - idx;
        if (remaining < 4) {
            throw new RuntimeException();
        }
        byte[] short_buf = Arrays.copyOfRange(buf, idx, idx + 2);
        FieldType fieldType = FieldType.fromBytes(short_buf);
        short_buf = Arrays.copyOfRange(buf, idx + 2, idx + 4);
        int fieldLength = ((short_buf[0] & 0xFF) << 8) + (short_buf[1] & 0xFF);
        if (remaining < fieldLength) {
            throw new RuntimeException();
        }
        short_buf = Arrays.copyOfRange(buf, idx + 4, idx + fieldLength);
        return new NTSExtensionField(fieldType, short_buf);
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public void replaceBody(byte[] bodySegment, int offset) {
        System.arraycopy(bodySegment, 0, this.body, offset, bodySegment.length);
    }

    public byte[] toByteArray() {
        byte[] extensionField = new byte[this.fieldLength];
        System.arraycopy(this.fieldType.getBytesValue(), 0, extensionField, 0, 2);
        extensionField[2] = (byte)(this.fieldLength >> 8);
        extensionField[3] = (byte)(this.fieldLength & 0xFF);
        System.arraycopy(this.body, 0, extensionField, 4, this.body.length);
        return extensionField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NTSExtensionField { ");
        sb.append("fieldType=").append((Object)this.fieldType).append(", ");
        sb.append("fieldLength=").append(this.fieldLength).append(", ");
        sb.append("body=");
        if (this.body != null) {
            for (byte b : this.body) {
                sb.append(String.format("%02X", b));
            }
        } else {
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    public String toByteString() {
        byte[] bytes = this.toByteArray();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        sb.append('\n');
        return sb.toString();
    }
}

