/*
 * Decompiled with CFR 0.152.
 */
package nts.NTSKERecords;

import nts.NTSKERecords.NTSKERecordType;

public class NTSKERecord {
    public int criticalBit;
    public int recordType_raw;
    public NTSKERecordType recordType;
    public int bodyLength;
    public byte[] recordBody;

    public NTSKERecord(int criticalBit, int recordType, int bodyLength, byte[] recordBody) {
        this.criticalBit = criticalBit;
        this.recordType_raw = recordType;
        this.recordType = NTSKERecordType.fromValue(recordType);
        this.bodyLength = bodyLength;
        this.recordBody = recordBody;
    }

    public NTSKERecord(byte[] raw_record) {
        this.criticalBit = (raw_record[0] & 0xF0) >> 7;
        this.recordType_raw = (raw_record[0] & 0x7F) << 8 | raw_record[1] & 0xFF;
        this.recordType = NTSKERecordType.fromValue(this.recordType_raw);
        this.bodyLength = raw_record[2] << 8 | raw_record[3] & 0xFF;
        if (this.bodyLength > 0) {
            this.recordBody = new byte[this.bodyLength];
            System.arraycopy(raw_record, 4, this.recordBody, 0, this.bodyLength);
        }
    }

    public byte[] toBytes() {
        byte[] record = new byte[4 + this.bodyLength];
        record[0] = (byte)(this.criticalBit << 7 | this.recordType_raw >> 8);
        record[1] = (byte)(this.recordType_raw & 0xFF);
        record[2] = (byte)(this.bodyLength >> 8);
        record[3] = (byte)(this.bodyLength & 0xFF);
        if (this.bodyLength > 0) {
            System.arraycopy(this.recordBody, 0, record, 4, this.bodyLength);
        }
        return record;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NTSKERecord { ");
        sb.append("criticalBit=").append(this.criticalBit).append(", ");
        sb.append("recordType=").append(this.recordType_raw).append(' ').append((Object)this.recordType).append(", ");
        sb.append("bodyLength=").append(this.bodyLength).append(", ");
        sb.append("recordBody=");
        if (this.recordBody != null) {
            for (byte b : this.recordBody) {
                sb.append(String.format("%02X", b));
            }
        } else {
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    public String toByteString() {
        byte[] bytes = this.toBytes();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        sb.append('\n');
        return sb.toString();
    }
}

