/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.pretty;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowRender
implements Collector<Map.Entry<String, String>, List<String>, String> {
    private final Map<String, Integer> colNames;
    private final String delimiter;
    private final String cellSurround;
    private final boolean hasTabulation;

    public RowRender(Map<String, Integer> colNames, String delimiter, String cellSurround, boolean hasTabulation) {
        this.colNames = colNames;
        this.delimiter = delimiter;
        this.cellSurround = cellSurround;
        this.hasTabulation = hasTabulation;
    }

    @Override
    public Supplier<List<String>> supplier() {
        return LinkedList::new;
    }

    @Override
    public BiConsumer<List<String>, Map.Entry<String, String>> accumulator() {
        return (a, b) -> {
            if (this.colNames.containsKey(((String)b.getKey()).toLowerCase())) {
                a.add(this.prepareCell((Map.Entry<String, String>)b, this.colNames));
            }
        };
    }

    @Override
    public BinaryOperator<List<String>> combiner() {
        return (a, b) -> {
            a.addAll(b);
            return a;
        };
    }

    @Override
    public Function<List<String>, String> finisher() {
        return a -> {
            StringJoiner stringJoiner = new StringJoiner(this.delimiter);
            a.forEach(stringJoiner::add);
            return stringJoiner.toString();
        };
    }

    private String prepareCell(Map.Entry<String, String> b, Map<String, Integer> colNames) {
        Object value = b.getValue();
        if (this.hasTabulation) {
            Integer maxWidth = colNames.get(b.getKey().toLowerCase());
            value = b.getValue();
            if (((String)value).length() > maxWidth - 1 - this.cellSurround.length() * 2) {
                value = ((String)value).substring(0, maxWidth - 4) + "...";
            }
            value = (String)value + RowRender.fill(maxWidth - ((String)value).length(), " ");
        }
        value = this.cellSurround + (String)value + this.cellSurround;
        return value;
    }

    public static String fill(int length, String brick) {
        return Stream.generate(() -> brick).limit(length).collect(Collectors.joining());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of();
    }
}

