/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.JdbcView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class PersistedDb
implements JdbcView {
    private final Path storeDir;
    private Connection connection;
    protected Path lastStore;
    protected boolean schemaCreated = false;

    public PersistedDb(Path storeDir) {
        this.storeDir = storeDir.toAbsolutePath();
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Files.createDirectories(this.storeDir, new FileAttribute[0]);
            boolean justCreated = !this.storeExists();
            String jdbcURL = "jdbc:h2:" + String.valueOf(this.storeDir.resolve("data"));
            this.connection = DriverManager.getConnection(jdbcURL, "", "");
            System.out.println("Connected to H2 embedded database.");
            if (justCreated) {
                this.createSchema();
                this.reindex();
            }
            return this.connection;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean storeExists() {
        this.lastStore = this.lastStore == null ? this.storeDir.resolve("data.mv.db") : this.lastStore;
        return Files.exists(this.lastStore, new LinkOption[0]);
    }

    protected void createSchema() throws SQLException {
        if (this.storeExists()) {
            this.schemaCreated = true;
        }
    }

    protected abstract void reindex();

    @Override
    public PersistedDb drop() {
        try {
            this.connection = null;
            if (this.storeExists()) {
                Files.deleteIfExists(this.lastStore);
                this.schemaCreated = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

