/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.sql.FilesIndex;
import io.github.andreyzebin.gitSql.sql.PersistedDb;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitsIndex
extends PersistedDb {
    private static final Logger log = LoggerFactory.getLogger(CommitsIndex.class);
    private final VersionControl git;

    public CommitsIndex(VersionControl git, Path storeDir) {
        super(storeDir);
        this.git = git;
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);";
            log.debug(CommitsIndex.renderSqlLog("CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);"));
            dml.execute("CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);");
        }
        super.createSchema();
    }

    public static String renderSqlLog(String sql) {
        return System.lineSeparator() + "---" + System.lineSeparator() + sql.lines().map(cLine -> String.valueOf((Object)Color.RED) + cLine + String.valueOf((Object)Color.RESET)).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "---";
    }

    @Override
    protected void reindex() {
        try {
            this.git.commits().forEach(cF -> FilesIndex.merge(this.getConnection(), "commits", "hash", "timestamp", cF.getHash(), cF.getTimestamp()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

